/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.util.Guid;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorMessages;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class PasteModelChange
extends Change {
    private EMFRefactoringTransaction context;
    protected IPath destination;
    protected IProxyNode proxy;
    private boolean shouldBeRenamed;
    private RefactoringStatus status;
    private String newName = null;
    private String newBaseName = null;

    public PasteModelChange(IRefactoringContext context, IProxyNode node, IPath destinationPath, String[] targetName) {
        this.proxy = node;
        this.destination = destinationPath;
        this.context = (EMFRefactoringTransaction)context.getRefactoringTransaction("org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction");
        Assert.isNotNull((Object)this.context);
        this.status = new RefactoringStatus();
        IFile destFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.destination);
        if (destFile.exists()) {
            this.handleFileAlreadyExists(this.status);
        }
        this.newName = this.getNewName();
        if (targetName != null && targetName.length > 0) {
            targetName[0] = this.newName;
        }
    }

    public Object getModifiedElement() {
        return this.proxy;
    }

    public String getName() {
        String fileName = this.proxy.getUnderlyingResource().getFullPath().toString();
        return NLS.bind((String)RefactoringMessages.PASTE_PROXY, (Object)fileName, (Object)this.newName);
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus localStatus = this.status;
        if (!TestUIUtil.isResourcePathLengthValid(this.destination.toOSString())) {
            localStatus.addFatalError(RefactoringMessages.LONG_NAME);
        }
        return localStatus;
    }

    protected void handleFileAlreadyExists(RefactoringStatus status) {
        this.shouldBeRenamed = true;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (this.proxy instanceof EObjectProxyNode) {
            Resource res = this.context.getResourceSet().getResource(((EObjectProxyNode)this.proxy).getOriginatorURI().trimFragment(), true);
            res.setURI(this.getNewURI());
            try {
                EObject object;
                EMFUtil.save((Resource)res);
                EMFUtil.getWorkspaceFile((Resource)res).refreshLocal(0, pm);
                EList objects = res.getContents();
                if (!objects.isEmpty() && (object = (EObject)objects.get(0)) instanceof CMNNamedElement) {
                    CMNNamedElement cmNamedElement = (CMNNamedElement)object;
                    if (this.shouldBeRenamed) {
                        cmNamedElement.setName(this.newBaseName);
                    }
                    cmNamedElement.setId(new Guid().toString());
                    EMFUtil.save((Resource)res);
                    EMFUtil.getWorkspaceFile((Resource)res).refreshLocal(0, pm);
                }
            }
            catch (Exception e) {
                UiPlugin.logError(e);
            }
        }
        return new UndoPasteModelChange();
    }

    public URI getNewURI() {
        return URI.createPlatformResourceURI((String)this.newName, (boolean)false);
    }

    private String getNewName() {
        if (this.shouldBeRenamed) {
            boolean done = false;
            String fullFileName = this.destination.lastSegment();
            int dotIndex = fullFileName.lastIndexOf(46);
            String basePart = fullFileName.substring(0, dotIndex);
            String endPart = fullFileName.substring(dotIndex);
            String newFullName = null;
            String ret = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (!done) {
                this.newBaseName = i != 0 ? NLS.bind((String)TestNavigatorMessages.FileFolderInContainerPaste_NameTwoArg, (Object)new Integer(i), (Object)basePart) : NLS.bind((String)TestNavigatorMessages.FileFolderInContainerPaste_NameOneArg, (Object)basePart);
                newFullName = String.valueOf(this.newBaseName) + endPart;
                ret = this.destination.removeLastSegments(1).append(newFullName).toPortableString();
                Path newpath = new Path(ret);
                done = !root.getFolder((IPath)newpath).exists() && !root.getFile((IPath)newpath).exists();
                ++i;
            }
            return ret;
        }
        return this.destination.toPortableString();
    }

    private class UndoPasteModelChange
    extends Change {
        private UndoPasteModelChange() {
        }

        public Object getModifiedElement() {
            return null;
        }

        public String getName() {
            return null;
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            return null;
        }
    }
}

