/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.CompositeListenerChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.CustomRefactoringManager;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.PasteContainerChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.PasteFileChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.PasteFolderCompositeChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.RefactoringContext;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.RefactoringTransactionRootChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodePaster;
import org.eclipse.hyades.test.ui.navigator.refactoring.AbstractPasteChange;
import org.eclipse.hyades.test.ui.navigator.refactoring.PasteRefactoringEvent;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class PasteRefactoring
extends Refactoring {
    private Change change;
    private IContainer destination;
    private RefactoringContext context;
    protected List seenElements = new LinkedList();
    private List folders;
    private List proxies;
    private List externalFiles;

    public PasteRefactoring(List folders, List proxies, List externalFiles) {
        this.context = new RefactoringContext();
        this.folders = folders;
        this.proxies = proxies;
        this.externalFiles = externalFiles;
    }

    public List getContainers() {
        return this.folders;
    }

    public List getProxies() {
        return this.proxies;
    }

    public String getName() {
        return RefactoringMessages.UPDATE_OWNED_RESSOURCES_REFERENCES;
    }

    public void setDestination(IContainer container) {
        this.destination = container;
        this.change = null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask("", 3);
        try {
            try {
                TestUIUtilities.createProxyNodes((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            catch (OperationCanceledException operationCanceledException) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringMessages.ReorgRefactoring_CANCELED_OPERATION_MSG);
                pm.done();
                return refactoringStatus;
            }
            this.change = this.createChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
            RefactoringStatus valid = this.change.isValid((IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (!valid.isOK()) {
                this.change = null;
            }
            RefactoringStatus refactoringStatus = valid;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.change != null) {
            return this.change;
        }
        pm.beginTask("", this.folders.size() + this.proxies.size() + this.externalFiles.size());
        try {
            RefactoringTransactionRootChange c = new RefactoringTransactionRootChange(this.context);
            CustomRefactoringManager.addAllStartingChange(c, 3);
            Iterator it = this.folders.iterator();
            while (it.hasNext()) {
                Change containerChange = this.createPasteContainerChange((IFolder)it.next(), this.destination);
                if (containerChange != null) {
                    c.add(containerChange);
                }
                pm.worked(1);
            }
            it = this.proxies.iterator();
            while (it.hasNext()) {
                Change refChange = this.createPasteProxyChange((IProxyNode)it.next(), this.destination);
                if (refChange != null) {
                    c.add(refChange);
                }
                pm.worked(1);
            }
            for (String externalFileName : this.externalFiles) {
                File theFile = new File(externalFileName);
                AbstractPasteChange refChange = null;
                if (theFile.isFile()) {
                    refChange = new PasteFileChange(externalFileName, this.destination);
                } else if (theFile.isDirectory()) {
                    refChange = new PasteContainerChange(externalFileName, this.destination);
                }
                if (refChange != null) {
                    PasteRefactoringEvent event = new PasteRefactoringEvent(externalFileName, this.destination);
                    CompositeListenerChange composite = new CompositeListenerChange(event);
                    composite.add(refChange);
                    c.add((Change)composite);
                }
                pm.worked(1);
            }
            CustomRefactoringManager.addAllEndingChange(c, 3);
            c.markAsSynthetic();
            RefactoringTransactionRootChange refactoringTransactionRootChange = c;
            return refactoringTransactionRootChange;
        }
        finally {
            pm.done();
        }
    }

    private Change createPasteContainerChange(IFolder folder, IContainer dest) {
        PasteRefactoringEvent event = new PasteRefactoringEvent((IResource)folder, dest);
        CompositeListenerChange composite = new CompositeListenerChange(event);
        IPath[] finalPath = new IPath[1];
        PasteFolderCompositeChange change = new PasteFolderCompositeChange(folder, dest.getFullPath(), finalPath);
        this.performContainerChildren(change, (IContainer)folder, finalPath[0]);
        change.freeze();
        composite.add((Change)change);
        return composite;
    }

    private Change performContainerChildren(CompositeChange change, IContainer source, IPath newPath) {
        if (source.isAccessible()) {
            IResource[] resources;
            try {
                resources = source.members();
            }
            catch (CoreException e) {
                UiPlugin.logError("Unable to get members of container: " + source.getFullPath().toOSString(), e);
                return null;
            }
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFile) {
                    IFile file = (IFile)resources[i];
                    IProxyNode proxy = FileProxyNodeCache.getInstance().getProxy(file);
                } else {
                    this.performContainerChildren(change, (IContainer)resources[i], newPath.append(resources[i].getName()));
                }
                ++i;
            }
        }
        return change;
    }

    private Change createShallowPasteProxyChange(IProxyNode node, IContainer dest, String[] targetName) {
        PasteFileChange mainChange;
        IFile file = (IFile)node.getAdapter(IFile.class);
        IProxyNodePaster paster = (IProxyNodePaster)node.getAdapter(IProxyNodePaster.class);
        if (paster != null) {
            String fileName = file == null ? node.getUnderlyingResource().getName() : file.getName();
            IPath newPath = dest.getFullPath().append(fileName);
            mainChange = paster.createPasteChange(this.context, newPath, targetName);
        } else if (file != null) {
            mainChange = new PasteFileChange(file, dest);
        } else {
            return new NullChange(NLS.bind((String)RefactoringMessages.UPDATE_PROXY, (Object)node.getUnderlyingResource().getFullPath().toPortableString()));
        }
        PasteRefactoringEvent event = new PasteRefactoringEvent(node, dest);
        CompositeListenerChange composite = new CompositeListenerChange(event);
        composite.add(mainChange);
        return composite;
    }

    protected Change createPasteProxyChange(IProxyNode node, IContainer dest) {
        if (!this.seenElements.contains(node)) {
            this.seenElements.add(node);
            if (node instanceof IReferencerProxyNode) {
                Change change = this.createPasteReferencerChange((IReferencerProxyNode)node, dest, new String[1]);
                return change;
            }
            return this.createShallowPasteProxyChange(node, dest, new String[1]);
        }
        return null;
    }

    private Change createPasteReferencerChange(IReferencerProxyNode nodeA, IContainer dest, String[] targetName) {
        CompositeChange composite = new CompositeChange(NLS.bind((String)RefactoringMessages.PASTE_PROXY, (Object)nodeA.getText(), (Object)dest.getName()));
        Change pasteNode = this.createShallowPasteProxyChange(nodeA, dest, targetName);
        if (pasteNode != null) {
            composite.add(pasteNode);
        }
        return composite;
    }
}

