/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class RenameContainerChange
extends CompositeChange {
    private IContainer container;
    private boolean isFolder;
    private String newName;

    public RenameContainerChange(IContainer container, String newName) {
        super("");
        this.container = container;
        this.newName = newName;
        this.isFolder = container.getFullPath().segmentCount() > 1;
    }

    public Object getModifiedElement() {
        return this.container;
    }

    public String getName() {
        IPath path = this.container.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
        return NLS.bind((String)RefactoringMessages.RENAME_CONTAINER, (Object)path.toString(), (Object)path.removeLastSegments(1).append(this.newName));
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ResourceAttributes att;
        RefactoringStatus status = new RefactoringStatus();
        IContainer newContainer = this.getNewContainer();
        if (!this.container.isAccessible()) {
            if (this.isFolder) {
                status.addError(RefactoringMessages.NO_FOLDER);
            } else {
                status.addError(RefactoringMessages.NO_PROJECT);
            }
        }
        if ((att = this.container.getResourceAttributes()) != null && att.isReadOnly()) {
            if (this.isFolder) {
                status.addError(RefactoringMessages.READ_ONLY_FOLDER);
            } else {
                status.addError(RefactoringMessages.READ_ONLY_PROJECT);
            }
        }
        if (newContainer.exists()) {
            if (this.isFolder) {
                status.addError(NLS.bind((String)RefactoringMessages.ALREADY_EXISTS_FOLDER, (Object)newContainer.getName()));
            } else {
                status.addError(NLS.bind((String)RefactoringMessages.ALREADY_EXISTS_PROJECT, (Object)newContainer.getName()));
            }
        }
        return status;
    }

    private IContainer getNewContainer() {
        if (this.isFolder) {
            return this.container.getParent().getFolder((IPath)new Path(this.newName));
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.newName);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Change ret = this.isFolder ? this.performFolder(pm) : this.performProject(pm);
        TestUIUtilities.recursiveRefreshProxy((IResource)this.getNewContainer());
        return ret;
    }

    private Change performProject(IProgressMonitor pm) {
        pm.beginTask("", 2);
        try {
            IProject project = (IProject)this.container;
            String originalName = project.getName();
            try {
                super.perform((IProgressMonitor)new SubProgressMonitor(pm, 1));
                IProjectDescription description = project.getDescription();
                IPath newPath = this.container.getFullPath().removeLastSegments(1).append(this.newName);
                description.setName(newPath.segment(0));
                project.move(description, 33, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            catch (CoreException e) {
                UiPlugin.logError(e);
            }
            IProject renamedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.newName);
            RenameContainerChange renameContainerChange = new RenameContainerChange((IContainer)renamedProject, originalName);
            return renameContainerChange;
        }
        finally {
            pm.done();
        }
    }

    private Change performFolder(IProgressMonitor pm) {
        pm.beginTask("", 2);
        try {
            IFolder folder = (IFolder)this.container;
            String originalName = folder.getName();
            IPath newPath = folder.getFullPath().removeLastSegments(1).append(this.newName);
            try {
                super.perform((IProgressMonitor)new SubProgressMonitor(pm, 1));
                folder.move(newPath, 2, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            catch (CoreException e) {
                UiPlugin.logError(e);
            }
            IFolder renamedFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(newPath);
            RenameContainerChange renameContainerChange = new RenameContainerChange((IContainer)renamedFolder, originalName);
            return renameContainerChange;
        }
        finally {
            pm.done();
        }
    }

    public void freeze() {
        if (this.getChildren().length == 0) {
            this.markAsSynthetic();
            this.add((Change)new NullChange(this.getName()));
        }
    }
}

