/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.PhysicalDeleteChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class ReorgContainerChange
extends PhysicalDeleteChange {
    private IPath path;

    public ReorgContainerChange(IContainer cont) {
        this.path = ReorgContainerChange.getPath(cont);
    }

    public static IPath getPath(IContainer container) {
        return container.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
    }

    private IContainer getContainer(IPath path) {
        if (path.segmentCount() == 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
    }

    public IPath getPath() {
        return this.path;
    }

    public Object getModifiedElement() {
        return this.getContainer(this.path);
    }

    public abstract String getName();

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        Object modified = this.getModifiedElement();
        ResourceAttributes resAtt = null;
        if (modified instanceof IResource) {
            IResource resource = (IResource)modified;
            if (!resource.isAccessible()) {
                if (resource instanceof IFolder) {
                    status.addFatalError(RefactoringMessages.NO_FOLDER);
                }
                if (resource instanceof IProject) {
                    if (resource.exists()) {
                        status.addWarning(RefactoringMessages.NOT_OPEN_PROJECT);
                    } else {
                        status.addFatalError(RefactoringMessages.NOT_EXIST_PROJECT);
                    }
                }
            } else {
                resAtt = resource.getResourceAttributes();
                if (resAtt == null) {
                    status.addError(RefactoringMessages.ERROR);
                } else if (resAtt.isReadOnly()) {
                    if (resource instanceof IFolder) {
                        status.addWarning(RefactoringMessages.READ_ONLY_FOLDER);
                    }
                    if (resource instanceof IProject) {
                        status.addWarning(RefactoringMessages.READ_ONLY_PROJECT);
                    }
                }
            }
        } else {
            status.addError(RefactoringMessages.ERROR);
        }
        return status;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IContainer container = this.getContainer(this.path);
        pm.beginTask("", 1);
        try {
            Change change = this.reorgFolder(container, new SubProgressMonitor(pm, 1));
            return change;
        }
        finally {
            pm.done();
        }
    }

    public abstract Change reorgFolder(IContainer var1, SubProgressMonitor var2);
}

