/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.preference;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.hyades.test.core.TestCorePlugin;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TestPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ModifyListener {
    private Button alwaysOpenEditorButton;
    private Button neverOpenEditorButton;
    private Button promptOpenEditorButton;
    private Text saveManagerIntervalText;
    private Text defaultHostName;
    private Text defaultPort;

    public TestPreferencePage() {
        this.setPreferenceStore(UiPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        GridLayout compositePaneGroupGridLayout = new GridLayout(1, true);
        compositePaneGroupGridLayout.marginHeight = 0;
        compositePaneGroupGridLayout.marginWidth = 0;
        compositePaneGroupGridLayout.verticalSpacing = 5;
        compositePaneGroupGridLayout.horizontalSpacing = 5;
        Composite compositePane = new Composite(parent, 0);
        compositePane.setLayout((Layout)compositePaneGroupGridLayout);
        compositePane.setLayoutData((Object)new GridData(4, 4, true, true));
        Group editorGroup = new Group(compositePane, 16);
        editorGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        editorGroup.setLayout((Layout)new GridLayout(1, true));
        editorGroup.setText(UiPluginResourceBundle.EDITORS_GROUP_LABEL);
        this.alwaysOpenEditorButton = new Button((Composite)editorGroup, 16);
        this.alwaysOpenEditorButton.setText(UiPluginResourceBundle.EDITORS_GROUP_ALWAYS_LABEL);
        this.neverOpenEditorButton = new Button((Composite)editorGroup, 16);
        this.neverOpenEditorButton.setText(UiPluginResourceBundle.EDITORS_GROUP_NEVER_LABEL);
        this.promptOpenEditorButton = new Button((Composite)editorGroup, 16);
        this.promptOpenEditorButton.setText(UiPluginResourceBundle.EDITORS_GROUP_PROMPT_LABEL);
        Group locationGroup = new Group(compositePane, 16);
        locationGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        locationGroup.setLayout((Layout)new GridLayout(2, false));
        locationGroup.setText(UiPluginResourceBundle.LOCATION_GROUP_LABEL);
        Label defaultHostNameLabel = new Label((Composite)locationGroup, 0);
        defaultHostNameLabel.setText(UiPluginResourceBundle.DEFAULT_HOST_NAME);
        this.defaultHostName = new Text((Composite)locationGroup, 2048);
        this.defaultHostName.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.defaultHostName.addModifyListener((ModifyListener)this);
        Label defaultPortLabel = new Label((Composite)locationGroup, 0);
        defaultPortLabel.setText(UiPluginResourceBundle.DEFAULT_PORT);
        this.defaultPort = new Text((Composite)locationGroup, 2048);
        this.defaultPort.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.defaultPort.addModifyListener((ModifyListener)this);
        Link testConnectionLink = new Link((Composite)locationGroup, 0);
        testConnectionLink.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        testConnectionLink.setText("<a>" + UiPluginResourceBundle.TEST_CONNECTION_NAME + "</a>");
        testConnectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TestUIUtilities.testConnection(TestPreferencePage.this.defaultHostName.getText(), TestPreferencePage.this.defaultPort.getText());
            }
        });
        Group testExecutionGroup = new Group(compositePane, 16);
        testExecutionGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        testExecutionGroup.setLayout((Layout)new GridLayout(2, false));
        testExecutionGroup.setText(UiPluginResourceBundle.EXECUTION_GROUP_LABEL);
        Label saveManagerIntervalLabel = new Label((Composite)testExecutionGroup, 0);
        saveManagerIntervalLabel.setText(UiPluginResourceBundle.SAVE_INT_PREF);
        this.saveManagerIntervalText = new Text((Composite)testExecutionGroup, 2048);
        this.saveManagerIntervalText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.initializeValues();
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UiPlugin.getID()) + ".tgpp0001");
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.defaultHostName, String.valueOf(UiPlugin.getID()) + ".tgpp0003");
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.defaultPort, String.valueOf(UiPlugin.getID()) + ".tgpp0004");
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.alwaysOpenEditorButton, String.valueOf(UiPlugin.getID()) + ".tgpp0002");
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.neverOpenEditorButton, String.valueOf(UiPlugin.getID()) + ".tgpp0002");
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.promptOpenEditorButton, String.valueOf(UiPlugin.getID()) + ".tgpp0002");
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.saveManagerIntervalText, String.valueOf(UiPlugin.getID()) + ".tgpp0005");
        Dialog.applyDialogFont((Control)compositePane);
        return compositePane;
    }

    private void initializeValues() {
        IPreferenceStore testuiStore = this.getPreferenceStore();
        TestCorePlugin.getDefault().getPluginPreferences();
        this.setOpenEditorButtonSelection(testuiStore.getString("openEditor"));
        this.saveManagerIntervalText.setText(String.valueOf(testuiStore.getLong("saveInterval")));
        this.defaultHostName.setText(testuiStore.getString("default_host_name"));
        this.defaultPort.setText(testuiStore.getString("default_port"));
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return UiPlugin.getInstance().getPreferenceStore();
    }

    private void initializeDefaults() {
        IPreferenceStore testuiStore = this.getPreferenceStore();
        Preferences testcorePrefs = TestCorePlugin.getDefault().getPluginPreferences();
        this.setOpenEditorButtonSelection(testuiStore.getDefaultString("openEditor"));
        this.saveManagerIntervalText.setText(String.valueOf(testcorePrefs.getDefaultLong("saveInterval")));
        this.defaultHostName.setText(testcorePrefs.getDefaultString("default_host_name"));
        this.defaultPort.setText(testcorePrefs.getDefaultString("default_port"));
    }

    public boolean performOk() {
        this.storeValues();
        UiPlugin.getInstance().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IPreferenceStore testuiStore = this.getPreferenceStore();
        Preferences testcorePrefs = TestCorePlugin.getDefault().getPluginPreferences();
        testuiStore.setValue("openEditor", this.getOpenEditorButtonSelection());
        try {
            testcorePrefs.setValue("saveInterval", Long.parseLong(this.saveManagerIntervalText.getText().trim()));
            testuiStore.setValue("saveInterval", Long.parseLong(this.saveManagerIntervalText.getText().trim()));
        }
        catch (NumberFormatException n) {
            UiPlugin.logError(n);
        }
        testcorePrefs.setValue("default_port", this.defaultPort.getText().trim());
        testcorePrefs.setValue("default_host_name", this.defaultHostName.getText().trim());
        testuiStore.setValue("default_port", this.defaultPort.getText().trim());
        testuiStore.setValue("default_host_name", this.defaultHostName.getText().trim());
    }

    public void init(IWorkbench workbench) {
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.defaultPort) {
            if (!TestUIUtilities.isValidPort(this.defaultPort.getText())) {
                this.setErrorMessage(UiPluginResourceBundle._ERROR_INVALID_PORT_RANGE);
                this.defaultPort.setFocus();
            } else {
                this.setErrorMessage(null);
            }
        } else if (e.widget == this.defaultHostName) {
            if (!TestUIUtilities.isValidHostName(this.defaultHostName.getText())) {
                this.setErrorMessage(UiPluginResourceBundle._ERROR_INVALID_HOST_NAME);
                this.defaultHostName.setFocus();
            } else {
                this.setErrorMessage(null);
            }
        }
    }

    private void setOpenEditorButtonSelection(String selection) {
        if (selection.equals("always")) {
            this.alwaysOpenEditorButton.setSelection(true);
            this.neverOpenEditorButton.setSelection(false);
            this.promptOpenEditorButton.setSelection(false);
        } else if (selection.equals("never")) {
            this.alwaysOpenEditorButton.setSelection(false);
            this.neverOpenEditorButton.setSelection(true);
            this.promptOpenEditorButton.setSelection(false);
        } else {
            this.alwaysOpenEditorButton.setSelection(false);
            this.neverOpenEditorButton.setSelection(false);
            this.promptOpenEditorButton.setSelection(true);
        }
    }

    private String getOpenEditorButtonSelection() {
        if (this.alwaysOpenEditorButton.getSelection()) {
            return "always";
        }
        if (this.neverOpenEditorButton.getSelection()) {
            return "never";
        }
        return "prompt";
    }
}

