/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.internal.search.ILogResultContentProvider;
import org.eclipse.hyades.test.ui.internal.search.TestLogSearchResult;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class LogResultTreeContentProvider
implements ITreeContentProvider,
ILogResultContentProvider {
    private TreeViewer viewer;
    private TestLogSearchResult result;
    private HashMap childrenMap;

    public LogResultTreeContentProvider(TreeViewer treeViewer) {
        this.viewer = treeViewer;
    }

    public synchronized void init(TestLogSearchResult sResult) {
        this.result = sResult;
        this.childrenMap = new HashMap();
        if (this.result != null) {
            Object[] elements = this.result.getElements();
            int i = 0;
            while (i < elements.length) {
                this.insert(elements[i], false);
                ++i;
            }
        }
    }

    public Object[] getChildren(Object parentElement) {
        Set children = (Set)this.childrenMap.get(parentElement);
        if (children == null) {
            return new Object[0];
        }
        return children.toArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getParent(Object element) {
        TPFExecutionResult executionResult;
        if (element instanceof TPFExecutionEvent) {
            TPFExecutionEvent executionEvent = (TPFExecutionEvent)element;
            if (!(executionEvent.eContainer() instanceof TPFExecutionHistory)) return executionEvent.eContainer();
            TPFExecutionHistory exhis = (TPFExecutionHistory)executionEvent.eContainer();
            TPFExecutionResult exres = exhis.getExecutionResult();
            if (exres.eContainer() == null) return null;
            return exhis.getExecutionResult();
        }
        if (element instanceof TPFExecutionHistory) {
            return ((TPFExecutionHistory)element).getExecutionResult();
        }
        if (!(element instanceof TPFExecutionResult) || (executionResult = (TPFExecutionResult)element).getInvocationExecutionEvent() == null) return null;
        return executionResult.getInvocationExecutionEvent();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        if (this.childrenMap != null) {
            this.childrenMap.clear();
            this.childrenMap = null;
        }
        this.result = null;
        this.viewer = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof TestLogSearchResult) {
            this.init((TestLogSearchResult)((Object)newInput));
        }
    }

    protected void insert(Object child, boolean refreshViewer) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (refreshViewer) {
                    this.viewer.add(parent, child);
                }
            } else {
                if (refreshViewer) {
                    this.viewer.refresh(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild((Object)this.result, child) && refreshViewer) {
            this.viewer.add((Object)this.result, child);
        }
    }

    private boolean insertChild(Object parent, Object child) {
        HashSet<Object> children = (HashSet<Object>)this.childrenMap.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            this.childrenMap.put(parent, children);
        }
        return children.add(child);
    }

    protected void remove(Object element, boolean refreshViewer) {
        if (this.hasChildren(element)) {
            if (refreshViewer) {
                this.viewer.refresh(element);
            }
        } else if (this.result.getMatchCount(element) == 0) {
            this.childrenMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                this.removeFromSiblings(element, parent);
                this.remove(parent, refreshViewer);
            } else {
                this.removeFromSiblings(element, (Object)this.result);
                if (refreshViewer) {
                    this.viewer.refresh();
                }
            }
        } else if (refreshViewer) {
            this.viewer.refresh(element);
        }
    }

    private void removeFromSiblings(Object element, Object parent) {
        Set siblings = (Set)this.childrenMap.get(parent);
        if (siblings != null) {
            siblings.remove(element);
        }
    }

    public void elementsChanged(Object[] updatedElements) {
        int i = 0;
        while (i < updatedElements.length) {
            if (this.result.getMatchCount(updatedElements[i]) > 0) {
                this.insert(updatedElements[i], true);
            } else {
                this.remove(updatedElements[i], true);
            }
            ++i;
        }
    }

    public void clear() {
        this.init(this.result);
        this.viewer.refresh();
    }
}

