/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.search;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.ExecutionEventSearchProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class LoopEventSearchProvider
extends ExecutionEventSearchProvider {
    private boolean searchAsynchronous;
    private Boolean asynchronous = Boolean.FALSE;
    private Button asyncButton;
    private Combo asyncCombo;
    private boolean searchIterations;
    private Integer iterations = new Integer(0);
    private Button iterButton;
    private Spinner iterSpinner;

    public void createContents(Composite parent) {
        super.createContents(parent);
        Group group = new Group(parent, 16);
        group.setText(UiPluginResourceBundle.TestLogSearch_LimitToLoops);
        group.setLayoutData((Object)new GridData());
        group.setLayout((Layout)new GridLayout(2, false));
        this.asyncButton = new Button((Composite)group, 32);
        this.asyncButton.setText(UiPluginResourceBundle.TestLogSearch_Asynchronous);
        this.asyncButton.addSelectionListener((SelectionListener)this);
        this.asyncCombo = new Combo((Composite)group, 2056);
        this.asyncCombo.setItems(new String[]{UiPluginResourceBundle.Word_False, UiPluginResourceBundle.Word_True});
        this.asyncCombo.setText(UiPluginResourceBundle.Word_False);
        this.asyncCombo.setLayoutData((Object)new GridData(768));
        this.asyncCombo.addSelectionListener((SelectionListener)this);
        this.asyncCombo.setEnabled(false);
        this.iterButton = new Button((Composite)group, 32);
        this.iterButton.setText(UiPluginResourceBundle.TestLogSearch_Iterations);
        this.iterButton.addSelectionListener((SelectionListener)this);
        this.iterSpinner = new Spinner((Composite)group, 2048);
        this.iterSpinner.setMinimum(0);
        this.iterSpinner.setMaximum(Integer.MAX_VALUE);
        this.iterSpinner.addSelectionListener((SelectionListener)this);
        this.iterSpinner.setEnabled(false);
    }

    public SimpleSearchQuery createSearchQuery(EObject rootElement, String text, Map options) {
        SimpleSearchQuery query = super.createSearchQuery(rootElement, text, options);
        this.setQueryOutputType(query, Common_TestprofilePackage.eINSTANCE.getTPFLoopEvent());
        LogicalExpression executionEventOR = (LogicalExpression)query.getWhereExpression();
        LogicalExpression or = this.createORExpression();
        if (this.searchAsynchronous) {
            BinaryExpression asynchronousSearch = this.createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFLoopEvent_Asynchronous(), EcorePackage.eINSTANCE.getEBoolean(), this.asynchronous);
            or.getArguments().add((Object)asynchronousSearch);
        }
        if (this.searchIterations) {
            BinaryExpression iterationsSearch = this.createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFLoopEvent_Iterations(), EcorePackage.eINSTANCE.getEIntegerObject(), this.iterations);
            or.getArguments().add((Object)iterationsSearch);
        }
        this.combineExecutionEventAndElementExpressions(query, executionEventOR, or);
        return query;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.asyncButton) {
            this.searchAsynchronous = this.asyncButton.getSelection();
            this.asyncCombo.setEnabled(this.asyncButton.getSelection());
        } else if (e.widget == this.asyncCombo) {
            this.asynchronous = UiPluginResourceBundle.Word_False.equals(this.asyncCombo.getText()) ? Boolean.FALSE : Boolean.TRUE;
        } else if (e.widget == this.iterButton) {
            this.searchIterations = this.iterButton.getSelection();
            this.iterSpinner.setEnabled(this.iterButton.getSelection());
        } else if (e.widget == this.iterSpinner) {
            this.iterations = new Integer(this.iterSpinner.getSelection());
        }
        super.widgetSelected(e);
    }
}

