/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.search;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.forms.editor.TestLogViewer;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.ITestLogSearchProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.search.TestLogSearchQuery;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.osgi.framework.Bundle;

public class TestLogSearchPage
extends DialogPage
implements ISearchPage,
ModifyListener,
SelectionListener {
    public static final String TEST_LOG_SEARCH_PAGE_ID = "org.eclipse.hyades.test.ui.search.TestLogSearchPage";
    public static final String SEARCH_OPTION_CASE_SENSITIVE = "caseSensitive";
    public static final String SEARCH_OPTION_DEPTH = "depth";
    public static final String WILD_CARD = "*";
    public static final String PROVIDER_EXT_POINT_ID = ".testLogSearchProvider";
    public static final String PROVIDER_EXT_ELEM_PROVIDER = "provider";
    public static final String PROVIDER_EXT_ATTR_LABEL = "label";
    public static final String PROVIDER_EXT_ATTR_ICON = "icon";
    private TPFExecutionResult testLog;
    private EObject eventSelection;
    private EObject rootElement;
    private IEditorInput editorInput;
    private ResourceSet resourceSet;
    private ISearchPageContainer pageContainer;
    private Table elementsTable;
    private List checkedElements = new ArrayList();
    private CLabel elementTitle;
    private ScrolledPageBook detailsPageBook;
    private SearchExtension[] elementSearchProviders;
    private String searchText;
    private Text searchTextField;
    private boolean caseSensitive;
    private Button caseSensitiveCheck;
    private boolean inChildrenOnly;
    private Button inChildrenOnlyCheck;
    private boolean recursive;
    private Button recursiveCheck;

    public boolean performAction() {
        ISearchQuery query = this.createSearchQuery();
        if (query != null) {
            NewSearchUI.runQueryInBackground((ISearchQuery)query);
        }
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
        this.pageContainer = container;
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setFont(parent.getFont());
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart instanceof TestLogViewer) {
            this.testLog = (TPFExecutionResult)((TestLogViewer)editorPart).getEditorObject();
            this.rootElement = this.testLog;
            this.editorInput = editorPart.getEditorInput();
            this.resourceSet = ((TestLogViewer)editorPart).getResourceSet();
            IStructuredSelection sel = (IStructuredSelection)((TestLogViewer)editorPart).getSelection();
            if (sel != null && !sel.isEmpty()) {
                Object first = sel.getFirstElement();
                this.eventSelection = first instanceof TPFExecutionEvent || first instanceof TPFExecutionResult ? (EObject)first : null;
            }
        }
        if (this.testLog == null) {
            Label label = new Label(control, 64);
            label.setText(UiPluginResourceBundle.TestLogSearch_NoOpenLogMessage);
            label.setLayoutData((Object)new GridData(4));
        } else {
            this.createTextSearchControls(control);
            this.createElementSearchControls(control);
        }
        this.setControl((Control)control);
        Dialog.applyDialogFont((Control)control);
    }

    protected void createTextSearchControls(Composite parent) {
        Composite searchTextParent = new Composite(parent, 0);
        searchTextParent.setLayoutData((Object)new GridData(770));
        searchTextParent.setLayout((Layout)new GridLayout(3, false));
        Label searchText = new Label(searchTextParent, 0);
        searchText.setText(UiPluginResourceBundle.TestLogSearch_SearchForText);
        this.searchTextField = new Text(searchTextParent, 2048);
        GridData gd = new GridData(768);
        this.searchTextField.setLayoutData((Object)gd);
        this.searchTextField.addModifyListener((ModifyListener)this);
        this.caseSensitiveCheck = new Button(searchTextParent, 32);
        this.caseSensitiveCheck.setText(UiPluginResourceBundle.TestLogSearch_CaseSensitive);
        this.caseSensitiveCheck.addSelectionListener((SelectionListener)this);
        this.inChildrenOnlyCheck = new Button(searchTextParent, 32);
        this.inChildrenOnlyCheck.setText(UiPluginResourceBundle.TestLogSearch_RestrictToDescendants);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.inChildrenOnlyCheck.setLayoutData((Object)gd);
        this.inChildrenOnlyCheck.addSelectionListener((SelectionListener)this);
        if (this.eventSelection == null) {
            this.inChildrenOnlyCheck.setEnabled(false);
        }
    }

    protected void createElementSearchControls(Composite parent) {
        SashForm sashForm = new SashForm(parent, 256);
        GridData gd = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)gd);
        sashForm.setLayout((Layout)new FillLayout());
        Composite searchElement = new Composite((Composite)sashForm, 0);
        searchElement.setLayoutData((Object)new GridData(1040));
        searchElement.setLayout((Layout)new GridLayout());
        Label searchElementLabel = new Label(searchElement, 0);
        searchElementLabel.setText(UiPluginResourceBundle.TestLogSearch_ElementToSearch);
        this.elementsTable = new Table(searchElement, 2080);
        gd = new GridData(1808);
        gd.heightHint = 200;
        this.elementsTable.setLayoutData((Object)gd);
        this.elementsTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    if (e.detail == 32) {
                        if (((TableItem)e.item).getChecked()) {
                            TestLogSearchPage.this.checkedElements.add(e.item);
                        } else {
                            TestLogSearchPage.this.checkedElements.remove(e.item);
                        }
                    }
                    TestLogSearchPage.this.updateSearchButton();
                    TableItem[] selection = TestLogSearchPage.this.elementsTable.getSelection();
                    if (selection.length == 0 || selection[0] != e.item) {
                        TestLogSearchPage.this.elementsTable.setSelection((TableItem)e.item);
                    }
                    TestLogSearchPage.this.elementTitle.setImage(((TableItem)e.item).getImage());
                    TestLogSearchPage.this.elementTitle.setText(((TableItem)e.item).getText());
                    TestLogSearchPage.this.detailsPageBook.showPage((Object)e.item);
                }
            }
        });
        this.checkedElements.clear();
        Composite elementDetails = new Composite((Composite)sashForm, 0);
        elementDetails.setLayout((Layout)new GridLayout());
        elementDetails.setLayoutData((Object)new GridData(1792));
        this.elementTitle = new CLabel(elementDetails, 0x804808);
        this.elementTitle.setLayoutData((Object)new GridData(768));
        this.elementTitle.setBackground(Display.getCurrent().getSystemColor(1));
        this.elementTitle.setText(UiPluginResourceBundle.TestLogSearch_MoreOptions);
        this.detailsPageBook = new ScrolledPageBook(elementDetails, 0);
        this.detailsPageBook.setLayoutData((Object)new GridData(4, 4, true, true));
        SearchExtension[] providers = this.getElementSearchProviders();
        int i = 0;
        while (i < providers.length) {
            TableItem item = new TableItem(this.elementsTable, 0);
            item.setText(providers[i].getLabel());
            item.setImage(providers[i].getIcon());
            item.setData((Object)providers[i].getSearchProvider());
            Composite page = this.detailsPageBook.createPage((Object)item);
            providers[i].getSearchProvider().createContents(page);
            providers[i].getSearchProvider().setContainer(this.pageContainer);
            ++i;
        }
        sashForm.setWeights(new int[]{40, 60});
    }

    protected void updateSearchButton() {
        this.pageContainer.setPerformActionEnabled(this.checkedElements.size() > 0 && this.searchText != null && this.searchText.length() > 0);
    }

    public void setVisible(boolean visible) {
        this.updateSearchButton();
        super.setVisible(visible);
    }

    public void dispose() {
        super.dispose();
    }

    public ISearchPageContainer getContainer() {
        return this.pageContainer;
    }

    protected ISearchQuery createSearchQuery() {
        if (this.checkedElements.size() == 0) {
            return null;
        }
        Hashtable<String, Boolean> options = new Hashtable<String, Boolean>();
        options.put(SEARCH_OPTION_CASE_SENSITIVE, this.caseSensitive);
        options.put(SEARCH_OPTION_DEPTH, this.recursive);
        if (this.inChildrenOnly && this.eventSelection != null) {
            this.rootElement = this.eventSelection;
        }
        String searchQueryText = this.searchText;
        if (this.searchText == null || this.searchText.trim().length() == 0) {
            searchQueryText = this.searchText;
            this.searchText = WILD_CARD;
        } else {
            this.searchText = WILD_CARD + this.searchText + WILD_CARD;
        }
        if (this.checkedElements.size() == 0) {
            return null;
        }
        SimpleSearchQuery[] queries = new SimpleSearchQuery[this.checkedElements.size()];
        int i = 0;
        while (i < this.checkedElements.size()) {
            ITestLogSearchProvider provider = (ITestLogSearchProvider)((TableItem)this.checkedElements.get(i)).getData();
            queries[i] = provider.createSearchQuery(this.rootElement, this.searchText, options);
            ++i;
        }
        return new TestLogSearchQuery(queries, this.resourceSet, this.editorInput, this.testLog.getName(), searchQueryText);
    }

    public SearchExtension[] getElementSearchProviders() {
        if (this.elementSearchProviders == null) {
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + PROVIDER_EXT_POINT_ID);
            IConfigurationElement[] ce = ep.getConfigurationElements();
            this.elementSearchProviders = new SearchExtension[ce.length];
            int i = 0;
            while (i < ce.length) {
                this.elementSearchProviders[i] = new SearchExtension(ce[i]);
                ++i;
            }
        }
        return this.elementSearchProviders;
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.searchTextField) {
            this.searchText = this.searchTextField.getText();
            this.updateSearchButton();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.caseSensitiveCheck) {
            this.caseSensitive = this.caseSensitiveCheck.getSelection();
        } else if (e.widget == this.inChildrenOnlyCheck) {
            this.inChildrenOnly = this.inChildrenOnlyCheck.getSelection();
        } else if (e.widget == this.recursiveCheck) {
            this.recursive = this.recursiveCheck.getSelection();
        }
    }

    private class SearchExtension {
        private IConfigurationElement configElement;
        private String label;
        private Image icon;
        private ITestLogSearchProvider provider;

        public SearchExtension(IConfigurationElement ce) {
            this.configElement = ce;
        }

        public String getLabel() {
            if (this.label == null) {
                this.label = this.configElement.getAttribute(TestLogSearchPage.PROVIDER_EXT_ATTR_LABEL);
            }
            return this.label;
        }

        public Image getIcon() {
            ImageDescriptor imageDescriptor;
            String imageKey;
            if (this.icon == null && (imageKey = this.configElement.getAttribute(TestLogSearchPage.PROVIDER_EXT_ATTR_ICON)) != null && (imageDescriptor = UIUtil.getImageDescriptorFromPlugin((Bundle)Platform.getBundle((String)this.configElement.getDeclaringExtension().getNamespace()), (String)imageKey)) != null) {
                this.icon = imageDescriptor.createImage();
                UiPlugin.getInstance().getImageRegistry().put(imageKey, imageDescriptor);
            }
            return this.icon;
        }

        public ITestLogSearchProvider getSearchProvider() {
            if (this.provider == null) {
                try {
                    this.provider = (ITestLogSearchProvider)this.configElement.createExecutableExtension(TestLogSearchPage.PROVIDER_EXT_ELEM_PROVIDER);
                }
                catch (Exception e) {
                    UiPlugin.logError(e);
                }
            }
            return this.provider;
        }
    }
}

