/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.hierarchy.util.internal.SinglePassSimpleSearchQueryEngine;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.search.TestLogElementMatch;
import org.eclipse.hyades.test.ui.internal.search.TestLogSearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.ui.IEditorInput;

public class TestLogSearchQuery
implements ISearchQuery {
    private TestLogSearchResult result = null;
    private SimpleSearchQuery[] queries = null;
    private String testLogName = null;
    private IEditorInput editorInput = null;
    private String searchQueryText = null;
    private ResourceSet resourceSet = null;

    public TestLogSearchQuery(SimpleSearchQuery[] queries, ResourceSet resourceSet, IEditorInput input, String testLogName, String searchQueryText) {
        this.queries = queries;
        this.resourceSet = resourceSet;
        this.editorInput = input;
        this.testLogName = testLogName;
        this.searchQueryText = searchQueryText;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        TestLogSearchResult result = (TestLogSearchResult)this.getSearchResult();
        result.removeAll();
        try {
            SinglePassSimpleSearchQueryEngine engine = null;
            QueryResult queryResult = null;
            EList resultEntries = null;
            List resultValues = null;
            int i = 0;
            while (i < this.queries.length) {
                if (ModelDebugger.INSTANCE.debugDatabaseResourcePostfix != null) {
                    IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get((Object)LoadersUtils.getPostfix((URI)URI.createURI((String)((String)this.queries[i].getSources().get(0))).trimFragment()));
                    if (hyadesResourceExtension != null) {
                        ArrayList notLoadedTypes = new ArrayList();
                        queryResult = hyadesResourceExtension.executeQuery((Query)this.queries[i], this.resourceSet, notLoadedTypes);
                    } else {
                        engine = new SinglePassSimpleSearchQueryEngine(this.queries[i], this.resourceSet);
                        queryResult = engine.execute();
                    }
                } else {
                    engine = new SinglePassSimpleSearchQueryEngine(this.queries[i], this.resourceSet);
                    queryResult = engine.execute();
                }
                resultEntries = queryResult.getResultEntries();
                if (resultEntries.size() > 0 && (resultValues = (List)((ResultEntry)resultEntries.get(0)).getValue()).size() > 0) {
                    Iterator it = resultValues.iterator();
                    while (it.hasNext()) {
                        result.addMatch(new TestLogElementMatch((EObject)it.next()));
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            return new Status(4, UiPlugin.getID(), 4, "", (Throwable)e);
        }
        return new Status(0, UiPlugin.getID(), 0, "", null);
    }

    public String getLabel() {
        return UiPluginResourceBundle.TestLogSearch_QueryLabel;
    }

    public String getSearchQueryText() {
        return this.searchQueryText;
    }

    public String getTestLogName() {
        return this.testLogName;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.result == null) {
            this.result = new TestLogSearchResult(this);
        }
        return this.result;
    }

    public IEditorInput getEditorInput() {
        return this.editorInput;
    }
}

