/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;

public class EObjectEditorInput
extends PlatformObject
implements IFileEditorInput {
    private EObject eObject = null;
    private IFile file = null;

    public EObjectEditorInput(EObject eObject) {
        if (eObject == null) {
            throw new IllegalArgumentException();
        }
        IFile workspaceFile = EMFUtil.getWorkspaceFile((EObject)eObject);
        if (workspaceFile == null) {
            throw new IllegalArgumentException();
        }
        this.eObject = eObject;
        this.file = workspaceFile;
    }

    public EObject getEObject() {
        EObject[] eObjects;
        if (this.eObject != null) {
            try {
                EObject eObject = this.eObject;
                return eObject;
            }
            finally {
                this.eObject = null;
            }
        }
        if (this.exists() && (eObjects = EMFUtil.load((ResourceSet)new ResourceSetImpl(), (IFile)this.file)).length == 1) {
            return eObjects[0];
        }
        return null;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.file.getName());
    }

    public String getName() {
        return this.file.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.file.getFullPath().makeRelative().toString();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof IFileEditorInput && this.file.equals((Object)((IFileEditorInput)obj).getFile());
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public IFile getFile() {
        return this.file;
    }

    public IStorage getStorage() throws CoreException {
        return this.file;
    }
}

