/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.core.util.IEMFCustomDeleter;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;

public class TestCaseInvocationDeleter
implements IEMFCustomDeleter {
    private static TestCaseInvocationDeleter instance = null;
    private IFileProxyManager proxManager = null;

    private TestCaseInvocationDeleter() {
        EMFUtil.registerCustomDeleter((IEMFCustomDeleter)this);
    }

    public static TestCaseInvocationDeleter getInstance() {
        if (instance == null) {
            instance = new TestCaseInvocationDeleter();
        }
        return instance;
    }

    public void customDelete(EObject eobject) {
        if (eobject instanceof TPFTestCase) {
            this.customDelete((TPFTestCase)eobject);
            return;
        }
        if (eobject instanceof TPFTestSuite) {
            this.customDelete((TPFTestSuite)eobject);
            return;
        }
    }

    public void customDelete(TPFTestSuite testSuite) {
        for (EObject eobject : testSuite.getITestCases()) {
            this.customDelete(eobject);
        }
    }

    public void customDelete(TPFTestCase testCase) {
        HashSet<Resource> changedResources = new HashSet<Resource>();
        TPFTestSuite ts = testCase.getTestSuite();
        if (this.proxManager == null) {
            this.proxManager = TestNavigator.getFileProxyManager();
            if (this.proxManager == null) {
                return;
            }
        }
        IProxyNode prox = this.proxManager.getProxy((IFile)ts.getAdapter(IFile.class), null);
        EObjectProxyNode eproxy = null;
        if (!(prox instanceof EObjectProxyNode)) {
            return;
        }
        eproxy = (EObjectProxyNode)prox;
        Set allTypes = eproxy.getReferenceTypes();
        for (String type : allTypes) {
            if (!type.equals("TestInvoked2TestInvoker")) continue;
            Collection references = eproxy.getReferences(type);
            for (IProxyNode proxy : references) {
                if (!(proxy instanceof ITestSuiteProxyNode)) continue;
                ITestSuiteProxyNode tst2prox = (ITestSuiteProxyNode)proxy;
                TPFTestSuite testSuite = tst2prox.getTestSuite();
                TPFBehavior behav = testSuite.getBehavior();
                new ArrayList();
                List allActions = behav.getInteraction().getActions();
                int cpt = 0;
                while (cpt < allActions.size()) {
                    BVRExecutionOccurrence call = (BVRExecutionOccurrence)allActions.get(cpt);
                    ITest calledTest = call.getInvokedTest();
                    if (calledTest.getId().equals(testCase.getId())) {
                        allActions.remove(call);
                        changedResources.add(testSuite.eResource());
                        --cpt;
                    }
                    ++cpt;
                }
            }
        }
        if (changedResources.isEmpty()) {
            return;
        }
        for (Resource resource : changedResources) {
            try {
                EMFUtil.save((Resource)resource);
            }
            catch (Exception e) {
                UiPlugin.logError(e);
            }
        }
    }
}

