/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.test.core.util.ArtifactUtil;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.wizard.ArtifactSelectionPage;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;
import org.eclipse.ui.PartInitException;

public class ArtifactNewWizard
extends HyadesNewWizard {
    private ArtifactSelectionPage artifactSelectionPage = null;
    private CFGArtifact newArtifact = null;
    private TestLocationPage testLocationPage = null;

    public ArtifactNewWizard() {
        this.setWindowTitle(UiPluginResourceBundle.WIZ_ARTIFACT_TTL);
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("new_artifact_wiz.gif"));
        IDialogSettings dialogSettings = UiPlugin.getInstance().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("AritfactNewWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("ArtifactNewWizard");
        }
        this.setDialogSettings(settings);
    }

    protected LocationPage getLocationPage() {
        if (this.testLocationPage == null) {
            this.testLocationPage = new TestLocationPage("artifactLocation", this.selection);
            String fileExtension = this.getFileExtension();
            if (fileExtension != null) {
                this.testLocationPage.setFileExtension(fileExtension);
                this.testLocationPage.setFileName("");
            }
        }
        return this.testLocationPage;
    }

    protected String getType() {
        return "org.eclipse.hyades.artifact.generic";
    }

    public String getFileExtension() {
        return "artifact";
    }

    protected void initPages() {
        super.initPages();
        this.artifactSelectionPage = new ArtifactSelectionPage("assetSelection");
    }

    public void addPages() {
        this.getLocationPage().setTitle(UiPluginResourceBundle.WIZ_ARTIFACT_GEN_PG_TTL);
        this.getLocationPage().setDescription(UiPluginResourceBundle.WIZ_ARTIFACT_GEN_PG_LOC_DSC);
        this.addPage((IWizardPage)this.getLocationPage());
        this.getAttributeWizardPage().setTitle(UiPluginResourceBundle.WIZ_ARTIFACT_GEN_PG_TTL);
        this.getAttributeWizardPage().setDescription(UiPluginResourceBundle.WIZ_ARTIFACT_GEN_PG_ATT_DSC);
        this.addPage((IWizardPage)this.getAttributeWizardPage());
        this.artifactSelectionPage.setTitle(UiPluginResourceBundle.WIZ_ARTIFACT_ASS_PG_TTL);
        this.artifactSelectionPage.setDescription(UiPluginResourceBundle.WIZ_ARTIFACT_ASS_PG_DSC);
        this.addPage((IWizardPage)this.artifactSelectionPage);
    }

    protected boolean createObject(IFile file) throws Exception {
        Resource resource = this.createResource(file);
        resource.getContents().add((Object)this.createEObject());
        EMFUtil.save((Resource)resource);
        return true;
    }

    protected EObject createEObject() {
        IProxyNode[] selectedProxyNodes;
        this.newArtifact = Common_ConfigurationFactory.eINSTANCE.createCFGArtifact();
        this.newArtifact.setName(this.getLocationPage().getFileNameWithoutExtension());
        String description = this.getAttributeWizardPage().getItemDescription();
        if (description != null && description.trim().length() > 0) {
            this.newArtifact.setDescription(description);
        }
        if ((selectedProxyNodes = this.artifactSelectionPage.getSelectedProxyNodes()).length > 0) {
            int counter = 0;
            while (counter < selectedProxyNodes.length) {
                EObject eObject;
                if (selectedProxyNodes[counter] instanceof EObjectProxyNode && (eObject = ((EObjectProxyNode)selectedProxyNodes[counter]).getEObject()) instanceof CFGClass) {
                    ArtifactUtil.associateTestAsset((CFGClass)((CFGClass)eObject), (CFGArtifact)this.newArtifact);
                }
                ++counter;
            }
        }
        return this.newArtifact;
    }

    protected Resource createResource(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        Resource.Factory factory = EMFUtil.getResourceFactory((String)"artifact");
        return factory.createResource(uri);
    }

    protected void openEditor(IFile file) throws PartInitException {
        TestUIUtil.openEditor(file, "org.eclipse.hyades.test.ui.editor.ArtifactEditorPart");
    }

    public CFGArtifact getNewArtifact() {
        return this.newArtifact;
    }
}

