/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.io.File;
import java.util.Locale;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CSVFileSelectionComposite
extends Composite {
    private Text csvFilePathText = null;
    private Button csvFileBrowseButton = null;
    private Combo csvFileEncodingCombo = null;
    private Button csvFileFirstRowVariableNamesButton = null;
    private Button csvFileFirstColumnEquivalenceClassNamesButton = null;
    private Button csvFileCellsEnclosedInXMLTagsButton = null;
    private static final String DATAPOOL_SECTION_KEY = "Datapool";
    private static final String DATAPOOL_DIR_KEY = "CSV directory";
    private static final String[] ENCODINGS = new String[]{UiPluginResourceBundle.WIZ_DATAPOOL_CSV_ENC_DEFAULT, UiPluginResourceBundle.WIZ_DATAPOOL_CSV_ENC_ASCII, UiPluginResourceBundle.WIZ_DATAPOOL_CSV_ENC_ISOLATIN, UiPluginResourceBundle.WIZ_DATAPOOL_CSV_ENC_UTF8, UiPluginResourceBundle.WIZ_DATAPOOL_CSV_ENC_UTF16, UiPluginResourceBundle.WIZ_DATAPOOL_CSV_ENC_UTF16LE, UiPluginResourceBundle.WIZ_DATAPOOL_CSV_ENC_UTF16BE};
    public static final String[] ENCODING_VALUES = new String[]{new String(), "US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16", "UTF-16LE", "UTF-16BE"};

    public CSVFileSelectionComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public CSVFileSelectionComposite(Composite parent, int style, String csvFileCellsEnclosedInXMLTagsButtonLabel) {
        super(parent, style);
        this.createControl(csvFileCellsEnclosedInXMLTagsButtonLabel);
    }

    public void init() {
        this.csvFilePathText.setText("");
        this.csvFileEncodingCombo.select(0);
        this.csvFileFirstRowVariableNamesButton.setSelection(true);
        this.csvFileFirstColumnEquivalenceClassNamesButton.setSelection(true);
        if (this.csvFileCellsEnclosedInXMLTagsButton != null) {
            this.csvFileCellsEnclosedInXMLTagsButton.setSelection(false);
        }
    }

    public Text getCSVFilePathText() {
        return this.csvFilePathText;
    }

    public Combo getCSVFileEncodingCombo() {
        return this.csvFileEncodingCombo;
    }

    public Button getCSVFileFirstRowVariableNamesButton() {
        return this.csvFileFirstRowVariableNamesButton;
    }

    public Button getCSVFileFirstColumnEquivalenceClassNamesButton() {
        return this.csvFileFirstColumnEquivalenceClassNamesButton;
    }

    public Button getCSVFileCellsEnclosedInXMLTagsButton() {
        return this.csvFileCellsEnclosedInXMLTagsButton;
    }

    private void createControl(String csvFileCellsEnclosedInXMLTagsButtonText) {
        Label csvFileLabel = new Label((Composite)this, 0);
        csvFileLabel.setText(UiPluginResourceBundle.WIZ_DATAPOOL_CSV_PG_SEL);
        this.csvFilePathText = new Text((Composite)this, 2048);
        this.csvFilePathText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.csvFileBrowseButton = new Button((Composite)this, 8);
        this.csvFileBrowseButton.setText(UiPluginResourceBundle.BROWSE);
        this.csvFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String csvFileName = CSVFileSelectionComposite.this.getNewCSVFilePathFromDialog();
                if (csvFileName != null) {
                    CSVFileSelectionComposite.this.csvFilePathText.setText(csvFileName);
                }
            }
        });
        GridData threeColumnHorizontalFillGridData = GridDataUtil.createHorizontalFill();
        threeColumnHorizontalFillGridData.horizontalSpan = 3;
        Group csvFileOptionsGroup = new Group((Composite)this, 0);
        csvFileOptionsGroup.setText(UiPluginResourceBundle.DatapoolWizard_options);
        csvFileOptionsGroup.setLayout((Layout)new GridLayout(3, false));
        csvFileOptionsGroup.setLayoutData((Object)threeColumnHorizontalFillGridData);
        Label csvFileEncodingLabel = new Label((Composite)csvFileOptionsGroup, 0);
        csvFileEncodingLabel.setText(UiPluginResourceBundle.WIZ_DATAPOOL_CSV_PG_ENC);
        this.csvFileEncodingCombo = new Combo((Composite)csvFileOptionsGroup, 12);
        this.csvFileEncodingCombo.setItems(ENCODINGS);
        this.csvFileFirstRowVariableNamesButton = new Button((Composite)csvFileOptionsGroup, 32);
        this.csvFileFirstRowVariableNamesButton.setText(UiPluginResourceBundle.WIZ_DATAPOOL_CSV_PG_COL_HEADER);
        this.csvFileFirstRowVariableNamesButton.setLayoutData((Object)threeColumnHorizontalFillGridData);
        this.csvFileFirstColumnEquivalenceClassNamesButton = new Button((Composite)csvFileOptionsGroup, 32);
        this.csvFileFirstColumnEquivalenceClassNamesButton.setText(UiPluginResourceBundle.WIZ_DATAPOOL_CSV_PG_ROW_HEADER);
        this.csvFileFirstColumnEquivalenceClassNamesButton.setLayoutData((Object)threeColumnHorizontalFillGridData);
        if (csvFileCellsEnclosedInXMLTagsButtonText != null) {
            this.csvFileCellsEnclosedInXMLTagsButton = new Button((Composite)csvFileOptionsGroup, 32);
            this.csvFileCellsEnclosedInXMLTagsButton.setText(csvFileCellsEnclosedInXMLTagsButtonText);
            this.csvFileCellsEnclosedInXMLTagsButton.setLayoutData((Object)threeColumnHorizontalFillGridData);
        }
        this.init();
        this.layout(false, true);
    }

    private String getNewCSVFilePathFromDialog() {
        IDialogSettings settings;
        FileDialog dialog = new FileDialog(this.getShell());
        String csvFilePath = this.csvFilePathText.getText().trim();
        if (csvFilePath == null || csvFilePath.length() == 0 || !new File(csvFilePath).exists()) {
            String path = null;
            settings = this.getDatapoolDialogSettings();
            if (settings != null) {
                path = settings.get(DATAPOOL_DIR_KEY);
            }
            if (path == null || path.length() == 0 || !new File(path).exists()) {
                dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().makeAbsolute().toOSString());
            } else {
                dialog.setFilterPath(path);
            }
        } else {
            dialog.setFilterPath(csvFilePath);
        }
        dialog.setFilterExtensions(new String[]{"*.csv"});
        dialog.setText(UiPluginResourceBundle.WIZ_DATAPOOL_CSV_FILE_OPEN);
        String newCSVFilePath = dialog.open();
        if (newCSVFilePath != null && newCSVFilePath.trim().length() > 0) {
            if (!(newCSVFilePath = newCSVFilePath.trim()).toLowerCase(Locale.ENGLISH).endsWith(".csv")) {
                if (!newCSVFilePath.endsWith(".")) {
                    newCSVFilePath = String.valueOf(newCSVFilePath) + ".";
                }
                newCSVFilePath = String.valueOf(newCSVFilePath) + "csv";
            }
            if ((settings = this.getDatapoolDialogSettings()) != null) {
                settings.put(DATAPOOL_DIR_KEY, new Path(newCSVFilePath).removeLastSegments(1).makeAbsolute().toOSString());
            }
        }
        return newCSVFilePath;
    }

    private IDialogSettings getDatapoolDialogSettings() {
        IDialogSettings pluginDialogSettings = UiPlugin.getDefault().getDialogSettings();
        IDialogSettings dataPoolDialogSettings = pluginDialogSettings.getSection(DATAPOOL_SECTION_KEY);
        if (dataPoolDialogSettings == null) {
            dataPoolDialogSettings = pluginDialogSettings.addNewSection(DATAPOOL_SECTION_KEY);
        }
        return dataPoolDialogSettings;
    }
}

