/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolConstants;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVImportExportUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.CorruptCSVFileException;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.wizard.CSVFileSelectionComposite;
import org.eclipse.hyades.ui.internal.wizard.AttributeWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class DatapoolAttributeWizardPage
extends AttributeWizardPage {
    private Spinner columnSpinner = null;
    private Spinner rowSpinner = null;
    private Button importCSVFileButton = null;
    private CSVFileSelectionComposite csvFileSelectionComposite = null;

    public DatapoolAttributeWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Group dimensionGroup = new Group((Composite)this.getControl(), 0);
        dimensionGroup.setLayoutData((Object)new GridData(768));
        dimensionGroup.setLayout((Layout)new GridLayout(2, false));
        dimensionGroup.setText(UiPluginResourceBundle.DatapoolNewWizard_InitialTableDimension);
        Label columnNumberLabel = new Label((Composite)dimensionGroup, 0);
        columnNumberLabel.setText(UiPluginResourceBundle.DatapoolNewWizard_numberOfColumns);
        this.initializeDialogUnits((Control)dimensionGroup);
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(Math.max(String.valueOf(DatapoolConstants.MAXIMUM_VARIABLE_LIMIT).length(), String.valueOf(Integer.MAX_VALUE).length()) + 2);
        this.columnSpinner = new Spinner((Composite)dimensionGroup, 2048);
        this.columnSpinner.setLayoutData((Object)gridData);
        this.columnSpinner.setValues(1, 1, DatapoolConstants.MAXIMUM_VARIABLE_LIMIT, 0, 1, 10);
        Label rowNumberLabel = new Label((Composite)dimensionGroup, 0);
        rowNumberLabel.setText(UiPluginResourceBundle.DatapoolNewWizard_numberOfRows);
        this.rowSpinner = new Spinner((Composite)dimensionGroup, 2048);
        this.rowSpinner.setLayoutData((Object)gridData);
        this.rowSpinner.setValues(1, 0, Integer.MAX_VALUE, 0, 1, 10);
        this.importCSVFileButton = new Button((Composite)this.getControl(), 32);
        this.importCSVFileButton.setText(UiPluginResourceBundle.DatapoolNewWizard_importCSVFile);
        gridData = new GridData(768);
        gridData.horizontalIndent = 12;
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatapoolAttributeWizardPage.this.validateSelection();
            }
        };
        this.csvFileSelectionComposite = new CSVFileSelectionComposite((Composite)this.getControl(), 0);
        this.csvFileSelectionComposite.setLayoutData(gridData);
        this.csvFileSelectionComposite.setLayout((Layout)gridLayout);
        this.csvFileSelectionComposite.setVisible(false);
        this.csvFileSelectionComposite.getCSVFileFirstRowVariableNamesButton().addSelectionListener((SelectionListener)selectionAdapter);
        this.csvFileSelectionComposite.getCSVFileFirstColumnEquivalenceClassNamesButton().addSelectionListener((SelectionListener)selectionAdapter);
        this.csvFileSelectionComposite.getCSVFilePathText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatapoolAttributeWizardPage.this.validateSelection();
            }
        });
        this.importCSVFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isVisible = DatapoolAttributeWizardPage.this.importCSVFileButton.getSelection();
                DatapoolAttributeWizardPage.this.csvFileSelectionComposite.setVisible(isVisible);
                if (isVisible) {
                    DatapoolAttributeWizardPage.this.csvFileSelectionComposite.getCSVFilePathText().setFocus();
                } else {
                    DatapoolAttributeWizardPage.this.itemDescriptionText.setFocus();
                    DatapoolAttributeWizardPage.this.csvFileSelectionComposite.init();
                    DatapoolAttributeWizardPage.this.validateSelection();
                }
            }
        });
    }

    public int getNumOfColumns() {
        return this.columnSpinner.getSelection();
    }

    public int getNumOfRows() {
        return this.rowSpinner.getSelection();
    }

    public String getCSVFilePath() {
        return this.csvFileSelectionComposite.getCSVFilePathText().getText();
    }

    public boolean getCSVFileFirstRowContainsVariableNames() {
        return this.csvFileSelectionComposite.getCSVFileFirstRowVariableNamesButton().getSelection();
    }

    public boolean getCSVFileFirstColumnContainsEquivalenceClassNames() {
        return this.csvFileSelectionComposite.getCSVFileFirstColumnEquivalenceClassNamesButton().getSelection();
    }

    public String getCSVFileEncoding() {
        return CSVFileSelectionComposite.ENCODING_VALUES[this.csvFileSelectionComposite.getCSVFileEncodingCombo().getSelectionIndex()];
    }

    protected void validateSelection() {
        boolean isValid;
        block8: {
            isValid = false;
            if (this.importCSVFileButton.getSelection()) {
                String csvFilePath = this.getCSVFilePath();
                if (csvFilePath != null) {
                    Shell shell = this.getShell();
                    shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
                    try {
                        try {
                            isValid = CSVImportExportUtil.getInstance().validateCSVFile(csvFilePath, this.getCSVFileFirstRowContainsVariableNames(), this.getCSVFileFirstColumnContainsEquivalenceClassNames(), this.getCSVFileEncoding());
                            this.setErrorMessage(null);
                        }
                        catch (CorruptCSVFileException c) {
                            this.setErrorMessage(c.getMessage());
                            shell.setCursor(null);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        shell.setCursor(null);
                        throw throwable;
                    }
                    shell.setCursor(null);
                }
            } else {
                isValid = true;
                this.setErrorMessage(null);
            }
        }
        this.setPageComplete(isValid);
    }
}

