/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.util.Locale;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.wizard.CSVFileSelectionComposite;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DatapoolExportCSVFileLocationPage
extends WizardPage {
    private CSVFileSelectionComposite csvFileSelectionComposite = null;

    protected DatapoolExportCSVFileLocationPage(String pageName) {
        super(pageName);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.csvFileSelectionComposite.getCSVFilePathText().setFocus();
        }
    }

    public void createControl(Composite parent) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatapoolExportCSVFileLocationPage.this.validateSelection();
            }
        };
        this.csvFileSelectionComposite = new CSVFileSelectionComposite(parent, 0, UiPluginResourceBundle.WIZ_EXP_DATAPOOL_CSV_PG_TAG);
        this.csvFileSelectionComposite.setLayoutData(GridDataUtil.createHorizontalFill());
        this.csvFileSelectionComposite.setLayout((Layout)new GridLayout(3, false));
        this.csvFileSelectionComposite.getCSVFileFirstRowVariableNamesButton().addSelectionListener((SelectionListener)selectionAdapter);
        this.csvFileSelectionComposite.getCSVFileFirstColumnEquivalenceClassNamesButton().addSelectionListener((SelectionListener)selectionAdapter);
        this.csvFileSelectionComposite.getCSVFileCellsEnclosedInXMLTagsButton().addSelectionListener((SelectionListener)selectionAdapter);
        this.csvFileSelectionComposite.getCSVFilePathText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatapoolExportCSVFileLocationPage.this.validateSelection();
            }
        });
        this.setControl((Control)this.csvFileSelectionComposite);
        this.setPageComplete(false);
    }

    public String getCSVFilePath() {
        return this.csvFileSelectionComposite.getCSVFilePathText().getText();
    }

    public boolean getCSVFileFirstRowContainsVariableNames() {
        return this.csvFileSelectionComposite.getCSVFileFirstRowVariableNamesButton().getSelection();
    }

    public boolean getCSVFileFirstColumnContainsEquivalenceClassNames() {
        return this.csvFileSelectionComposite.getCSVFileFirstColumnEquivalenceClassNamesButton().getSelection();
    }

    public boolean getCSVFileCellsEnclosedInXMLTags() {
        return this.csvFileSelectionComposite.getCSVFileCellsEnclosedInXMLTagsButton().getSelection();
    }

    public String getCSVFileEncoding() {
        return CSVFileSelectionComposite.ENCODING_VALUES[this.csvFileSelectionComposite.getCSVFileEncodingCombo().getSelectionIndex()];
    }

    protected boolean validateSelection() {
        boolean isValid = false;
        String csvFilePath = this.getCSVFilePath();
        Path csvFileIPath = new Path(csvFilePath);
        if (csvFilePath.trim().length() == 0 || !csvFileIPath.removeLastSegments(1).toFile().exists()) {
            this.setErrorMessage(UiPluginResourceBundle.DatapoolExportPage_ERROR_MISSING_CSV_DIRECTORY);
        } else if (csvFileIPath.getFileExtension() == null || !csvFileIPath.getFileExtension().toLowerCase(Locale.ENGLISH).equals("csv")) {
            this.setErrorMessage(UiPluginResourceBundle.DatapoolExportPage_ERROR_MISSING_CSV_FILE_EXTENSION);
        } else {
            this.setErrorMessage(null);
            isValid = true;
        }
        this.setPageComplete(isValid);
        return isValid;
    }
}

