/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.test.ui.datapool.internal.util.CSVImportExportUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.CorruptCSVFileException;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.internal.wizard.CSVFileSelectionComposite;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DatapoolImportPageOne
extends WizardPage {
    private CSVFileSelectionComposite csvFileSelectionComposite = null;

    public DatapoolImportPageOne(String pageName) {
        super(pageName);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.csvFileSelectionComposite.getCSVFilePathText().setFocus();
        }
    }

    public void createControl(Composite parent) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatapoolImportPageOne.this.validateSelection();
            }
        };
        this.csvFileSelectionComposite = new CSVFileSelectionComposite(parent, 0);
        this.csvFileSelectionComposite.setLayoutData(GridDataUtil.createHorizontalFill());
        this.csvFileSelectionComposite.setLayout((Layout)new GridLayout(3, false));
        this.csvFileSelectionComposite.getCSVFileFirstRowVariableNamesButton().addSelectionListener((SelectionListener)selectionAdapter);
        this.csvFileSelectionComposite.getCSVFileFirstColumnEquivalenceClassNamesButton().addSelectionListener((SelectionListener)selectionAdapter);
        this.csvFileSelectionComposite.getCSVFilePathText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatapoolImportPageOne.this.validateSelection();
            }
        });
        this.setControl((Control)this.csvFileSelectionComposite);
        this.setPageComplete(false);
    }

    public String getCSVFilePath() {
        return this.csvFileSelectionComposite.getCSVFilePathText().getText();
    }

    public boolean getCSVFileFirstRowContainsVariableNames() {
        return this.csvFileSelectionComposite.getCSVFileFirstRowVariableNamesButton().getSelection();
    }

    public boolean getCSVFileFirstColumnContainsEquivalenceClassNames() {
        return this.csvFileSelectionComposite.getCSVFileFirstColumnEquivalenceClassNamesButton().getSelection();
    }

    public String getCSVFileEncoding() {
        return CSVFileSelectionComposite.ENCODING_VALUES[this.csvFileSelectionComposite.getCSVFileEncodingCombo().getSelectionIndex()];
    }

    protected void validateSelection() {
        boolean isValid;
        block7: {
            isValid = false;
            String csvFilePath = this.getCSVFilePath();
            if (csvFilePath != null) {
                Shell shell = this.getShell();
                shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
                try {
                    try {
                        isValid = CSVImportExportUtil.getInstance().validateCSVFile(csvFilePath, this.getCSVFileFirstRowContainsVariableNames(), this.getCSVFileFirstColumnContainsEquivalenceClassNames(), this.getCSVFileEncoding());
                        this.setErrorMessage(null);
                    }
                    catch (CorruptCSVFileException c) {
                        this.setErrorMessage(c.getMessage());
                        shell.setCursor(null);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    shell.setCursor(null);
                    throw throwable;
                }
                shell.setCursor(null);
            } else {
                this.setErrorMessage(null);
            }
        }
        this.setPageComplete(isValid);
    }
}

