/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.util.DatapoolEncryptManager;
import org.eclipse.hyades.models.common.util.DatapoolUtil;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVImportExportUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.wizard.DatapoolImportPageOne;
import org.eclipse.hyades.test.ui.internal.wizard.DatapoolImportPageTwo;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class DatapoolImportWizard
extends Wizard
implements IImportWizard {
    private DatapoolImportPageOne datapoolImportPageOne = null;
    private DatapoolImportPageTwo datapoolImportPageTwo = null;
    private TestLocationPage testLocationPage = null;
    private IStructuredSelection selection = null;

    public DatapoolImportWizard() {
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("import_datapool_wiz.gif"));
        this.setWindowTitle(UiPluginResourceBundle.DatapoolImportWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public DatapoolImportPageOne getDatapoolImportPageOne() {
        return this.datapoolImportPageOne;
    }

    public boolean canFinish() {
        return this.datapoolImportPageOne.isPageComplete() && (this.datapoolImportPageTwo.isPageComplete() || this.testLocationPage.isPageComplete());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.datapoolImportPageOne = new DatapoolImportPageOne("importDatapoolPageOne");
        this.datapoolImportPageOne.setTitle(UiPluginResourceBundle.DatapoolImportWizard_title);
        this.datapoolImportPageOne.setDescription(UiPluginResourceBundle.DatapoolImportWizard_description);
        this.addPage((IWizardPage)this.datapoolImportPageOne);
        this.datapoolImportPageTwo = new DatapoolImportPageTwo("importDatapoolPageTwo", this.selection);
        this.datapoolImportPageTwo.setTitle(UiPluginResourceBundle.DatapoolImportWizard_title);
        this.datapoolImportPageTwo.setDescription(UiPluginResourceBundle.DatapoolImportWizard_PageTwo_description);
        this.addPage((IWizardPage)this.datapoolImportPageTwo);
        this.testLocationPage = new TestLocationPage("locationPage", this.selection);
        this.testLocationPage.setTitle(UiPluginResourceBundle.DatapoolImportWizard_title);
        this.testLocationPage.setDescription(UiPluginResourceBundle.DatapoolImportWizard_LocationPage_description);
        this.testLocationPage.setFileExtension("datapool");
        this.addPage((IWizardPage)this.testLocationPage);
    }

    public void createPageControls(Composite parent) {
        super.createPageControls(parent);
        IWorkbenchHelpSystem workbenchHelpSystem = PlatformUI.getWorkbench().getHelpSystem();
        workbenchHelpSystem.setHelp(this.datapoolImportPageOne.getControl(), String.valueOf(UiPlugin.getID()) + ".dplw0002");
        workbenchHelpSystem.setHelp(this.datapoolImportPageTwo.getControl(), String.valueOf(UiPlugin.getID()) + ".dplw0002");
        workbenchHelpSystem.setHelp(this.testLocationPage.getControl(), String.valueOf(UiPlugin.getID()) + ".dplw0002");
    }

    public boolean performFinish() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                monitor.beginTask(UiPluginResourceBundle.DatapoolImportWizard_progressMonitor, 4);
                IDatapool datapool = DatapoolImportWizard.this.datapoolImportPageTwo.getSelectedDatapool();
                String csvFilePath = DatapoolImportWizard.this.datapoolImportPageOne.getCSVFilePath();
                boolean isEncrypted = DatapoolImportWizard.this.datapoolImportPageTwo.isSelectedDatapoolEncrypted();
                boolean isReplaceExistingRecords = DatapoolImportWizard.this.datapoolImportPageTwo.isReplaceExistingRecords();
                String password = DatapoolImportWizard.this.datapoolImportPageTwo.getEncryptedDatapoolPassword();
                boolean isDecrypted = false;
                try {
                    try {
                        monitor.worked(1);
                        if (datapool != null) {
                            if (isEncrypted) {
                                DatapoolEncryptManager.decryptDatapool((IDatapool)datapool, (String)password);
                                isDecrypted = true;
                            }
                            if (isReplaceExistingRecords) {
                                int equivalenceClassIndex = 0;
                                while (equivalenceClassIndex < datapool.getEquivalenceClassCount()) {
                                    IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(equivalenceClassIndex);
                                    int recordCount = equivalenceClass.getRecordCount();
                                    int counter = 0;
                                    while (counter < recordCount) {
                                        equivalenceClass.removeRecord(0);
                                        ++counter;
                                    }
                                    ++equivalenceClassIndex;
                                }
                            }
                        } else {
                            String datapoolFileName = DatapoolImportWizard.this.testLocationPage.getFileName();
                            datapool = DatapoolUtil.createNewDatapool((String)datapoolFileName.substring(0, datapoolFileName.indexOf(46)), null);
                            EMFUtil.getResourceFactory((String)DatapoolImportWizard.this.testLocationPage.getFileExtension()).createResource(URI.createPlatformResourceURI((String)DatapoolImportWizard.this.testLocationPage.getContainerFullPath().append(datapoolFileName).toOSString(), (boolean)false)).getContents().add((Object)((DPLDatapool)datapool));
                        }
                        monitor.worked(1);
                        if (datapool.getVariableCount() == 0) {
                            CSVImportExportUtil.getInstance().importCSV(datapool, csvFilePath, DatapoolImportWizard.this.datapoolImportPageOne.getCSVFileFirstRowContainsVariableNames(), DatapoolImportWizard.this.datapoolImportPageOne.getCSVFileFirstColumnContainsEquivalenceClassNames(), DatapoolImportWizard.this.datapoolImportPageOne.getCSVFileEncoding());
                        } else {
                            CSVImportExportUtil.getInstance().appendFromCSV(datapool, csvFilePath, DatapoolImportWizard.this.datapoolImportPageOne.getCSVFileFirstRowContainsVariableNames(), DatapoolImportWizard.this.datapoolImportPageOne.getCSVFileFirstColumnContainsEquivalenceClassNames(), DatapoolImportWizard.this.datapoolImportPageOne.getCSVFileEncoding());
                            if (isDecrypted) {
                                DatapoolEncryptManager.encryptDatapool((IDatapool)datapool, (String)password);
                                isDecrypted = false;
                            }
                        }
                        monitor.worked(1);
                        EMFUtil.save((Resource)((DPLDatapool)datapool).eResource());
                        TestUIUtil.openEditor((EObject)((DPLDatapool)datapool), "org.eclipse.hyades.test.ui.editor.DatapoolEditorPart");
                        monitor.worked(1);
                    }
                    catch (Exception e) {
                        if (isDecrypted) {
                            DatapoolEncryptManager.encryptDatapool((IDatapool)datapool, (String)password);
                        }
                        UiPlugin.logError(e);
                        new ErrorDialog(DatapoolImportWizard.this.getShell(), UiPluginResourceBundle.W_ERROR, NLS.bind((String)UiPluginResourceBundle._ERROR_WIZ_DATAPOOL_CSV_ERRDLG_IMPFILE, (Object[])new String[]{csvFilePath, datapool.getName()}), (IStatus)new Status(4, "org.eclipse.hyades.test.ui", 0, e.toString(), (Throwable)e), 4).open();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            UiPlugin.logError(e);
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }
}

