/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.util.DatapoolUtil;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVImportExportUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.wizard.DatapoolAttributeWizardPage;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class DatapoolNewWizard
extends HyadesNewWizard {
    private TestLocationPage testLocationPage = null;

    public DatapoolNewWizard() {
        this.setWindowTitle(UiPluginResourceBundle.WIZ_DATAPOOL_TTL);
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("new_datapool_wiz.gif"));
        IDialogSettings dialogSettings = UiPlugin.getInstance().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("DataPoolNewWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("DataPoolNewWizard");
        }
        this.setDialogSettings(settings);
    }

    protected LocationPage getLocationPage() {
        if (this.testLocationPage == null) {
            this.testLocationPage = new TestLocationPage("datapoolLocation", this.selection);
            String fileExtension = this.getFileExtension();
            if (fileExtension != null) {
                this.testLocationPage.setFileExtension(fileExtension);
                this.testLocationPage.setFileName("");
            }
        }
        return this.testLocationPage;
    }

    protected void initPages() {
        super.initPages();
        this.setAttributeWizardPage(new DatapoolAttributeWizardPage("datapool attribute page name"));
    }

    protected String getType() {
        return "org.eclipse.hyades.datapool.generic";
    }

    protected String getFileExtension() {
        return "datapool";
    }

    public void addPages() {
        this.getLocationPage().setTitle(UiPluginResourceBundle.WIZ_DATAPOOL_GEN_PG_TTL);
        this.getLocationPage().setDescription(UiPluginResourceBundle.WIZ_DATAPOOL_GEN_PG_LOC_DSC);
        this.addPage((IWizardPage)this.getLocationPage());
        this.getAttributeWizardPage().setTitle(UiPluginResourceBundle.WIZ_DATAPOOL_GEN_PG_TTL);
        this.getAttributeWizardPage().setDescription(UiPluginResourceBundle.WIZ_DATAPOOL_GEN_PG_ATT_DSC);
        this.addPage((IWizardPage)this.getAttributeWizardPage());
    }

    public void createPageControls(Composite parent) {
        super.createPageControls(parent);
        IWorkbenchHelpSystem workbenchHelpSystem = PlatformUI.getWorkbench().getHelpSystem();
        workbenchHelpSystem.setHelp(this.getLocationPage().getControl(), String.valueOf(UiPlugin.getID()) + ".dplw0001");
        workbenchHelpSystem.setHelp(this.getAttributeWizardPage().getControl(), String.valueOf(UiPlugin.getID()) + ".dplw0001");
    }

    protected boolean createObject(IFile file) throws Exception {
        Resource resource = this.createResource(file);
        EObject eObject = this.createEObject();
        if (eObject == null) {
            return false;
        }
        resource.getContents().add((Object)eObject);
        EMFUtil.save((Resource)resource);
        return true;
    }

    protected EObject createEObject() {
        DPLDatapool datapool;
        block6: {
            datapool = (DPLDatapool)DatapoolUtil.createNewDatapool((String)this.getLocationPage().getFileNameWithoutExtension(), (String)this.getAttributeWizardPage().getItemDescription());
            int numOfColumns = ((DatapoolAttributeWizardPage)this.getAttributeWizardPage()).getNumOfColumns();
            int numOfRows = ((DatapoolAttributeWizardPage)this.getAttributeWizardPage()).getNumOfRows();
            String csvFilePath = ((DatapoolAttributeWizardPage)this.getAttributeWizardPage()).getCSVFilePath();
            if (csvFilePath.trim().length() != 0) {
                try {
                    boolean isRowVariableNameType = ((DatapoolAttributeWizardPage)this.getAttributeWizardPage()).getCSVFileFirstRowContainsVariableNames();
                    boolean isColEqClsName = ((DatapoolAttributeWizardPage)this.getAttributeWizardPage()).getCSVFileFirstColumnContainsEquivalenceClassNames();
                    String importEncoding = ((DatapoolAttributeWizardPage)this.getAttributeWizardPage()).getCSVFileEncoding();
                    if (numOfColumns == 1 && numOfRows == 1) {
                        CSVImportExportUtil.getInstance().importCSV((IDatapool)datapool, csvFilePath, isRowVariableNameType, isColEqClsName, importEncoding);
                        break block6;
                    }
                    MessageDialog dialog = new MessageDialog(this.getShell(), UiPluginResourceBundle.DatapoolNewWizard_NewDatapool, null, UiPluginResourceBundle.DatapoolNewWizard_DimensionSizeWarning, 3, new String[]{UiPluginResourceBundle.Word_Yes, UiPluginResourceBundle.Word_No}, 0);
                    if (dialog.open() == 0) {
                        CSVImportExportUtil.getInstance().importCSV((IDatapool)datapool, csvFilePath, isRowVariableNameType, isColEqClsName, importEncoding);
                        break block6;
                    }
                    CSVImportExportUtil.getInstance().importCSV((IDatapool)datapool, csvFilePath, isRowVariableNameType, isColEqClsName, importEncoding, numOfColumns, numOfRows);
                }
                catch (Exception e) {
                    UiPlugin.logError(e);
                    new ErrorDialog(this.getShell(), UiPluginResourceBundle.W_ERROR, NLS.bind((String)UiPluginResourceBundle._ERROR_WIZ_DATAPOOL_CSV_ERRDLG_IMPFILE, (Object[])new String[]{csvFilePath, datapool.getName()}), (IStatus)new Status(4, "org.eclipse.hyades.test.ui", 0, e.toString(), (Throwable)e), 4).open();
                }
            } else {
                this.createDatapoolInitialDimension((IDatapool)datapool, numOfColumns, numOfRows);
            }
        }
        return datapool;
    }

    protected void createDatapoolInitialDimension(IDatapool datapool, int numOfColumns, int numOfRows) {
        IDatapoolEquivalenceClass eqClass;
        datapool.appendEquivalenceClass(datapool.constructEquivalenceClass());
        datapool.setDefaultEquivalenceClassIndex(0);
        int i = 0;
        while (i < numOfColumns) {
            datapool.appendVariable(datapool.constructVariable());
            ++i;
        }
        int index = datapool.getDefaultEquivalenceClassIndex();
        if (index > -1) {
            eqClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(index);
        } else if (datapool.getEquivalenceClassCount() > 0) {
            eqClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(0);
            datapool.setDefaultEquivalenceClassIndex(0);
        } else {
            eqClass = datapool.constructEquivalenceClass();
            datapool.appendEquivalenceClass(eqClass);
            datapool.setDefaultEquivalenceClassIndex(0);
        }
        int i2 = 0;
        while (i2 < numOfRows) {
            eqClass.appendRecord(eqClass.constructRecord());
            ++i2;
        }
    }

    protected Resource createResource(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        Resource.Factory factory = EMFUtil.getResourceFactory((String)"datapool");
        return factory.createResource(uri);
    }

    protected void openEditor(IFile file) throws PartInitException {
        TestUIUtil.openEditor(file, "org.eclipse.hyades.test.ui.editor.DatapoolEditorPart");
    }
}

