/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.models.common.datapool.util.DatapoolEncryptManager;
import org.eclipse.hyades.test.ui.internal.component.ProxyNodeSelectionViewer;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DatapoolSelectionPage
extends WizardPage {
    protected ProxyNodeSelectionViewer datapoolSelectionViewer = null;
    protected Group encryptedDatapoolPasswordGroup = null;
    protected Text encryptedDatapoolPasswordText = null;
    protected IStructuredSelection selection = null;
    private IDatapool selectedDatapool = null;
    private boolean isSelectedDatapoolEncrypted = false;

    public DatapoolSelectionPage(String name) {
        this(name, null);
    }

    public DatapoolSelectionPage(String name, IStructuredSelection selection) {
        super(name);
        this.selection = selection;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.getSelectedDatapool() != null) {
                if (this.isSelectedDatapoolEncrypted()) {
                    this.encryptedDatapoolPasswordText.setFocus();
                } else {
                    this.datapoolSelectionViewer.getViewer().getTree().setFocus();
                }
            } else {
                this.datapoolSelectionViewer.getFilterButton().setFocus();
            }
        }
    }

    public void createControl(Composite parent) {
        Composite pane = new Composite(parent, 32);
        pane.setLayout((Layout)new GridLayout());
        pane.setLayoutData((Object)new GridData(4, 4, true, true));
        this.datapoolSelectionViewer = new ProxyNodeSelectionViewer(pane, ResourcesPlugin.getWorkspace().getRoot(), new String[]{"datapool"}, 67588){

            public void setSelection() {
                EObject eObject;
                super.setSelection();
                DatapoolSelectionPage.this.selectedDatapool = null;
                DatapoolSelectionPage.this.isSelectedDatapoolEncrypted = false;
                IProxyNode[] selectedProxyNodes = DatapoolSelectionPage.this.datapoolSelectionViewer.getSelectedProxyNodes();
                if (selectedProxyNodes.length > 0 && selectedProxyNodes[0] instanceof EObjectProxyNode && (eObject = ((EObjectProxyNode)selectedProxyNodes[0]).getEObject()) instanceof IDatapool) {
                    DatapoolSelectionPage.this.selectedDatapool = (IDatapool)eObject;
                    DatapoolSelectionPage.this.isSelectedDatapoolEncrypted = DatapoolEncryptManager.isDatapoolEncrypted((IDatapool)DatapoolSelectionPage.this.selectedDatapool);
                    if (DatapoolSelectionPage.this.isSelectedDatapoolEncrypted && !DatapoolSelectionPage.this.encryptedDatapoolPasswordGroup.isVisible()) {
                        DatapoolSelectionPage.this.encryptedDatapoolPasswordGroup.setText(NLS.bind((String)UiPluginResourceBundle.DatapoolExportWizard_password, (Object)DatapoolSelectionPage.this.selectedDatapool.getName()));
                        DatapoolSelectionPage.this.encryptedDatapoolPasswordText.setText("");
                        DatapoolSelectionPage.this.encryptedDatapoolPasswordText.setFocus();
                    }
                }
                DatapoolSelectionPage.this.encryptedDatapoolPasswordGroup.setVisible(DatapoolSelectionPage.this.isSelectedDatapoolEncrypted);
                DatapoolSelectionPage.this.setPageComplete(DatapoolSelectionPage.this.validatePage());
            }
        };
        this.datapoolSelectionViewer.getViewer().setSelection((ISelection)this.selection);
        this.encryptedDatapoolPasswordGroup = new Group(pane, 0);
        this.encryptedDatapoolPasswordGroup.setText(UiPluginResourceBundle.DatapoolExportWizard_password);
        this.encryptedDatapoolPasswordGroup.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.encryptedDatapoolPasswordGroup.setLayout((Layout)new GridLayout());
        this.encryptedDatapoolPasswordGroup.setVisible(false);
        this.encryptedDatapoolPasswordText = new Text((Composite)this.encryptedDatapoolPasswordGroup, 4261892);
        this.encryptedDatapoolPasswordText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.encryptedDatapoolPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatapoolSelectionPage.this.setPageComplete(DatapoolSelectionPage.this.validatePage());
            }
        });
        this.datapoolSelectionViewer.setSelection();
        pane.layout(false, true);
        this.setControl((Control)pane);
    }

    public IDatapool getSelectedDatapool() {
        return this.selectedDatapool;
    }

    public boolean isSelectedDatapoolEncrypted() {
        return this.isSelectedDatapoolEncrypted;
    }

    public String getEncryptedDatapoolPassword() {
        return this.encryptedDatapoolPasswordText.getText().trim();
    }

    protected boolean validatePage() {
        boolean isValid = false;
        if (this.selectedDatapool != null) {
            if (this.isSelectedDatapoolEncrypted) {
                String password = this.getEncryptedDatapoolPassword();
                if (password.length() == 0) {
                    this.setErrorMessage(NLS.bind((String)UiPluginResourceBundle.DatapoolExportWizard_encrypted, (Object)this.selectedDatapool.getName()));
                    this.encryptedDatapoolPasswordText.setFocus();
                } else if (!DatapoolEncryptManager.isKeyCorrect((IDatapool)this.selectedDatapool, (String)password)) {
                    this.setErrorMessage(UiPluginResourceBundle.DatapoolExportWizard_wrongpass);
                    this.encryptedDatapoolPasswordText.setFocus();
                } else {
                    isValid = true;
                }
            } else {
                isValid = true;
            }
        } else {
            this.setErrorMessage(null);
        }
        if (isValid) {
            this.setErrorMessage(null);
        }
        return isValid;
    }
}

