/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class DeploymentMapPage
extends WizardPage
implements SelectionListener,
ISelectionChangedListener {
    TPFDeployment deployment = null;
    StructuredViewer artifactViewer = null;
    StructuredViewer locationViewer = null;
    StructuredViewer pairViewer = null;
    CFGArtifact selectedArtifact = null;
    CFGLocation selectedLocation = null;
    CFGArtifactLocationPair selectedPair = null;
    Button createPairButton = null;
    Button removeButton = null;
    Button upButton = null;
    Button downButton = null;

    protected DeploymentMapPage(String pageName, TPFDeployment deployment) {
        super(pageName);
        this.deployment = deployment;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        composite.setLayout((Layout)gridLayout);
        Composite artifactsColumn = this.createColumn(composite);
        Composite locationsColumn = this.createColumn(composite);
        this.artifactViewer = this.createViewer(artifactsColumn, this.deployment.getArtifacts());
        this.artifactViewer.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = UiPluginResourceBundle.W_ARTIFACTS;
            }
        });
        this.locationViewer = this.createViewer(locationsColumn, this.deployment.getRefLocations());
        this.locationViewer.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = UiPluginResourceBundle.W_LOCS;
            }
        });
        this.createPairButton = new Button(composite, 8);
        GridData buttonData = new GridData();
        buttonData.horizontalAlignment = 2;
        buttonData.horizontalSpan = 2;
        this.createPairButton.setLayoutData((Object)buttonData);
        this.createPairButton.setToolTipText(UiPluginResourceBundle.BTN_CREATE_PAIR);
        this.createPairButton.setImage(TestUIImages.INSTANCE.getImageDescriptor("downArrow.gif").createImage());
        this.createPairButton.setEnabled(false);
        this.createPairButton.addSelectionListener((SelectionListener)this);
        this.createPairButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DeploymentMapPage.this.createPairButton.getToolTipText();
            }
        });
        Composite southComposite = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        southComposite.setLayoutData((Object)gridData);
        GridLayout southLayout = new GridLayout();
        southLayout.marginWidth = 0;
        southLayout.marginHeight = 0;
        southLayout.verticalSpacing = 10;
        southLayout.numColumns = 2;
        southComposite.setLayout((Layout)southLayout);
        this.pairViewer = this.createTableViewer(southComposite);
        this.pairViewer.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = UiPluginResourceBundle.EDT_DEP_PAIR;
            }

            public void getDescription(AccessibleEvent e) {
                e.result = UiPluginResourceBundle.EDT_DEP_PAIR;
            }
        });
        Composite buttonComposite = new Composite(southComposite, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data = new GridData(1040);
        buttonComposite.setLayoutData((Object)data);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout = new GridLayout();
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        buttonLayout.numColumns = 1;
        buttonComposite.setLayout((Layout)buttonLayout);
        this.createButtons(buttonComposite);
        this.setControl((Control)composite);
    }

    private void createButtons(Composite parent) {
        this.removeButton = new Button(parent, 8);
        this.removeButton.setText(UiPluginResourceBundle.label_Remove);
        GridData data = GridDataUtil.createHorizontalFill();
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.upButton = new Button(parent, 8);
        this.upButton.setText(UiPluginResourceBundle.LBL_UP);
        data = GridDataUtil.createHorizontalFill();
        data.verticalAlignment = 8;
        this.upButton.setLayoutData((Object)data);
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)this);
        this.downButton = new Button(parent, 8);
        this.downButton.setText(UiPluginResourceBundle.LBL_DOWN);
        data = GridDataUtil.createHorizontalFill();
        data.verticalAlignment = 8;
        this.downButton.setLayoutData((Object)data);
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener((SelectionListener)this);
    }

    protected Composite createColumn(Composite parent) {
        Composite column = new Composite(parent, 0);
        column.setLayoutData((Object)GridDataUtil.createFill());
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        gridLayout.marginWidth = 0;
        column.setLayout((Layout)gridLayout);
        return column;
    }

    protected StructuredViewer createViewer(Composite parent, Object input) {
        Tree tree = new Tree(parent, 67588);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        tree.setLayoutData((Object)gridData);
        ObjectContentProvider contentProvider = new ObjectContentProvider();
        TreeViewer objectViewer = new TreeViewer(tree);
        objectViewer.setContentProvider((IContentProvider)contentProvider);
        objectViewer.setLabelProvider((IBaseLabelProvider)new ObjectLabelProvider(true));
        objectViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.deployment != null) {
            objectViewer.setInput(input);
        }
        return objectViewer;
    }

    protected StructuredViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 67588);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(false);
        new TableColumn(table, 16384);
        new TableColumn(table, 16384);
        table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (e.getSource() instanceof Table) {
                    Table table = (Table)e.getSource();
                    int width = table.getSize().x;
                    int gridLineWidth = table.getGridLineWidth();
                    TableColumn[] columns = table.getColumns();
                    int i = 0;
                    while (i < columns.length) {
                        columns[i].setWidth((width - columns.length * gridLineWidth - 2) / columns.length);
                        ++i;
                    }
                }
            }
        });
        ObjectContentProvider contentProvider = new ObjectContentProvider();
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)contentProvider);
        tableViewer.setLabelProvider((IBaseLabelProvider)new MapLabelProvider());
        tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.deployment != null) {
            tableViewer.setInput((Object)this.deployment.getArtifactLocations());
        }
        return tableViewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        Object sel = null;
        if (selection != null && !selection.isEmpty()) {
            sel = ((IStructuredSelection)selection).getFirstElement();
            if (sel != null && sel instanceof CFGArtifact) {
                this.selectedArtifact = (CFGArtifact)sel;
            }
            if (sel != null && sel instanceof CFGLocation) {
                this.selectedLocation = (CFGLocation)sel;
            }
            if (sel != null && sel instanceof CFGArtifactLocationPair) {
                this.selectedPair = (CFGArtifactLocationPair)sel;
            }
        }
        if (this.selectedArtifact != null && this.selectedLocation != null) {
            boolean enableButton = this.isPairUnique(this.deployment.getArtifactLocations(), this.selectedArtifact, this.selectedLocation);
            this.createPairButton.setEnabled(enableButton);
        }
        if (this.selectedPair != null) {
            int index = this.deployment.getArtifactLocations().indexOf((Object)this.selectedPair);
            int maxIndex = this.deployment.getArtifactLocations().size() - 1;
            boolean enableUp = true;
            boolean enableDown = true;
            if (index == 0) {
                enableUp = false;
            }
            if (index == maxIndex) {
                enableDown = false;
            }
            this.removeButton.setEnabled(true);
            this.upButton.setEnabled(enableUp);
            this.downButton.setEnabled(enableDown);
        } else {
            this.removeButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    public void refresh() {
        this.artifactViewer.refresh();
        this.locationViewer.refresh();
    }

    public void widgetSelected(SelectionEvent e) {
        int index;
        if (e.widget == this.createPairButton && this.selectedArtifact != null && this.selectedLocation != null && this.isPairUnique(this.deployment.getArtifactLocations(), this.selectedArtifact, this.selectedLocation)) {
            CFGArtifactLocationPair newPair = Common_ConfigurationFactory.eINSTANCE.createCFGArtifactLocationPair();
            newPair.setArtifact(this.selectedArtifact);
            newPair.setLocation(this.selectedLocation);
            this.deployment.getArtifactLocations().add((Object)newPair);
            this.pairViewer.refresh();
            this.createPairButton.setEnabled(false);
            return;
        }
        ISelection selection = this.pairViewer.getSelection();
        Object sel = null;
        if (selection != null && !selection.isEmpty()) {
            sel = ((IStructuredSelection)selection).getFirstElement();
        }
        if (e.widget == this.removeButton) {
            if (this.selectedPair != null) {
                this.deployment.getArtifactLocations().remove((Object)this.selectedPair);
                this.removeButton.setEnabled(false);
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
                this.selectedPair = null;
                this.pairViewer.refresh();
            }
            return;
        }
        if (e.widget == this.upButton) {
            index = -1;
            if (sel != null && sel instanceof CFGArtifactLocationPair) {
                index = this.deployment.getArtifactLocations().indexOf((Object)((CFGArtifactLocationPair)sel));
                this.deployment.getArtifactLocations().move(index, index - 1);
                this.pairViewer.refresh();
                if (index - 1 == 0) {
                    this.upButton.setEnabled(false);
                    this.downButton.setEnabled(true);
                } else {
                    this.upButton.setEnabled(true);
                    this.downButton.setEnabled(true);
                }
            }
        }
        if (e.widget == this.downButton) {
            index = -1;
            int maxIndex = -1;
            if (sel != null && sel instanceof CFGArtifactLocationPair) {
                index = this.deployment.getArtifactLocations().indexOf((Object)((CFGArtifactLocationPair)sel));
                maxIndex = this.deployment.getArtifactLocations().size() - 1;
                this.deployment.getArtifactLocations().move(index, index + 1);
                this.pairViewer.refresh();
                if (index + 1 == maxIndex) {
                    this.upButton.setEnabled(true);
                    this.downButton.setEnabled(false);
                } else {
                    this.upButton.setEnabled(true);
                    this.downButton.setEnabled(true);
                }
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private boolean isPairUnique(EList list, CFGArtifact artifact, CFGLocation location) {
        int i = 0;
        while (i < list.size()) {
            CFGArtifactLocationPair pair = (CFGArtifactLocationPair)list.get(i);
            if (pair.getArtifact().equals(artifact) && pair.getLocation().equals(location)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private class MapLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MapLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof CFGArtifactLocationPair) {
                CFGArtifactLocationPair pair = (CFGArtifactLocationPair)element;
                if (columnIndex == 0) {
                    return pair.getArtifact().getName();
                }
                if (columnIndex == 1) {
                    return pair.getLocation().getName();
                }
            }
            return new String();
        }
    }

    private class ObjectContentProvider
    implements ITreeContentProvider,
    IStructuredContentProvider {
        private ArrayList list = new ArrayList();

        public void dispose() {
            this.list.clear();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = new Object[]{};
            if (inputElement == null) {
                return elements;
            }
            if (inputElement instanceof EList) {
                int listSize = ((EList)inputElement).size();
                elements = new Object[listSize];
                int i = 0;
                while (i < listSize) {
                    elements[i] = ((EList)inputElement).get(i);
                    ++i;
                }
            }
            return elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ObjectLabelProvider
    extends LabelProvider {
        private boolean useImages;

        public ObjectLabelProvider(boolean useImages) {
            this.useImages = useImages;
        }

        public Image getImage(Object element) {
            IWorkbenchAdapter adapter;
            if (!this.useImages || element == null) {
                return null;
            }
            if (element instanceof CFGArtifact) {
                return TestUIImages.INSTANCE.getImage("artifact_obj.gif");
            }
            if (element instanceof CFGLocation) {
                return TestUIImages.INSTANCE.getImage("location_obj.gif");
            }
            if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
                return adapter.getImageDescriptor(element).createImage();
            }
            return null;
        }

        public String getText(Object element) {
            IWorkbenchAdapter adapter;
            if (element == null) {
                return "";
            }
            String text = null;
            if (element instanceof CFGArtifact) {
                text = ((CFGArtifact)element).getName();
            } else if (element instanceof CFGLocation) {
                text = ((CFGLocation)element).getName();
            } else if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
                text = adapter.getLabel(element);
            }
            if (text == null) {
                text = element.toString();
            }
            return text;
        }

        public void dispose() {
            super.dispose();
        }
    }
}

