/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.wizard.DeploymentMapPage;
import org.eclipse.hyades.test.ui.internal.wizard.DeploymentObjectPage;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;
import org.eclipse.ui.PartInitException;

public class DeploymentNewWizard
extends HyadesNewWizard {
    private DeploymentObjectPage artifactPage = null;
    private DeploymentObjectPage locationPage = null;
    private DeploymentMapPage mapPage = null;
    private TPFDeployment deployment = null;
    private TestLocationPage testLocationPage = null;

    public DeploymentNewWizard() {
        this.setWindowTitle(UiPluginResourceBundle.WIZ_DEPLOY_TTL);
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("newdeployment_wiz.gif"));
        IDialogSettings dialogSettings = UiPlugin.getInstance().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("TestSuiteNewWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("TestSuiteNewWizard");
        }
        this.setDialogSettings(settings);
        this.deployment = Common_TestprofileFactory.eINSTANCE.createTPFDeployment();
    }

    protected LocationPage getLocationPage() {
        if (this.testLocationPage == null) {
            this.testLocationPage = new TestLocationPage("deploymentLocation", this.selection);
            String fileExtension = this.getFileExtension();
            if (fileExtension != null) {
                this.testLocationPage.setFileExtension(fileExtension);
                this.testLocationPage.setFileName("");
            }
        }
        return this.testLocationPage;
    }

    protected String getFileExtension() {
        return "deploy";
    }

    public void addPages() {
        this.getLocationPage().setTitle(UiPluginResourceBundle.WIZ_DEPLOY_PG_TTL);
        this.getLocationPage().setDescription(UiPluginResourceBundle.WIZ_DEPLOY_PG_LOC_DSC);
        this.addPage((IWizardPage)this.getLocationPage());
        this.getAttributeWizardPage().setTitle(UiPluginResourceBundle.WIZ_DEPLOY_PG_TTL);
        this.getAttributeWizardPage().setDescription(UiPluginResourceBundle.WIZ_DEPLOY_PG_ATT_DSC);
        this.addPage((IWizardPage)this.getAttributeWizardPage());
        Object[] replacement = new String[]{UiPluginResourceBundle.W_ARTIFACTS};
        this.artifactPage = new DeploymentObjectPage(NLS.bind((String)UiPluginResourceBundle.WIZ_DEPLOY_ASSOCIATION, (Object[])replacement), this.deployment, Common_ConfigurationFactory.eINSTANCE.createCFGArtifact());
        this.artifactPage.setTitle(UiPluginResourceBundle.WIZ_DEPLOY_PG_TTL);
        this.artifactPage.setDescription(UiPluginResourceBundle.WIZ_DEPLOY_PG_ART_DSC);
        this.addPage((IWizardPage)this.artifactPage);
        replacement = new String[]{UiPluginResourceBundle.W_LOCS};
        this.locationPage = new DeploymentObjectPage(NLS.bind((String)UiPluginResourceBundle.WIZ_DEPLOY_ASSOCIATION, (Object[])replacement), this.deployment, Common_ConfigurationFactory.eINSTANCE.createCFGMachineConstraint());
        this.locationPage.setTitle(UiPluginResourceBundle.WIZ_DEPLOY_PG_TTL);
        this.locationPage.setDescription(UiPluginResourceBundle.WIZ_DEPLOY_PG_LOCATION_DSC);
        this.addPage((IWizardPage)this.locationPage);
        replacement = new String[]{UiPluginResourceBundle.W_PAIRS};
        this.mapPage = new DeploymentMapPage(NLS.bind((String)UiPluginResourceBundle.WIZ_DEPLOY_ASSOCIATION, (Object[])replacement), this.deployment);
        this.mapPage.setTitle(UiPluginResourceBundle.WIZ_DEPLOY_PG_TTL);
        this.mapPage.setDescription(UiPluginResourceBundle.WIZ_DEPLOY_PG_MAP_DSC);
        this.addPage((IWizardPage)this.mapPage);
    }

    protected boolean createObject(IFile file) throws Exception {
        Resource resource = this.createResource(file);
        resource.getContents().add((Object)this.createEObject());
        EMFUtil.save((Resource)resource);
        return true;
    }

    protected EObject createEObject() {
        this.deployment.setName(this.getLocationPage().getFileNameWithoutExtension());
        String description = this.getAttributeWizardPage().getItemDescription();
        if (description != null && description.trim().length() > 0) {
            this.deployment.setDescription(description);
        }
        return this.deployment;
    }

    protected Resource createResource(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        Resource.Factory factory = EMFUtil.getResourceFactory((String)"deploy");
        return factory.createResource(uri);
    }

    protected void openEditor(IFile file) throws PartInitException {
        TestUIUtil.openEditor(file, "org.eclipse.hyades.test.ui.editor.DeploymentEditorPart");
    }

    public IWizardPage getNextPage(IWizardPage page) {
        this.mapPage.refresh();
        return super.getNextPage(page);
    }
}

