/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.wizard.ReportExtensionsWizard;
import org.eclipse.hyades.test.ui.internal.wizard.ReportGeneratorsExtensionRegistryReader;
import org.eclipse.hyades.test.ui.internal.wizard.ReportSelectionWizardPage;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.internal.report.ReportDescription;
import org.eclipse.hyades.ui.internal.report.ReportManager;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement;
import org.eclipse.hyades.ui.internal.wizard.selection.WizardElement;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.hyades.ui.report.ReportGeneratorWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.framework.Bundle;

public class ReportWizard
extends HyadesWizard {
    private static String REPORT_WIZARD_KEY = "ReportWizard";
    ReportSelectionWizardPage reportSelectionPage;

    public ReportWizard() {
        this.setWindowTitle(UiPluginResourceBundle.WIZ_TST_REP_PG_TTL);
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("report_wiz.gif"));
        IDialogSettings dialogSettings = UiPlugin.getInstance().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection(REPORT_WIZARD_KEY);
        if (settings == null) {
            settings = dialogSettings.addNewSection(REPORT_WIZARD_KEY);
        }
        this.setDialogSettings(settings);
        this.setForcePreviousAndNextButtons(true);
    }

    protected void initPages() {
        this.reportSelectionPage = new ReportSelectionWizardPage("report", this.getWorkbench(), this.getSelection(), this.getWizardElements(), UiPluginResourceBundle.ReportWizard_Label);
        this.reportSelectionPage.setTitle(UiPluginResourceBundle.WIZ_TST_REP_PG_TTL);
        this.reportSelectionPage.setDescription(UiPluginResourceBundle.WIZ_TST_REPP_PG_LOC_DSC);
    }

    private IWizardElement[] getWizardElements() {
        LinkedList<WizardElement> wizardElems = new LinkedList<WizardElement>();
        try {
            for (IConfigurationElement elem : ReportGeneratorsExtensionRegistryReader.getInstance().getWizardCategoryElements()) {
                try {
                    String icon_path;
                    ReportGeneratorWizard wiz = (ReportGeneratorWizard)elem.createExecutableExtension("class");
                    if (!wiz.isAvailable((ISelection)this.getSelection())) continue;
                    WizardElement wizardElement = new WizardElement((IWizard)wiz);
                    wizardElement.setId(elem.getAttribute("id"));
                    wiz.setId(wizardElement.getId());
                    wizardElement.setLabel(elem.getAttribute("name"));
                    wizardElement.setDescription(elem.getAttribute("description"));
                    ImageDescriptor imageDescriptor = null;
                    String symbolicName = elem.getDeclaringExtension().getNamespace();
                    Bundle bundle = Platform.getBundle((String)symbolicName);
                    if (bundle != null && bundle.getState() == 32 && (icon_path = elem.getAttribute("icon")) != null) {
                        URL url = new URL(bundle.getEntry("/"), icon_path);
                        imageDescriptor = ImageDescriptor.createFromURL((URL)url);
                    }
                    wizardElement.setImageDescriptor(imageDescriptor);
                    wizardElems.add(wizardElement);
                }
                catch (Exception e) {
                    UiPlugin.logError(e);
                }
            }
            ReportManager manager = TestUI.getReportManager();
            IReportDescription[] list = manager.getReportDescriptions();
            int idx = 0;
            while (idx < list.length) {
                ReportDescription data = (ReportDescription)list[idx];
                IReportGenerator gen = null;
                gen = data.getReportGenerator();
                if (gen != null && gen.isAvailable((ISelection)this.getSelection())) {
                    WizardElement wizardElement = new WizardElement((IWizard)new ReportExtensionsWizard(gen));
                    wizardElement.setId(data.getName());
                    wizardElement.setLabel(data.getName());
                    wizardElement.setDescription(UiPluginResourceBundle.wizard_Report_Description);
                    wizardElement.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("report_obj.gif"));
                    wizardElems.add(wizardElement);
                }
                ++idx;
            }
        }
        catch (Exception e) {
            UiPlugin.logError(e);
        }
        IWizardElement[] arrayOfWizardElement = new IWizardElement[wizardElems.size()];
        wizardElems.toArray(arrayOfWizardElement);
        return arrayOfWizardElement;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.reportSelectionPage);
    }

    public boolean performFinish() {
        IFile reportFile;
        FinishOperation op;
        block8: {
            op = new FinishOperation();
            this.getContainer().run(false, false, (IRunnableWithProgress)op);
            reportFile = op.getReportFile();
            this.reportSelectionPage.saveWidgetValues();
            if (reportFile != null) break block8;
            return false;
        }
        try {
            try {
                reportFile.getProject().refreshLocal(2, null);
            }
            catch (CoreException coreException) {}
            TestUIUtil.openEditor(reportFile, op.getEditorId());
        }
        catch (InterruptedException e) {
            UiPlugin.logError(e);
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable exception = e.getTargetException();
            UiPlugin.logError(exception);
            String error = exception.getLocalizedMessage();
            if (error == null || error.length() == 0) {
                error = exception.getMessage();
            }
            if (error == null || error.length() == 0) {
                error = exception.getClass().getName();
            }
            MessageDialog.openError((Shell)this.getShell(), (String)UiPluginResourceBundle.W_ERROR, (String)NLS.bind((String)UiPluginResourceBundle.GENERATE_ERROR_, (Object)error));
            return false;
        }
        return true;
    }

    class FinishOperation
    extends WorkspaceModifyOperation {
        private IFile indexReport = null;
        private String editorid = null;

        FinishOperation() {
        }

        protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                try {
                    IWizard selectedWizard = ReportWizard.this.reportSelectionPage.getSelectedNode().getWizard();
                    if (selectedWizard instanceof ReportGeneratorWizard) {
                        monitor.beginTask("", 1);
                        this.indexReport = ((ReportGeneratorWizard)selectedWizard).generate((IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
                        this.editorid = ((ReportGeneratorWizard)selectedWizard).getEditorId();
                    }
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        }

        public IFile getReportFile() {
            return this.indexReport;
        }

        public String getEditorId() {
            return this.editorid;
        }
    }
}

