/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TestOnlyFilter;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TestProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.wizard.TestCaseSelectionPage;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.test.ui.wizard.ITestCaseWizard;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.ITypeValidator;
import org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement;
import org.eclipse.hyades.ui.internal.wizard.selection.WizardElement;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class TestCaseDefinitionPage
extends WizardPage {
    private Text TSNameText;
    private ITestSuite TSElem;

    public TestCaseDefinitionPage(String pageName, IWorkbench wkbench, IStructuredSelection selection) {
        super(pageName);
        this.setTitle(UiPluginResourceBundle.WIZ_TST_CASE_DESC_PG_TTL);
        this.setDescription(UiPluginResourceBundle.WIZ_TST_CASE_DESC_PG_DSC);
        this.init(selection);
    }

    private void init(IStructuredSelection selection) {
        Object obj = selection.getFirstElement();
        if (obj instanceof ITestSuiteProxyNode) {
            this.setTestSuite((ITestSuite)((ITestSuiteProxyNode)obj).getTestSuite());
        } else {
            boolean cfr_ignored_0 = obj instanceof IProxyNode;
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.createTestSuiteControl(composite);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    private void createTestSuiteControl(Composite composite) {
        Label label = new Label(composite, 16448);
        label.setFont(composite.getFont());
        label.setText(UiPluginResourceBundle.WIZ_SEL_TST_SUITE);
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        this.TSNameText = new Text(composite, 2052);
        this.TSNameText.setText(this.getTestSuite() == null ? "" : this.getTestSuite().getName());
        this.TSNameText.setEnabled(false);
        this.TSNameText.setFont(composite.getFont());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.TSNameText.setLayoutData((Object)gd);
        this.TSNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestCaseDefinitionPage.this.setPageComplete(TestCaseDefinitionPage.this.validatePage());
            }
        });
        Button browse = new Button(composite, 8);
        browse.setText(UiPluginResourceBundle.BROWSE);
        browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseDefinitionPage.this.browseTS();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void browseTS() {
        Object[] objects;
        TestProvider provider = new TestProvider(new TestOnlyFilter(), false);
        String title = UiPluginResourceBundle.WIZ_SEL_TST_SUITE_DLG_TTL;
        String message = UiPluginResourceBundle.WIZ_SEL_TST_SUITE_DLG_MSG;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)provider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)new TestSuiteValidator());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        TPFTestSuite ts = null;
        if (dialog.open() == 0 && (objects = dialog.getResult())[0] instanceof ITestSuiteProxyNode) {
            ts = ((ITestSuiteProxyNode)objects[0]).getTestSuite();
            this.setTestSuite((ITestSuite)ts);
        }
        if (ts != null) {
            this.setText(ts.getName());
        }
    }

    private void setText(String name) {
        if (this.TSNameText != null) {
            this.TSNameText.setText(name);
        }
    }

    protected boolean validatePage() {
        return this.getTestSuite() != null;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        IWizardPage page = super.getNextPage();
        if (page instanceof TestCaseSelectionPage) {
            TestCaseSelectionPage selPage = (TestCaseSelectionPage)page;
            if (this.isCurrentPage()) {
                HashMap testCaseTypesByTestSuiteType = new HashMap();
                ITestSuite testSuite = this.getTestSuite();
                if (testSuite == null) {
                    return page;
                }
                String testSuiteType = testSuite.getType();
                if (testSuiteType == null) {
                    return page;
                }
                HashSet<String> testCaseTypes = new HashSet<String>();
                testCaseTypesByTestSuiteType.put(testSuiteType, testCaseTypes);
                IAssociationMapping testSuiteTypeValidatorMapping = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeValidators");
                IAssociationDescriptor[] typeValidatorDescriptors = testSuiteTypeValidatorMapping.getAssociationDescriptors(testSuiteType);
                if (typeValidatorDescriptors.length == 0) {
                    super.getNextPage();
                }
                IAssociationMapping testCaseWizardMapping = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("newTestCaseWizards");
                String[] mappingTypes = testCaseWizardMapping.getTypes();
                int i = 0;
                int maxi = mappingTypes.length;
                while (i < maxi) {
                    int j = 0;
                    int maxj = typeValidatorDescriptors.length;
                    while (j < maxj) {
                        ITypeValidator typeValidator = (ITypeValidator)typeValidatorDescriptors[j].createImplementationClassInstance();
                        if (typeValidator.isValidType(mappingTypes[i])) {
                            testCaseTypes.add(mappingTypes[i]);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                ArrayList<WizardElement> wizardElements = new ArrayList<WizardElement>(testCaseTypes.size());
                for (String testCaseType : testCaseTypes) {
                    IAssociationDescriptor[] wizardDescriptors = testCaseWizardMapping.getAssociationDescriptors(testCaseType);
                    int j = 0;
                    int maxj = wizardDescriptors.length;
                    while (j < maxj) {
                        Object wizard = wizardDescriptors[j].createImplementationClassInstance();
                        if (wizard instanceof ITestCaseWizard) {
                            WizardElement wizardElement = new WizardElement((IWizard)((ITestCaseWizard)wizard));
                            wizardElement.setId(wizardDescriptors[j].getId());
                            wizardElement.setLabel(wizardDescriptors[j].getName());
                            wizardElement.setDescription(wizardDescriptors[j].getDescription());
                            wizardElement.setImageDescriptor(wizardDescriptors[j].getImageDescriptor());
                            wizardElements.add(wizardElement);
                        }
                        ++j;
                    }
                }
                selPage.setTestSuite(this.getTestSuite());
                selPage.setWizardElements(wizardElements.toArray(new IWizardElement[wizardElements.size()]));
            }
        }
        return page;
    }

    public ITestSuite getTestSuite() {
        return this.TSElem;
    }

    public void setTestSuite(ITestSuite elem) {
        this.TSElem = elem;
    }

    private class TestSuiteValidator
    implements ISelectionStatusValidator {
        private final IStatus errorStatus = new Status(4, UiPlugin.getID(), 4, "", null);
        private final IStatus errorMessageStatus = new Status(4, UiPlugin.getID(), 4, UiPluginResourceBundle._ERROR_WIZ_SEL_INVALID, null);
        private final IStatus okStatus = new Status(0, UiPlugin.getID(), 0, "", null);

        private TestSuiteValidator() {
        }

        public IStatus validate(Object[] selection) {
            if (selection.length == 0) {
                return this.errorStatus;
            }
            if (selection.length == 1 && selection[0] instanceof ITestSuiteProxyNode) {
                return this.okStatus;
            }
            return this.errorMessageStatus;
        }
    }
}

