/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.wizard.TestLogImportWizardPage;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class TestLogImportWizard
extends Wizard
implements IImportWizard {
    TestLogImportWizardPage mainPage;

    public boolean performFinish() {
        final IFile modelTarget = this.mainPage.createNewFile();
        final File fragmentFile = this.mainPage.getFragmentFile();
        final boolean database = this.mainPage.isDatabase();
        final IFile testSuite = this.mainPage.getTestSuite();
        Job importJob = new Job(UiPluginResourceBundle.TestLogImportWizard_IMPORT_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                boolean result = TestLogImportWizard.this.importTestLog(fragmentFile, modelTarget, testSuite, database, monitor);
                try {
                    modelTarget.delete(true, monitor);
                }
                catch (CoreException coreException) {}
                if (result) {
                    IResource testResultResource = ResourcesPlugin.getWorkspace().getRoot().findMember(String.valueOf(modelTarget.getFullPath().toString()) + "." + "execution");
                    if (testResultResource != null && testResultResource.getType() == 1) {
                        TestUIUtil.openEditor((IFile)testResultResource, "org.eclipse.hyades.test.ui.forms.editor.TestLogViewer");
                    }
                    return new Status(0, "org.eclipse.hyades.test.ui", 0, "", null);
                }
                return new Status(0, "org.eclipse.hyades.test.ui", 0, "", null);
            }
        };
        importJob.setUser(true);
        importJob.schedule();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("import_xml_test_log_wiz.gif"));
        this.setWindowTitle(UiPluginResourceBundle.TestLogImportWizard_PAGE_TITLE);
        this.setNeedsProgressMonitor(true);
        this.mainPage = new TestLogImportWizardPage(UiPluginResourceBundle.TestLogImportWizard_PAGE_TITLE, selection);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }

    protected boolean importTestLog(File fragmentFile, IFile modelTarget, IFile testSuite, boolean isDatabase, IProgressMonitor monitor) {
        boolean isCancelled;
        block15: {
            isCancelled = false;
            XMLExecutionDataProcessor processor = new XMLExecutionDataProcessor();
            EObject[] roots = EMFUtil.load(null, (IFile)testSuite);
            ITest test = null;
            try {
                test = (ITest)roots[0];
            }
            catch (ClassCastException e1) {
                e1.printStackTrace();
                monitor.done();
                return false;
            }
            try {
                try {
                    HashMap<String, String> optionsMap = new HashMap<String, String>();
                    optionsMap.put("DATABASE", Boolean.toString(isDatabase));
                    processor.setInitData(test, "localhost", modelTarget.getName(), modelTarget.getParent().getFullPath().toString(), false, null, null, optionsMap);
                    processor.init();
                    try {
                        try {
                            long importSize = fragmentFile.length();
                            long onePercentWork = importSize / 100L;
                            long currentWork = 0L;
                            long totalBytes = 0L;
                            long totalEvents = 0L;
                            monitor.beginTask("", 100);
                            BufferedReader reader = new BufferedReader(new FileReader(fragmentFile));
                            String event = reader.readLine();
                            while (event != null) {
                                if (monitor.isCanceled()) {
                                    isCancelled = true;
                                    break;
                                }
                                byte[] bytes = event.getBytes();
                                totalBytes += (long)bytes.length;
                                ++totalEvents;
                                if ((currentWork += (long)bytes.length) > onePercentWork) {
                                    monitor.worked(1);
                                    currentWork -= onePercentWork;
                                }
                                processor.loadEvent(bytes, bytes.length);
                                event = reader.readLine();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            processor.dataServerExited();
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        processor.dataServerExited();
                        throw throwable;
                    }
                    processor.dataServerExited();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    monitor.done();
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
        }
        monitor.done();
        return !isCancelled;
    }
}

