/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard.selection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.component.ProxyNodeSelectionDialog;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;

public class WizardResourceSelectionPage
extends WizardSelectionPage
implements SelectionListener,
ModifyListener {
    private IWorkbench workbench;
    private IStructuredSelection structuredSelection;
    private IWizardNode newFileWizardNode;
    private String fileExtension;
    private Button useExistButton;
    private Button createNewButton;
    private Button browseButton;
    private Text existFileText;
    private boolean isValid;
    private List selectedIResources;

    public WizardResourceSelectionPage(String pageName, IWorkbench workbench, IStructuredSelection structuredSelection, String fileExtension, IWizardNode newFileWizardNode) {
        super(pageName);
        this.workbench = workbench;
        this.structuredSelection = structuredSelection;
        this.fileExtension = fileExtension;
        this.newFileWizardNode = newFileWizardNode;
        this.isValid = false;
        this.setTitle(UiPluginResourceBundle.DLG_RESOURCE_SEL);
        this.setMessage(UiPluginResourceBundle.DLG_RESOURCE_DSC);
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 32);
        group.setLayout((Layout)new GridLayout(1, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UiPlugin.getID()) + ".resw0001");
        this.useExistButton = new Button((Composite)group, 16);
        this.useExistButton.setText(UiPluginResourceBundle.DLG_RESOURCE_USE_EXST);
        this.useExistButton.setSelection(true);
        this.useExistButton.addSelectionListener((SelectionListener)this);
        Composite browseContainer = new Composite((Composite)group, 0);
        browseContainer.setLayoutData((Object)new GridData(768));
        GridLayout browseLayout = new GridLayout();
        browseLayout.numColumns = 3;
        browseContainer.setLayout((Layout)browseLayout);
        Label label = new Label(browseContainer, 0);
        label.setText(UiPluginResourceBundle.DLG_RESOURCE_EXST);
        this.existFileText = new Text(browseContainer, 2048);
        this.existFileText.setLayoutData((Object)new GridData(768));
        this.existFileText.addModifyListener((ModifyListener)this);
        this.browseButton = new Button(browseContainer, 8);
        this.browseButton.setText(UiPluginResourceBundle.BTN_BROWSE);
        this.browseButton.addSelectionListener((SelectionListener)this);
        this.createNewButton = new Button((Composite)group, 16);
        this.createNewButton.setText(UiPluginResourceBundle.DLG_RESOURCE_NEW);
        this.createNewButton.setLayoutData((Object)new GridData(512));
        this.createNewButton.addSelectionListener((SelectionListener)this);
        this.setControl((Control)group);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.existFileText.setFocus();
        }
    }

    protected IWizardNode getNewFileWizardNode() {
        IWizard wizard;
        if (this.newFileWizardNode != null && !this.newFileWizardNode.isContentCreated() && (wizard = this.newFileWizardNode.getWizard()) instanceof IWorkbenchWizard) {
            ((IWorkbenchWizard)wizard).init(this.workbench, this.structuredSelection);
            wizard.addPages();
        }
        return this.newFileWizardNode;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        IProxyNode[] selectedProxyNodes;
        ProxyNodeSelectionDialog proxyNodeSelectionDialog;
        if (e.widget == this.useExistButton) {
            if (this.isValid) {
                this.setPageComplete(true);
            }
            this.existFileText.setEnabled(true);
            this.browseButton.setEnabled(true);
            this.browseButton.setFocus();
            super.setSelectedNode(null);
        } else if (e.widget == this.createNewButton) {
            this.setPageComplete(false);
            this.existFileText.setEnabled(false);
            this.browseButton.setEnabled(false);
            super.setSelectedNode(this.getNewFileWizardNode());
        } else if (e.widget == this.browseButton && (proxyNodeSelectionDialog = new ProxyNodeSelectionDialog(Display.getCurrent().getActiveShell(), UiPluginResourceBundle.DLG_RESOURCE_SEL, new String[]{this.fileExtension}, 16)).open() == 0 && (selectedProxyNodes = proxyNodeSelectionDialog.getSelectedProxyNodes()).length > 0) {
            StringBuffer selectedPaths = new StringBuffer();
            this.selectedIResources = new ArrayList();
            int counter = 0;
            while (counter < selectedProxyNodes.length) {
                IResource resource = selectedProxyNodes[counter].getUnderlyingResource();
                this.selectedIResources.add(resource);
                if (selectedPaths.length() > 0) {
                    selectedPaths.append(", ");
                }
                selectedPaths.append(resource.getFullPath().toString());
                ++counter;
            }
            this.existFileText.removeModifyListener((ModifyListener)this);
            this.existFileText.setText(selectedPaths.toString());
            this.isValid = true;
            this.setPageComplete(true);
            this.existFileText.addModifyListener((ModifyListener)this);
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.existFileText) {
            this.selectedIResources = new ArrayList();
            String fileText = this.existFileText.getText();
            if (fileText != null && fileText.length() > 0) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                StringTokenizer tokenizer = new StringTokenizer(fileText, ",");
                while (tokenizer.hasMoreTokens()) {
                    String path = tokenizer.nextToken().trim();
                    if (path.length() <= 0) continue;
                    IResource resource = root.findMember(path);
                    if (resource == null || !resource.exists() || !this.fileExtension.equals(resource.getFileExtension())) {
                        this.isValid = false;
                        this.setPageComplete(this.isValid);
                        this.setErrorMessage(path.concat(UiPluginResourceBundle._ERROR_DLG_RESOURCE_INVLD));
                        return;
                    }
                    this.selectedIResources.add(resource);
                }
            }
            this.isValid = this.selectedIResources.size() > 0;
            this.setPageComplete(this.isValid);
            this.setErrorMessage(null);
        }
    }

    public EObject[] getSelectedEObjects() {
        if (this.selectedIResources == null) {
            return new EObject[0];
        }
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        Iterator selectedIResourcesIterator = this.selectedIResources.iterator();
        while (selectedIResourcesIterator.hasNext()) {
            EObject[] eObjects = EMFUtil.getEObjects((URI)URI.createPlatformResourceURI((String)((IResource)selectedIResourcesIterator.next()).getFullPath().toString(), (boolean)false), (boolean)true);
            if (eObjects == null || eObjects.length <= 0) continue;
            int counter = 0;
            while (counter < eObjects.length) {
                selectedEObjects.add(eObjects[counter]);
                ++counter;
            }
        }
        return selectedEObjects.toArray(new EObject[selectedEObjects.size()]);
    }
}

