/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.launch.tabGroups;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.sourcelookup.SourceLookupTab;
import org.eclipse.hyades.test.ui.launch.tabGroups.TestLaunchConfigurationTabFactory;
import org.eclipse.hyades.trace.ui.internal.launcher.DestinationTab;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileTab;

public abstract class AbstractTabGroup
extends AbstractLaunchConfigurationTabGroup {
    private boolean userActionsPerfomed;
    private TestLaunchConfigurationTabFactory tabFactory;

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        this.tabFactory = new TestLaunchConfigurationTabFactory(this);
        ArrayList tabs = new ArrayList(5);
        this.addRunnableItemSelectionTab(tabs, mode);
        this.addExecutionHistoryTab(tabs);
        this.addAdditionalTabs(tabs, mode);
        if (this.isProfilingMode(mode)) {
            this.addProfilingTab(tabs, this.getProfilingAttachOption());
        }
        if (this.isDebugMode(mode)) {
            this.addDebuggingTab(tabs);
        }
        this.addCommonTab(tabs);
        ILaunchConfigurationTab[] array = new ILaunchConfigurationTab[tabs.size()];
        tabs.toArray(array);
        this.setTabs(array);
    }

    protected boolean isProfilingMode(String mode) {
        return mode.equals("profile");
    }

    protected boolean isDebugMode(String mode) {
        return mode.equals("debug");
    }

    protected abstract void addRunnableItemSelectionTab(List var1, String var2);

    protected void addExecutionHistoryTab(List tabList) {
        tabList.add(this.tabFactory.newTestLogTab(this._getLaunchConfigurationType()));
    }

    protected void addAdditionalTabs(List tabList, String mode) {
    }

    protected void addProfilingTab(List tabList, boolean attach) {
        tabList.add(new ProfileTab(false));
        tabList.add(new DestinationTab());
    }

    protected void addDebuggingTab(List tabList) {
        tabList.add(new SourceLookupTab());
    }

    protected void addCommonTab(List tabList) {
        tabList.add(new CommonTab());
    }

    protected boolean getProfilingAttachOption() {
        return true;
    }

    protected String getLaunchConfigurationType() {
        return null;
    }

    protected void addTestAndDeploymentTab(List tabList, String mode) {
        tabList.add(this.tabFactory.newTestAndDeploymentTab(mode, this._getLaunchConfigurationType()));
    }

    protected void addTestComponentAndDeploymentTab(List tabList, String mode) {
        tabList.add(this.tabFactory.newTestComponentAndDeploymentTab(mode, this._getLaunchConfigurationType()));
    }

    protected final String _getLaunchConfigurationType() {
        String lcType = this.getLaunchConfigurationType();
        return lcType == null ? "org.eclipse.hyades.test.ui.launch.basicTest" : lcType;
    }

    public final void setUserActionsPerformed(boolean state) {
        this.userActionsPerfomed = state;
    }

    public final boolean getUserActionsPerformed() {
        return this.userActionsPerfomed;
    }

    protected TestLaunchConfigurationTabFactory getTabFactory() {
        return this.tabFactory;
    }
}

