/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.navigator;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IDecision;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TypedElementFactoryManager;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteTestInvocationChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.LaunchConfigurationDeleteChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.LaunchConfigurationUpdateChange;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.HyadesProxyNodeFactory;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IPersistableTypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.TypedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public class DefaultTestSuiteProxyNode
extends TypedElementProxyNode
implements ITestSuiteProxyNode,
IPersistableProxyNode {
    private IAssociationDescriptor descriptor;
    private CMNNamedElementProxyNode[] testCases;

    public DefaultTestSuiteProxyNode(TPFTestSuite ts, Object parent) {
        super((TPFTest)ts, parent);
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
        IAssociationMapping associationMapping = registry.getAssociationMapping("typeDescriptions");
        this.descriptor = associationMapping.getDefaultAssociationDescriptor(ts.getType());
        LinkedList<IProxyNode> tcProxies = new LinkedList<IProxyNode>();
        EList testcases = ts.getTestCases();
        for (TPFTestCase tc : testcases) {
            IProxyNode proxy = HyadesProxyNodeFactory.getInstance().create((EObject)tc, this);
            if (proxy == null) continue;
            tcProxies.add(proxy);
        }
        this.testCases = tcProxies.toArray(new CMNNamedElementProxyNode[tcProxies.size()]);
        for (DPLDatapool dp : ts.getDatapools()) {
            IProxyNode dpProxy = FileProxyNodeCache.getInstance().getCorrespondingProxy(dp);
            if (dpProxy == null) continue;
            this.addBidirectionalReference("Test2Datapool", (IReferencerProxyNode)dpProxy, "Datapool2Test");
        }
        this.addInvocationReferences(ts.getImplementor().getBlock());
    }

    private void addInvocationReferences(IBlock block) {
        if (block != null) {
            List actions = block.getActions();
            for (Object action : actions) {
                IProxyNode invokedProxy;
                ITestInvocation invocationAction;
                ITest invokedTest;
                if (action instanceof ILoop) {
                    this.addInvocationReferences(((ILoop)action).getBlock());
                    continue;
                }
                if (action instanceof IDecision) {
                    IDecision ifAction = (IDecision)action;
                    this.addInvocationReferences(ifAction.getFailureBlock());
                    this.addInvocationReferences(ifAction.getSuccessBlock());
                    continue;
                }
                if (!(action instanceof ITestInvocation) || (invokedTest = (invocationAction = (ITestInvocation)action).getInvokedTest()) == null || ((EObject)invocationAction).eResource() == ((EObject)invokedTest).eResource() || (invokedProxy = FileProxyNodeCache.getInstance().getCorrespondingProxy(invokedTest)) == null) continue;
                this.addBidirectionalReference("TestInvoker2TestInvoked", (IReferencerProxyNode)invokedProxy, "TestInvoked2TestInvoker");
            }
        }
    }

    public DefaultTestSuiteProxyNode(IMemento memento, Object parent) {
        super(memento, parent);
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
        IAssociationMapping associationMapping = registry.getAssociationMapping("typeDescriptions");
        this.descriptor = associationMapping.getDefaultAssociationDescriptor(this.getType());
        IMemento[] tcStates = memento.getChildren("childNode");
        LinkedList<IProxyNode> tcProxies = new LinkedList<IProxyNode>();
        int i = 0;
        while (i < tcStates.length) {
            IProxyNode proxy;
            IMemento mementoChild = tcStates[i];
            mementoChild.putString("uriRoot", memento.getString("uriRoot"));
            String type = this.getType();
            if (type == null) {
                throw new IllegalArgumentException("Malformed saved proxy state: unable to retrieve type field");
            }
            ITypedElementProxyFactory factory = TypedElementFactoryManager.getInstance().getFactory(type);
            if (factory instanceof IPersistableTypedElementProxyFactory && (proxy = ((IPersistableTypedElementProxyFactory)factory).recreate(mementoChild, this)) != null) {
                tcProxies.add(proxy);
            }
            ++i;
        }
        this.testCases = tcProxies.toArray(new CMNNamedElementProxyNode[tcProxies.size()]);
    }

    public Image getImage() {
        if (this.descriptor == null) {
            return TestUIImages.INSTANCE.getImage("testsuite_obj.gif");
        }
        return this.descriptor.getImage();
    }

    public IProxyNode[] getChildren() {
        return this.testCases;
    }

    public TPFTestSuite getTestSuite() {
        EObject ts = this.getEObject();
        if (ts instanceof TPFTestSuite) {
            return (TPFTestSuite)ts;
        }
        return null;
    }

    public String getFactoryID() {
        return "EMFResourceProxyFactory_4.3";
    }

    protected String getNodeKind() {
        return "testSuiteNode";
    }

    public boolean saveState(IMemento memento) {
        super.saveState(memento);
        int i = 0;
        while (i < this.testCases.length) {
            CMNNamedElementProxyNode tcProxy = this.testCases[i];
            if (tcProxy instanceof IPersistableProxyNode) {
                IMemento childMemento = memento.createChild("childNode");
                if (!tcProxy.saveState(childMemento)) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void launchConfigurationUpdateChanges(CompositeChange composite, URI newURI) {
        ILaunchConfigurationType configsType = TestLaunchConfigurationFacade.getLaunchConfigurationType();
        ILaunchConfiguration[] configs = new ILaunchConfiguration[]{};
        try {
            configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configsType);
        }
        catch (CoreException e) {
            UiPlugin.logError("Unable to get Launch Configuraions", e);
        }
        int i = 0;
        while (i < configs.length) {
            try {
                URI originatorURI = this.getOriginatorURI();
                if (TestLaunchConfigurationFacade.isTestURI((ILaunchConfiguration)configs[i], (URI)originatorURI)) {
                    composite.add((Change)new LaunchConfigurationUpdateChange(configs[i], newURI.appendFragment(originatorURI.fragment())));
                }
            }
            catch (CoreException e) {
                UiPlugin.logError("Unable to update Launch Configuraions", e);
            }
            ++i;
        }
    }

    private void launchConfigurationDeleteChanges(CompositeChange composite) {
        ILaunchConfigurationType configsType = TestLaunchConfigurationFacade.getLaunchConfigurationType();
        ILaunchConfiguration[] configs = new ILaunchConfiguration[]{};
        try {
            configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configsType);
        }
        catch (CoreException e) {
            UiPlugin.logError("Unable to get Launch Configuraions", e);
        }
        int i = 0;
        while (i < configs.length) {
            try {
                URI originatorURI = this.getOriginatorURI();
                if (TestLaunchConfigurationFacade.isTestURI((ILaunchConfiguration)configs[i], (URI)originatorURI)) {
                    composite.add((Change)new LaunchConfigurationDeleteChange(configs[i]));
                }
            }
            catch (CoreException e) {
                UiPlugin.logError("Unable to delete Launch Configuraions", e);
            }
            ++i;
        }
    }

    public Change createRenameChange(IRefactoringContext context, String newName) {
        CompositeChange composite = new CompositeChange("");
        Change superChange = super.createRenameChange(context, newName);
        if (superChange != null && superChange instanceof CMNNamedElementProxyNode.RenameModelChange) {
            this.launchConfigurationUpdateChanges(composite, ((CMNNamedElementProxyNode.RenameModelChange)superChange).getNewURI());
            composite.add(superChange);
        }
        composite.markAsSynthetic();
        return composite;
    }

    public Change createMoveChange(IRefactoringContext context, IPath destinationPath) {
        CompositeChange composite = new CompositeChange("");
        this.launchConfigurationUpdateChanges(composite, URI.createPlatformResourceURI((String)destinationPath.toPortableString(), (boolean)false));
        Change superChange = super.createMoveChange(context, destinationPath);
        if (superChange != null) {
            composite.add(superChange);
        }
        composite.markAsSynthetic();
        return composite;
    }

    public Change createUpdateChange(IRefactoringContext context, IContainer container, IPath destinationPath) {
        CompositeChange composite = new CompositeChange("");
        this.launchConfigurationUpdateChanges(composite, URI.createPlatformResourceURI((String)destinationPath.toPortableString(), (boolean)false));
        Change superChange = super.createUpdateChange(context, container, destinationPath);
        if (superChange != null) {
            composite.add(superChange);
        }
        composite.markAsSynthetic();
        return composite;
    }

    public Change createUpdateChange(IRefactoringContext context, IReferencerProxyNode referenced, String refType, IPath destinationPath) {
        if (destinationPath == null && "TestInvoked2TestInvoker".equals(refType)) {
            return new DeleteTestInvocationChange(context, this, referenced);
        }
        return super.createUpdateChange(context, referenced, refType, destinationPath);
    }

    public Change createDeleteChange(IRefactoringContext context) {
        CompositeChange composite = new CompositeChange("");
        this.launchConfigurationDeleteChanges(composite);
        Change superChange = super.createDeleteChange(context);
        if (superChange != null) {
            composite.add(superChange);
        }
        composite.markAsSynthetic();
        return composite;
    }
}

