/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.navigator;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IExtendedProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.ReferenceRegistry;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteModelElementChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.ModelPathChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.MoveModelChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.PasteModelChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.UpdateModelChange;
import org.eclipse.hyades.test.ui.navigator.AbstractProxy;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxy;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeDeleter;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeMover;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodePaster;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeUpdater;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ui.IMemento;

public abstract class EObjectProxyNode
extends AbstractProxy
implements IPersistableProxyNode,
IExtendedProxyNode,
IReferencerProxyNode,
IProxyNodeMover,
IProxyNodeUpdater,
IProxyNodeDeleter,
IProxyNodePaster {
    private static final String TAG_URI_FRAGMENT = "uriFragment";
    private URI originatorURI;
    private Object parent;

    public EObjectProxyNode(URI uri, Object parent) {
        this.originatorURI = uri;
        this.parent = parent;
    }

    public EObjectProxyNode(IMemento memento, Object parent) {
        String uriFragmentName;
        String uri = memento.getString("uri");
        if (uri != null) {
            URI oldURI = URI.createURI((String)uri);
            uriFragmentName = oldURI.fragment();
        } else {
            uriFragmentName = memento.getString(TAG_URI_FRAGMENT);
        }
        String uriRootName = memento.getString("uriRoot");
        try {
            URI uriRoot = URI.createPlatformResourceURI((String)uriRootName, (boolean)false);
            this.originatorURI = uriRoot.appendFragment(uriFragmentName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Malformed saved proxy state: unable to retrieve uri field");
        }
        this.parent = parent;
    }

    public EObjectProxyNode(EObject eObject, Object parent) {
        this.originatorURI = EcoreUtil.getURI((EObject)eObject);
        this.parent = parent;
    }

    public EObject getEObject() {
        return EMFUtil.getEObject((ResourceSet)new ResourceSetImpl(), (URI)this.originatorURI, (boolean)true);
    }

    public Object getParent() {
        return this.parent;
    }

    public URI getOriginatorURI() {
        return this.originatorURI;
    }

    public String getIdentifier() {
        String fragment = this.originatorURI.fragment();
        if (fragment != null) {
            return fragment;
        }
        return "";
    }

    private IResource getWorkspaceResource(URI uri) {
        String uriPath = uri.trimFragment().toString();
        if (uriPath.startsWith("platform:/resource")) {
            String path = uriPath.substring("platform:/resource".length());
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        }
        return null;
    }

    public IResource getUnderlyingResource() {
        return this.getWorkspaceResource(this.originatorURI);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(IFile.class) && this.getParent() instanceof FileProxyManager.IUnboundedParent) {
            return this.getUnderlyingResource();
        }
        if (adapter == IProxyNodeUpdater.class || adapter == IProxyNodeMover.class || adapter == IProxyNodeDeleter.class || adapter == IProxyNodePaster.class) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void addReference(String refType, IProxy proxyRef) {
        IResource ur = proxyRef.getUnderlyingResource();
        if (ur instanceof IFile) {
            ReferenceRegistry.getInstance().addReference((IFile)this.getUnderlyingResource(), refType, (IFile)ur);
        }
    }

    public void addBidirectionalReference(String refType, IReferencerProxyNode proxyRef, String oppositeRefType) {
        IResource ur = proxyRef.getUnderlyingResource();
        if (ur instanceof IFile) {
            ReferenceRegistry.getInstance().addBidirectionalReference((IFile)this.getUnderlyingResource(), refType, (IFile)ur, oppositeRefType);
        }
    }

    public void removeReference(IProxyNode proxyRef) {
        IResource ur = proxyRef.getUnderlyingResource();
        if (ur instanceof IFile) {
            ReferenceRegistry.getInstance().removeReference((IFile)this.getUnderlyingResource(), (IFile)ur);
        }
    }

    public Collection getReferences(String refType) {
        return ReferenceRegistry.getInstance().getReferences((IFile)this.getUnderlyingResource(), refType);
    }

    public Set getReferenceTypes() {
        return ReferenceRegistry.getInstance().getReferenceTypes((IFile)this.getUnderlyingResource());
    }

    public boolean saveState(IMemento memento) {
        memento.putString("nodeKind", this.getNodeKind());
        memento.putString(TAG_URI_FRAGMENT, this.getOriginatorURI().fragment());
        return true;
    }

    public Change createMoveChange(IRefactoringContext context, IPath destinationPath) {
        return this.getAdapter(IFile.class) != null ? new MoveModelChange(this, context, destinationPath) : null;
    }

    public Change createUpdateChange(IRefactoringContext context, IReferencerProxyNode referenced, String refType, IPath destinationPath) {
        return new UpdateModelChange(this, context);
    }

    public Change createUpdateChange(IRefactoringContext context, IContainer container, IPath destinationPath) {
        return new ModelPathChange(this, context, destinationPath);
    }

    public Change createDeleteChange(IRefactoringContext context) {
        return new DeleteModelElementChange(context, this);
    }

    public Change createPasteChange(IRefactoringContext context, IPath destinationPath, String[] targetName) {
        return new PasteModelChange(context, this, destinationPath, targetName);
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof EObjectProxyNode) {
            URI argURI = ((EObjectProxyNode)arg0).originatorURI;
            return this.originatorURI == null && argURI == null || this.originatorURI != null && this.originatorURI.equals((Object)argURI);
        }
        return false;
    }

    public int hashCode() {
        return this.originatorURI != null ? this.originatorURI.hashCode() : -2;
    }

    public String getFactoryID() {
        return "EMFResourceProxyFactory_4.3";
    }

    protected abstract String getNodeKind();

    public IResource getCorrespondingResource() {
        return this.getUnderlyingResource();
    }
}

