/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.navigator;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IExtendedProxyNode;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.AbstractProxy;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer;
import org.eclipse.hyades.test.ui.navigator.actions.RenamerUIInlineEditor;
import org.eclipse.hyades.test.ui.navigator.actions.RenamerUIStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class FileProxyNode
extends AbstractProxy
implements IProxyNodeRenamer,
IExtendedProxyNode {
    private IFile file;

    public FileProxyNode(IFile file) {
        this.file = file;
    }

    public String getText() {
        return this.file.getName();
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }

    public Object getParent() {
        return this.file.getParent();
    }

    public IFile getFile() {
        return this.file;
    }

    public String getIdentifier() {
        return "";
    }

    public IResource getUnderlyingResource() {
        return this.file;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean isApplicableFor() {
        return true;
    }

    public boolean performRename(String newName) {
        if (!newName.equals(this.file.getName())) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(newName, this.file.getType());
            if (!status.isOK()) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)UiPluginResourceBundle.W_ERROR, (String)status.getMessage());
            } else {
                final IPath newPath = this.file.getFullPath().removeLastSegments(1).append(newName);
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) {
                        try {
                            FileProxyNode.this.file.move(newPath, 34, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, (IRunnableWithProgress)op);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return false;
    }

    public RenamerUIStatus performUserInteraction(String oldName) {
        return new RenamerUIInlineEditor();
    }

    public IResource getCorrespondingResource() {
        return this.file;
    }
}

