/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.navigator.refactoring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.navigator.IRefactoringTransaction;
import org.eclipse.ltk.core.refactoring.Change;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFRefactoringTransaction
implements IRefactoringTransaction {
    private Set<Resource> resources = new HashSet<Resource>();
    private Map<Resource, URI> resourceURIMap = new HashMap<Resource, URI>();
    private ResourceSet resourceSet = new ResourceSetImpl();
    private List<Change> customChange = new ArrayList<Change>();
    public static final String EMF_REFACTORING_TRANSACTION_ID = "org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction";

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public Set<Resource> getChangedResources() {
        return this.resourceURIMap.keySet();
    }

    public List<Change> getCustomChanges() {
        return this.customChange;
    }

    public URI getChangedResourceURI(Resource resource) {
        return this.resourceURIMap.get(resource);
    }

    public void addChangedResourceURI(Resource resource, URI newURI) {
        this.resourceURIMap.put(resource, newURI);
    }

    public void addCustomChange(Change change) {
        this.customChange.add(change);
    }

    public Set<Resource> getSavedResources() {
        return this.resources;
    }

    public void addSavedResource(Resource resource) {
        Assert.isNotNull((Object)resource);
        if (!this.resources.contains(resource)) {
            this.resources.add(resource);
        }
    }

    @Override
    public void beginChanges(IProgressMonitor monitor) {
    }

    @Override
    public void cancelChanges(IProgressMonitor monitor) {
    }

    @Override
    public Change commitChanges(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.getChangedResources().size() + this.getSavedResources().size() + this.getCustomChanges().size() + 1);
        try {
            LinkedList<IFile> files = new LinkedList<IFile>();
            HashMap<Resource, IFile> undoMap = new HashMap<Resource, IFile>();
            for (Resource resource : this.getChangedResources()) {
                if (resource != null) {
                    IFile file = EMFUtil.getWorkspaceFile((Resource)resource);
                    resource.setURI(this.getChangedResourceURI(resource));
                    if (file != null) {
                        files.add(file);
                        undoMap.put(resource, file);
                    }
                }
                pm.worked(1);
            }
            for (Resource resource : this.getSavedResources()) {
                block13: {
                    try {
                        EMFUtil.save((Resource)resource);
                        EMFUtil.getWorkspaceFile((Resource)resource).refreshLocal(0, pm);
                    }
                    catch (Exception e) {
                        UiPlugin.logError(e);
                        Object fileToKeep = undoMap.get(resource);
                        if (fileToKeep == null) break block13;
                        files.remove(fileToKeep);
                    }
                }
                pm.worked(1);
            }
            for (IFile localFile : files) {
                if (!localFile.isAccessible() || localFile.isReadOnly()) continue;
                localFile.delete(false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            undoMap.clear();
            Iterator<Change> changesIterator = this.customChange.iterator();
            while (changesIterator.hasNext()) {
                try {
                    Change change = changesIterator.next();
                    change.perform((IProgressMonitor)new SubProgressMonitor(pm, 0));
                }
                catch (Throwable e) {
                    UiPlugin.logError(e);
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
        return null;
    }
}

