/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.recorder.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.hyades.execution.recorder.IRecorderListener;
import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.RecorderClientUI;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.tptp.test.internal.recorder.ui.wizards.IRecorderWizard;

public class RecorderUtil {
    public static void launchRecorder(final Recorder recorder, IRecorderWizard wizard) {
        RecorderFactory.getInstance().addListener((IRecorderListener)RecorderControlView.getInstance());
        RecorderFactory.getInstance().addListener((IRecorderListener)new RecorderClientUI(recorder, wizard));
        if (wizard != null) {
            wizard.registerListeners();
        }
        Job job = new Job(UiPluginResourceBundle.RecorderClientUI_INIT_JOB){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    recorder.Record(monitor);
                }
                catch (Exception e) {
                    if (recorder != null) {
                        recorder.setActive(false);
                    }
                    e.printStackTrace();
                    RecorderControlView.getInstance().addMessage(String.valueOf(UiPluginResourceBundle.RecorderClientUI_RECORDING_ABORTED_DUE_TO_EXCEPTION_MESSAGE) + e.getMessage());
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

