/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.facades.behavioral.INamedElement;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.ReferenceRegistry;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.ReferenceTypeRegistry;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.EObjectEditorInput;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.util.RCPFileEditorInput;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.util.LocationValidator;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUIUtil {
    public static final int VALID_RESOURCE_PATH = 0;
    public static final int INVALID_RESOURCE_PATH_LENGTH = 1;
    public static final int INVALID_RESOURCE_PATH = 2;
    public static final int UNAVAILABLE_RESOURCE_PATH = 3;
    public static final int INVALID_LOGICAL_NAME_LENGTH = 4;
    public static final int INVALID_LOGICAL_NAME = 5;
    public static final int UNAVAILABLE_LOGICAL_NAME = 6;
    public static final int WINDOWS_FILE_NAME_MAX_LENGTH = 250;
    public static final boolean IS_WINDOWS_OS = "win32".equals(Platform.getWS());
    private static final char[] RESERVED_FILE_PATH_CHARS = new char[]{';', '?', '@', '&', '=', '+', '$', ',', '<', '>', '#', '%', '\"', '{', '}', '|', '^', '[', ']', '\'', '!', '*', '(', ')'};

    public static int validateResourcePath(String resourceName, IContainer container) {
        int dotIndex;
        if (!TestUIUtil.isResourcePathLengthValid(resourceName, container)) {
            return 1;
        }
        if (!TestUIUtil.isResourcePathValid(resourceName, container)) {
            return 2;
        }
        if (!TestUIUtil.isResourcePathAvailable(resourceName, container)) {
            return 3;
        }
        String logicalName = resourceName;
        if (resourceName != null && resourceName.length() > 0 && (dotIndex = resourceName.lastIndexOf(46)) != -1) {
            logicalName = resourceName.substring(0, dotIndex);
        }
        if (!TestUIUtil.isLogicalNameLengthValid(logicalName)) {
            return 4;
        }
        if (!TestUIUtil.isLogicalNameValid(logicalName)) {
            return 5;
        }
        if (!TestUIUtil.isLogicalNameAvailable(logicalName, container)) {
            return 6;
        }
        return 0;
    }

    public static boolean isResourcePathLengthValid(String resourceName, IContainer container) {
        if (resourceName != null && resourceName.trim().length() > 0 && container != null) {
            return TestUIUtil.isResourcePathLengthValid(container.getFullPath().append(resourceName).toOSString());
        }
        return false;
    }

    public static boolean isResourcePathLengthValid(String resourcePath) {
        if (resourcePath != null && resourcePath.trim().length() > 0) {
            if (IS_WINDOWS_OS) {
                return resourcePath.length() <= 250;
            }
            return true;
        }
        return false;
    }

    public static boolean isResourcePathValid(String resourceName, IContainer container) {
        if (resourceName != null && resourceName.trim().length() > 0 && container != null) {
            String resourcePath;
            IPath resourceFullPath = container.getFullPath();
            int resourceType = 4;
            if (resourceFullPath.segmentCount() > 0) {
                resourceType = 3;
            }
            return TestUIUtil.isFilePathValid(resourcePath = resourceFullPath.append(resourceName).toOSString()) && Path.ROOT.isValidPath(resourcePath) && ResourcesPlugin.getWorkspace().validatePath(resourcePath, resourceType).isOK();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isResourcePathAvailable(String resourceName, IContainer container) {
        if (resourceName != null && resourceName.trim().length() > 0 && container != null) {
            try {
                IResource[] children = container.members();
                int counter = 0;
                while (true) {
                    String extension;
                    String name;
                    if (counter >= children.length) {
                        return true;
                    }
                    String nameWithoutExtension = name = children[counter].getName();
                    if (children[counter] instanceof IFile && (extension = children[counter].getFileExtension()) != null) {
                        nameWithoutExtension = name.substring(0, name.length() - extension.length() - 1);
                    }
                    if (IS_WINDOWS_OS ? name.equalsIgnoreCase(resourceName) || nameWithoutExtension.equalsIgnoreCase(resourceName) : name.equals(resourceName) || nameWithoutExtension.equals(resourceName)) {
                        return false;
                    }
                    ++counter;
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public static boolean isLogicalNameLengthValid(String logicalName) {
        return logicalName != null && logicalName.trim().length() > 0;
    }

    public static boolean isLogicalNameValid(String logicalName) {
        if (logicalName != null && logicalName.trim().length() > 0) {
            return LocationValidator.validateEMFSegment((String)logicalName) == null && !logicalName.startsWith("-") && !logicalName.endsWith("-") && !logicalName.startsWith(" ") && !logicalName.endsWith(" ") && !logicalName.startsWith(".") && !logicalName.endsWith(".") && logicalName.indexOf(58) == -1 && logicalName.indexOf(92) == -1 && logicalName.indexOf(47) == -1;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLogicalNameAvailable(String logicalName, IContainer container) {
        if (logicalName != null && logicalName.trim().length() > 0 && container != null) {
            try {
                IFileProxyManager fileProxyManager = TestNavigator.getFileProxyManager();
                if (fileProxyManager == null) {
                    fileProxyManager = new FileProxyManager();
                }
                IResource[] children = container.members();
                int counter = 0;
                while (true) {
                    IProxyNode proxy;
                    if (counter >= children.length) {
                        return true;
                    }
                    if (children[counter] instanceof IFile && (proxy = fileProxyManager.getProxy((IFile)children[counter], null)) != null && proxy instanceof CMNNamedElementProxyNode && (IS_WINDOWS_OS ? ((CMNNamedElementProxyNode)proxy).getName().equalsIgnoreCase(logicalName) : ((CMNNamedElementProxyNode)proxy).getName().equals(logicalName))) {
                        return false;
                    }
                    ++counter;
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public static boolean isFilePathValid(String filePath) {
        if (filePath != null && filePath.trim().length() > 0) {
            int i = 0;
            while (i < RESERVED_FILE_PATH_CHARS.length) {
                if (filePath.indexOf(RESERVED_FILE_PATH_CHARS[i]) != -1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String getLabel(Object object) {
        IWorkbenchAdapter workbenchAdapter;
        if (object instanceof IAdaptable && (workbenchAdapter = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(IWorkbenchAdapter.class)) != null) {
            return workbenchAdapter.getLabel(object);
        }
        if (object instanceof INamedElement) {
            return ((INamedElement)object).getName();
        }
        return String.valueOf(object);
    }

    public static IEditorPart openEditor(Resource resource, String editorId, boolean activate) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IFile file = EMFUtil.getWorkspaceFile((Resource)resource);
        if (file != null && file.exists()) {
            if (editorId == null || editorId.trim().length() == 0) {
                IEditorDescriptor descriptor = workbench.getEditorRegistry().getDefaultEditor(file.getName());
                editorId = descriptor != null ? descriptor.getId() : "org.eclipse.ui.DefaultTextEditor";
            }
            return UIUtil.openEditor((IFile)file, (String)editorId, (boolean)false);
        }
        File ioFile = new File(EMFUtil.getFilePath((Resource)resource));
        if (ioFile.exists()) {
            if (editorId == null || editorId.trim().length() == 0) {
                IEditorDescriptor descriptor = workbench.getEditorRegistry().getDefaultEditor(ioFile.getName());
                editorId = descriptor != null ? descriptor.getId() : "org.eclipse.ui.DefaultTextEditor";
            }
            try {
                if (workbench.getActiveWorkbenchWindow() != null) {
                    return workbench.getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new RCPFileEditorInput(ioFile), editorId, activate);
                }
                if (workbench.getWorkbenchWindows().length > 0) {
                    return workbench.getWorkbenchWindows()[0].getActivePage().openEditor((IEditorInput)new RCPFileEditorInput(ioFile), editorId, activate);
                }
            }
            catch (PartInitException e) {
                UiPlugin.logError(e);
            }
        }
        return null;
    }

    public static void openEditor(EObject eObject, String editorId) {
        try {
            TestUIUtil.openEditor((IEditorInput)new EObjectEditorInput(eObject), editorId);
        }
        catch (IllegalArgumentException i) {
            UiPlugin.logError(i);
        }
    }

    public static void openEditor(Resource resource, String editorId) {
        TestUIUtil.openEditor(EMFUtil.getWorkspaceFile((Resource)resource), editorId);
    }

    public static void openEditor(IFile file, String editorId) {
        if (file != null && file.exists()) {
            TestUIUtil.openEditor((IEditorInput)new FileEditorInput(file), editorId);
        }
    }

    public static void openEditor(final IEditorInput editorInput, final String editorId) {
        final IPreferenceStore preferenceStore = UiPlugin.getInstance().getPreferenceStore();
        final String openEditorPreferenceValue = preferenceStore.getString("openEditor");
        if (!openEditorPreferenceValue.equals("never")) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage activeWorkbenchPage = UIUtil.getActiveWorkbenchPage();
                        if (activeWorkbenchPage != null && activeWorkbenchPage.getActiveEditor() != null && activeWorkbenchPage.getActiveEditor().getEditorInput().equals(editorInput)) {
                            return;
                        }
                        boolean openEditor = true;
                        if (openEditorPreferenceValue.equals("prompt")) {
                            MessageDialogWithToggle messageDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UiPluginResourceBundle.OPEN_EDITOR_CONFIRM_DIALOG_TITLE, (String)UiPluginResourceBundle.OPEN_EDITOR_CONFIRM_DIALOG_MESSAGE, null, (boolean)false, (IPreferenceStore)preferenceStore, (String)"openEditor");
                            boolean bl = openEditor = messageDialog.getReturnCode() == 2;
                        }
                        if (openEditor) {
                            UIUtil.openEditor((IEditorInput)editorInput, (String)editorId);
                        }
                    }
                    catch (Exception e) {
                        UiPlugin.logError(e);
                    }
                }
            });
        }
    }

    public static Map<IFile, List<IFile>> getReferences(List<IFile> files, boolean isExplicit, IProgressMonitor progressMonitor) throws OperationCanceledException {
        if (files != null && files.size() > 0) {
            if (progressMonitor == null) {
                progressMonitor = new NullProgressMonitor();
            }
            try {
                progressMonitor.beginTask(RefactoringMessages.TestUIUtil_SEARCHING_REFERENCES_TASK, files.size() + 1);
                TestUIUtilities.createProxyNodes((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                HashMap<IFile, List<IFile>> references = new HashMap<IFile, List<IFile>>(files.size());
                Iterator<IFile> filesIterator = files.iterator();
                while (filesIterator.hasNext()) {
                    if (progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IFile file = filesIterator.next();
                    if (file != null) {
                        ArrayList<IFile> fileReferences = new ArrayList<IFile>();
                        for (String referenceType : ReferenceRegistry.getInstance().getReferenceTypes(file)) {
                            if (ReferenceTypeRegistry.getInstance().isExplicit(referenceType) != isExplicit) continue;
                            Iterator referencesIterator = ReferenceRegistry.getInstance().getReferences(file, referenceType).iterator();
                            while (referencesIterator.hasNext()) {
                                IFile childFile = (IFile)((IProxyNode)referencesIterator.next()).getUnderlyingResource();
                                if (childFile == null) continue;
                                fileReferences.add(childFile);
                            }
                        }
                        references.put(file, fileReferences);
                    }
                    progressMonitor.worked(1);
                }
                HashMap<IFile, List<IFile>> hashMap = references;
                return hashMap;
            }
            finally {
                progressMonitor.done();
            }
        }
        return null;
    }

    public static List<IFile> getExplicitDependencies(IFile file) {
        if (file != null) {
            ArrayList<IFile> files = new ArrayList<IFile>(1);
            files.add(file);
            try {
                Map<IFile, List<IFile>> explicitFileReferences = TestUIUtil.getReferences(files, true, (IProgressMonitor)new NullProgressMonitor());
                if (explicitFileReferences != null) {
                    return explicitFileReferences.get(file);
                }
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
        return null;
    }

    public static boolean isResourceNameLengthValid(String resourceName, IContainer container) {
        return TestUIUtil.isResourcePathLengthValid(resourceName, container);
    }

    public static boolean isResourceNameLengthValid(IResource resource, String newResourceName) {
        if (resource != null && newResourceName != null && newResourceName.trim().length() > 0) {
            if (resource instanceof IFile) {
                return TestUIUtil.isResourcePathLengthValid(newResourceName, ((IFile)resource).getParent());
            }
            if (resource instanceof IContainer) {
                return TestUIUtil.isResourcePathLengthValid(newResourceName, (IContainer)resource);
            }
        }
        return false;
    }

    public static boolean isResourceNameListLengthValid(List<String> resourceNameList, IContainer container) {
        if (resourceNameList != null && container != null) {
            Iterator<String> resourceNameListIterator = resourceNameList.iterator();
            while (resourceNameListIterator.hasNext()) {
                if (TestUIUtil.isResourcePathLengthValid(resourceNameListIterator.next(), container)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isResourceNameValid(String resourceName, IContainer container) {
        return TestUIUtil.isResourcePathValid(resourceName, container);
    }

    public static boolean isResourceNameListValid(List<String> resourceNameList, IContainer container) {
        if (resourceNameList != null && container != null) {
            Iterator<String> resourceNameListIterator = resourceNameList.iterator();
            while (resourceNameListIterator.hasNext()) {
                if (TestUIUtil.isResourcePathValid(resourceNameListIterator.next(), container)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isResourceNameAvailable(String resourceName, IContainer container) {
        return TestUIUtil.isResourcePathAvailable(resourceName, container);
    }

    public static boolean isResourceNameListAvailable(List<String> resourceNameList, IContainer container) {
        if (resourceNameList != null && container != null) {
            Iterator<String> resourceNameListIterator = resourceNameList.iterator();
            while (resourceNameListIterator.hasNext()) {
                if (TestUIUtil.isResourcePathAvailable(resourceNameListIterator.next(), container)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getUniqueName(String baseName, List<CMNNamedElement> namedElementList) {
        if (namedElementList != null && namedElementList.size() > 0) {
            int initialNumber = namedElementList.size() + 1;
            String name = baseName.concat(" ").concat(Integer.toString(initialNumber));
            Iterator<CMNNamedElement> namedElementListIterator = namedElementList.iterator();
            while (namedElementListIterator.hasNext()) {
                CMNNamedElement cmnNamedElement = namedElementListIterator.next();
                if (!name.equals(cmnNamedElement.getName())) continue;
                name = baseName.concat(" ").concat(Integer.toString(++initialNumber));
                namedElementListIterator = namedElementList.iterator();
            }
            return name;
        }
        return baseName;
    }

    public static String validateExtension(String fileName, String fileExtension) {
        if (!fileName.endsWith("." + fileExtension)) {
            return String.valueOf(fileName) + "." + fileExtension;
        }
        return fileName;
    }
}

