/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;
import org.eclipse.ui.PartInitException;

public class TestSuiteNewWizard
extends HyadesNewWizard {
    private TestLocationPage testLocationPage = null;

    public TestSuiteNewWizard() {
        this.setWindowTitle(UiPluginResourceBundle.WIZ_TST_SUITE_TTL);
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("newtestsuite_wiz.gif"));
        IDialogSettings dialogSettings = UiPlugin.getInstance().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("TestSuiteNewWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("TestSuiteNewWizard");
        }
        this.setDialogSettings(settings);
    }

    protected LocationPage getLocationPage() {
        if (this.testLocationPage == null) {
            this.testLocationPage = new TestLocationPage("testLocation", this.selection);
            String fileExtension = this.getFileExtension();
            if (fileExtension != null) {
                this.testLocationPage.setFileExtension(fileExtension);
                this.testLocationPage.setFileName("");
            }
        }
        return this.testLocationPage;
    }

    protected String getType() {
        return "org.eclipse.hyades.testSuite.generic";
    }

    protected String getFileExtension() {
        return "testsuite";
    }

    public void addPages() {
        this.getLocationPage().setTitle(UiPluginResourceBundle.WIZ_TST_SUITE_GEN_PG_TTL);
        this.getLocationPage().setDescription(UiPluginResourceBundle.WIZ_TST_SUITE_GEN_PG_LOC_DSC);
        this.addPage((IWizardPage)this.getLocationPage());
        this.getAttributeWizardPage().setTitle(UiPluginResourceBundle.WIZ_TST_SUITE_GEN_PG_TTL);
        this.getAttributeWizardPage().setDescription(UiPluginResourceBundle.WIZ_TST_SUITE_GEN_PG_ATT_DSC);
        this.addPage((IWizardPage)this.getAttributeWizardPage());
    }

    protected boolean createObject(IFile file) throws Exception {
        Resource resource = this.createResource(file);
        EObject testsuite = this.createEObject();
        resource.getContents().add((Object)testsuite);
        this.initializeCustomAttributes(testsuite);
        EMFUtil.save((Resource)resource);
        return true;
    }

    protected void initializeCustomAttributes(EObject testsuite) {
    }

    protected EObject createEObject() {
        TPFTestSuite testSuite = Common_TestprofileFactory.eINSTANCE.createTPFTestSuite();
        testSuite.setType(this.getType());
        testSuite.setName(this.getLocationPage().getFileNameWithoutExtension());
        String description = this.getAttributeWizardPage().getItemDescription();
        if (description != null && description.trim().length() > 0) {
            testSuite.setDescription(description);
        }
        if (testSuite.getBehavior() == null) {
            TPFBehavior behavior = Common_TestprofileFactory.eINSTANCE.createTPFBehavior();
            testSuite.setBehavior(behavior);
        }
        return testSuite;
    }

    protected Resource createResource(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        Resource.Factory factory = EMFUtil.getResourceFactory((String)"testsuite");
        return factory.createResource(uri);
    }

    protected void openEditor(IFile file) throws PartInitException {
        TestUIUtil.openEditor(file, "org.eclipse.hyades.test.ui.editor.TestSuiteEditorPart");
    }
}

