/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.wizard;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.core.util.JavaUtil;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;
import org.eclipse.ui.PartInitException;

public abstract class TestSuiteNewWizard2
extends HyadesNewWizard {
    private TestLocationPage testLocationPage = null;

    public TestSuiteNewWizard2() {
        this.setWindowTitle(UiPluginResourceBundle.WIZ_TST_SUITE_TTL);
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("newtestsuite_wiz.gif"));
        IDialogSettings dialogSettings = UiPlugin.getInstance().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("TestSuiteNewWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("TestSuiteNewWizard");
        }
        this.setDialogSettings(settings);
    }

    protected LocationPage getLocationPage() {
        if (this.testLocationPage == null) {
            this.testLocationPage = new TestLocationPage("testLocation", this.selection);
            String fileExtension = this.getFileExtension();
            if (fileExtension != null) {
                this.testLocationPage.setFileExtension(fileExtension);
                this.testLocationPage.setFileName("");
            }
        }
        return this.testLocationPage;
    }

    protected abstract String getType();

    protected String getFileExtension() {
        return "testsuite";
    }

    public void addPages() {
        this.getLocationPage().setTitle(UiPluginResourceBundle.WIZ_TST_SUITE_GEN_PG_TTL);
        this.getLocationPage().setDescription(UiPluginResourceBundle.WIZ_TST_SUITE_GEN_PG_LOC_DSC);
        this.addPage((IWizardPage)this.getLocationPage());
        this.getAttributeWizardPage().setTitle(UiPluginResourceBundle.WIZ_TST_SUITE_GEN_PG_TTL);
        this.getAttributeWizardPage().setDescription(UiPluginResourceBundle.WIZ_TST_SUITE_GEN_PG_ATT_DSC);
        this.addPage((IWizardPage)this.getAttributeWizardPage());
    }

    protected boolean createObject(IFile file) throws Exception {
        Resource resource = this.createResource(file);
        this.createObject(resource);
        Iterator i = resource.getResourceSet().getResources().iterator();
        while (i.hasNext()) {
            EMFUtil.save((Resource)((Resource)i.next()));
        }
        return true;
    }

    protected void createObject(Resource resource) {
        ITestSuite testSuite = HyadesFactory.INSTANCE.createTestSuite(resource);
        testSuite.setType(this.getType());
        testSuite.setName(this.getLocationPage().getFileNameWithoutExtension());
        String description = this.getAttributeWizardPage().getItemDescription();
        if (description != null && description.trim().length() > 0) {
            testSuite.setDescription(description);
        }
        if (testSuite.getImplementor() == null) {
            HyadesFactory.INSTANCE.createImplementor((ITest)testSuite, false);
        }
        this.adjustTestSuite(testSuite);
    }

    protected void adjustTestSuite(ITestSuite testSuite) {
        String clsName = JavaUtil.getValidClassName((String)testSuite.getName(), (boolean)true);
        if (clsName == null) {
            clsName = "Test";
        }
        testSuite.getImplementor().setResource("test." + clsName);
    }

    protected Resource createResource(IFile file) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        return resourceSet.createResource(uri);
    }

    protected void openEditor(IFile file) throws PartInitException {
        TestUIUtil.openEditor(file, "org.eclipse.hyades.test.ui.editor.TestSuiteEditorPart");
    }
}

