/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.test.provisional.recorder.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.test.provisional.recorder.ProvisionalRecorderMessages;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderWizard;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.TestsuiteLocationWizardPage;
import org.eclipse.ui.wizards.newresource.BasicNewFolderResourceWizard;

public abstract class CTestsuiteLocationWizardPage
extends TestsuiteLocationWizardPage {
    public CTestsuiteLocationWizardPage(IGenericRecorderWizard wizard) {
        super(wizard);
    }

    public CTestsuiteLocationWizardPage(IGenericRecorderWizard wizard, boolean bSaveLastSelected) {
        super(wizard, bSaveLastSelected);
    }

    public void createControl(Composite grandParent) {
        super.createControl(grandParent);
        Composite parent = null;
        try {
            parent = this.tree.getTree().getParent();
        }
        catch (RuntimeException runtimeException) {
            return;
        }
        if (parent == null) {
            return;
        }
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).numColumns = 2;
            ((GridLayout)layout).makeColumnsEqualWidth = false;
        }
        Composite btnGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        btnGroup.setLayout((Layout)gl);
        btnGroup.setLayoutData((Object)new GridData(1026));
        btnGroup.moveBelow((Control)this.getViewer().getTree());
        Button newProjectBtn = new Button(btnGroup, 8);
        newProjectBtn.setText(ProvisionalRecorderMessages.Button_NEW_PROJECT);
        newProjectBtn.setLayoutData((Object)new GridData(768));
        newProjectBtn.setEnabled(true);
        final Button newFolderBtn = new Button(btnGroup, 8);
        newFolderBtn.setText(ProvisionalRecorderMessages.Button_NEW_FOLDER);
        newFolderBtn.setLayoutData((Object)new GridData(768));
        newFolderBtn.setEnabled(false);
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IContainer container = CTestsuiteLocationWizardPage.this.getSelectedContainer();
                newFolderBtn.setEnabled(container != null);
            }
        });
        newProjectBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProject newProject = CTestsuiteLocationWizardPage.this.createNewProject();
                if (newProject != null) {
                    CTestsuiteLocationWizardPage.this.getViewer().refresh();
                    CTestsuiteLocationWizardPage.this.getViewer().setSelection((ISelection)new StructuredSelection((Object)newProject), true);
                    CTestsuiteLocationWizardPage.this.getViewer().getTree().setFocus();
                }
            }
        });
        newFolderBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IContainer container = CTestsuiteLocationWizardPage.this.getSelectedContainer();
                if (container == null) {
                    return;
                }
                NewFolderWizard wizard = new NewFolderWizard();
                wizard.init(UiPlugin.getDefault().getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)container));
                WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                wizardDialog.create();
                if (wizardDialog.open() != 0) {
                    return;
                }
                if (wizard.getNewResource() != null) {
                    CTestsuiteLocationWizardPage.this.getViewer().refresh();
                    CTestsuiteLocationWizardPage.this.getViewer().setSelection((ISelection)new StructuredSelection((Object)wizard.getNewResource()), true);
                    CTestsuiteLocationWizardPage.this.getViewer().getTree().setFocus();
                }
            }
        });
    }

    protected abstract IProject createNewProject();

    protected TreeViewer getViewer() {
        return this.tree;
    }

    protected IContainer getSelectedContainer() {
        if (this.tree == null) {
            return null;
        }
        ISelection selection = this.tree.getSelection();
        if (selection == null || selection.isEmpty() || !(selection instanceof StructuredSelection)) {
            return null;
        }
        Object obj = ((StructuredSelection)selection).getFirstElement();
        if (obj instanceof IContainer) {
            return (IContainer)obj;
        }
        return null;
    }

    protected class NewFolderWizard
    extends BasicNewFolderResourceWizard {
        private IResource newFolder = null;

        protected NewFolderWizard() {
        }

        protected void selectAndReveal(IResource newResource) {
            this.newFolder = newResource;
            super.selectAndReveal(newResource);
        }

        public IResource getNewResource() {
            return this.newFolder;
        }
    }
}

