/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.test.provisional.recorder.ui.wizards;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.utilities.RecorderFileUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderPage;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderWizard;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IRecorderPageProvider;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.TestsuiteLocationWizardPage;

public class DefaultRecWizardProvider
implements IRecorderPageProvider {
    protected Recorder recorder = null;
    protected HashMap dataMap = new HashMap();
    private IGenericRecorderPage[] pages = null;
    private IGenericRecorderWizard wizard = null;

    public IGenericRecorderPage[] getWizardPages(IGenericRecorderWizard wizard) {
        this.pages = new IGenericRecorderPage[1];
        this.pages[0] = new TestsuiteLocationWizardPage(wizard);
        this.wizard = wizard;
        return this.pages;
    }

    public String getValue(String key) {
        if (this.dataMap.get(key) == null) {
            return null;
        }
        return this.dataMap.get(key).toString();
    }

    public Object getObjectValue(String key) {
        return this.dataMap.get(key);
    }

    public boolean doFinish() {
        boolean b;
        this.dataMap.put("keyWizardPath", this.wizard.getRecorderData("keyWizardPath"));
        this.dataMap.put("keyTestgenPath", this.wizard.getRecorderData("keyTestgenPath"));
        String recPath = this.dataMap.get("keyWizardPath").toString();
        IFile recFile = UiPlugin.getWorkspace().getRoot().getFile((IPath)new Path(recPath));
        boolean bRecExists = RecorderFileUtil.fileExists((IFile)recFile);
        String tgPath = this.dataMap.get("keyTestgenPath").toString();
        IFile tgFile = UiPlugin.getWorkspace().getRoot().getFile((IPath)new Path(tgPath));
        boolean bTestExists = RecorderFileUtil.fileExists((IFile)tgFile);
        if (bRecExists && bTestExists) {
            b = MessageDialog.openConfirm((Shell)UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UiPluginResourceBundle.DefaultRecWizardProvider_FILES_EXIST_TITLE, (String)UiPluginResourceBundle.DefaultRecWizardProvider_BOTH_EXIST);
            if (!b) {
                return false;
            }
            RecorderFileUtil.deleteRecordingFile((IFile)recFile);
            RecorderFileUtil.deleteFile((IFile)tgFile);
        } else if (bRecExists) {
            b = MessageDialog.openConfirm((Shell)UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UiPluginResourceBundle.DefaultRecWizardProvider_FILES_EXIST_TITLE, (String)UiPluginResourceBundle.DefaultRecWizardProvider_REC_EXISTS);
            if (!b) {
                return false;
            }
            RecorderFileUtil.deleteRecordingFile((IFile)recFile);
        } else if (bTestExists) {
            b = MessageDialog.openConfirm((Shell)UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UiPluginResourceBundle.DefaultRecWizardProvider_FILES_EXIST_TITLE, (String)UiPluginResourceBundle.DefaultRecWizardProvider_TESTSUITE_EXISTS);
            if (!b) {
                return false;
            }
            RecorderFileUtil.deleteFile((IFile)tgFile);
        }
        String parms = this.wizard.getRecorderData("keyConfigParams");
        String appID = this.wizard.getRecorderData("keyAppAdapter");
        String tgID = this.wizard.getRecorderData("keyTestgenID");
        this.dataMap.put("keyConfigParams", parms == null ? "" : parms);
        this.dataMap.put("keyAppAdapter", appID == null ? "-1" : appID);
        this.dataMap.put("keyTestgenID", tgID == null ? "-1" : tgID);
        return true;
    }

    public boolean doCancel() {
        return true;
    }

    public Recorder getRecorder() {
        return this.recorder;
    }

    public String getRecorderID() {
        return this.recorder.getId();
    }

    public void setRecorder(String id) {
        this.recorder = RecorderFactory.getInstance().getRecorderWithID(id);
    }

    public void setRecorder(Recorder recorder) {
        this.recorder = recorder;
    }

    public IGenericRecorderWizard getWizard() {
        return this.wizard;
    }
}

