/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.internal.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.IUnresolvedResourceHelper;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDLabelProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.TraceNavigatorActionGroup;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.trace.ui.internal.navigator.DistributedLayout;
import org.eclipse.hyades.trace.ui.internal.navigator.ProfileDetailItem;
import org.eclipse.hyades.trace.ui.internal.navigator.SimpleLayout;
import org.eclipse.hyades.trace.ui.internal.preferences.TraceBasePreferencePage;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.internal.util.UnresolvedResourceHelper;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tptp.trace.ui.internal.control.provider.ControlUtility;
import org.eclipse.tptp.trace.ui.internal.control.provider.TraceControlItemManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PDProjectExplorer
extends Navigator
implements IProfileEventListener,
IPropertyListener {
    public static final String ID = "org.eclipse.hyades.trace.ui.profileNavigator";
    private final String TRACE_SECTION = "TraceNavigator";
    protected TraceNavigatorActionGroup actionGroup;
    private TraceControlItemManager traceControlItemManager = new TraceControlItemManager((INavigator)this);

    public PDProjectExplorer() {
        super(ID);
        IUnresolvedResourceHelper ue = HierarchyResourceSetImpl.getInstance().getUnresolvedException();
        if (ue != null && ue instanceof UnresolvedResourceHelper) {
            ((UnresolvedResourceHelper)ue).setPDProjectExplorer(this);
        }
    }

    public void createPartControl(Composite parent) {
        TraceAssociationManager.getTraceViewMappingRegistry().addCommitChangeListener((IPropertyListener)this);
        super.createPartControl(parent);
        this.initListeners();
        UIPlugin.getDefault().addSelectionProvider((ISelectionProvider)this.getViewer(), (IWorkbenchPart)this);
        UIPlugin.getDefault().addProfileEventListener(this);
        new RefreshUI().start();
    }

    protected void updateActionBars(IStructuredSelection selection) {
        TraceNavigatorActionGroup group = (TraceNavigatorActionGroup)this.getActionGroup(false);
        if (group != null) {
            group.setContext(new ActionContext((ISelection)selection));
            group.updateActionBars();
        }
    }

    public void updateActionBars() {
        TraceNavigatorActionGroup group = (TraceNavigatorActionGroup)this.getActionGroup(false);
        if (group != null) {
            group.updateActionBars();
        }
    }

    public void dispose() {
        TraceAssociationManager.getTraceViewMappingRegistry().removeCommitChangeListener((IPropertyListener)this);
        if (this.getActionGroup(true) != null) {
            this.getActionGroup(true).dispose();
            this.actionGroup = null;
        }
        UIPlugin.getDefault().removeProfileEventListener(this);
        if (this.getViewer() != null) {
            UIPlugin.getDefault().removeSelectionProvider((ISelectionProvider)this.getViewer(), (IWorkbenchPart)this);
        }
        try {
            PDCoreUtil.detachAgents();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        HyadesUtil.cleanupResources((String)"org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
        PDContentProvider.resetMonitors();
        super.dispose();
    }

    public Control getControl() {
        return this.getViewer().getControl();
    }

    public void refresh() {
        this.getViewer().refresh();
    }

    protected void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PDProjectExplorer.this.fillContextMenu(manager);
            }
        });
        Tree profilingMonitorViewTree = ((PDProjectViewer)this.getViewer()).getTree();
        Menu menu = menuMgr.createContextMenu((Control)profilingMonitorViewTree);
        profilingMonitorViewTree.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.getViewer());
    }

    protected void initListeners() {
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PDProjectExplorer.this.handleDoubleClick(event);
            }
        });
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        this.getActionGroup(false).setContext(new ActionContext((ISelection)selection));
        this.getActionGroup(false).fillContextMenu(menu);
    }

    public static PDProjectExplorer getFromActivePerspective() {
        if (UIPlugin.getActivePage() == null) {
            return null;
        }
        IViewPart view = UIPlugin.getActivePage().findView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
        if (view instanceof PDProjectExplorer) {
            return (PDProjectExplorer)view;
        }
        return null;
    }

    protected String getToolTipText() {
        return TraceMessages.PDPROEXPTOOLTIP;
    }

    protected NavigatorActionGroup getActionGroup() {
        return this.actionGroup;
    }

    protected NavigatorActionGroup getActionGroup(boolean dispose) {
        if (!dispose && this.actionGroup == null) {
            this.createActions();
        }
        return this.getActionGroup();
    }

    protected void setActionGroup(TraceNavigatorActionGroup actionGroup) {
        this.actionGroup = actionGroup;
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        ((TraceNavigatorActionGroup)this.getActionGroup(false)).handleDoubleClick(event);
    }

    public void refreshView(Object selection) {
        this.getViewer().refresh();
        ((PDProjectViewer)this.getViewer()).selectObject(selection);
    }

    public void selectObject(Object item) {
        ((PDProjectViewer)this.getViewer()).selectObject(item);
    }

    public void setFocus() {
        if (this.getViewer() != null) {
            ((PDProjectViewer)this.getViewer()).getTree().setFocus();
        }
    }

    public void handleProfileEvent(ProfileEvent event) {
        boolean updateToolbar = false;
        int eventType = event.getType();
        switch (eventType) {
            case 1: {
                ((PDProjectViewer)this.getViewer()).selectObject(event.getSource());
                updateToolbar = true;
                break;
            }
            case 4: {
                ((PDProjectViewer)this.getViewer()).selectObject(event.getSource());
                updateToolbar = true;
                break;
            }
            case 4096: {
                break;
            }
            case 4608: {
                break;
            }
            case 80: {
                TraceBasePreferencePage page = new TraceBasePreferencePage();
                page.setTitle(UIPlugin.getResourceString("PREF_TRACE"));
                PreferenceManager mgr = new PreferenceManager();
                PreferenceNode node = new PreferenceNode("1", (IPreferencePage)page);
                mgr.addToRoot((IPreferenceNode)node);
                PreferenceDialog dialog = new PreferenceDialog(Display.getDefault().getActiveShell(), mgr);
                dialog.create();
                dialog.setMessage(page.getTitle());
                dialog.open();
                break;
            }
            default: {
                ((PDProjectViewer)this.getViewer()).refresh(event.getSource());
            }
        }
        boolean bl = updateToolbar = updateToolbar || eventType == 8 || eventType == 2 || eventType == 16;
        if (updateToolbar) {
            UIPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ControlUtility.addContributedItems((IContributionManager)PDProjectExplorer.this.getViewSite().getActionBars().getToolBarManager(), PDProjectExplorer.this.traceControlItemManager.getToolbarItems());
                }
            });
        }
    }

    public void propertyChanged(Object source, int propId) {
        ((TraceNavigatorActionGroup)this.getActionGroup(false)).propertyChanged(source, propId);
    }

    public void setLinkingEnabled(boolean enabled) {
        super.setLinkingEnabled(enabled);
        if (enabled && this.getViewer() != null) {
            this.getViewer().setSelection(this.getViewer().getSelection());
        }
    }

    public AbstractUIPlugin getPlugin() {
        return UIPlugin.getDefault();
    }

    public String getStoreSection() {
        return "TraceNavigator";
    }

    protected void createActions() {
        this.setActionGroup(new TraceNavigatorActionGroup((INavigator)this, this.traceControlItemManager));
    }

    protected Object createViewerInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected StructuredViewer createViewer(Composite parent) {
        Object newLayout = null;
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        int layoutNumber = store.getInt("profiling_monitor_layout");
        newLayout = layoutNumber == 0 ? new SimpleLayout((Navigator)this) : new DistributedLayout((Navigator)this);
        PDProjectViewer viewer = new PDProjectViewer(parent);
        viewer.setLabelProvider((IBaseLabelProvider)newLayout.getLabelProvider());
        viewer.setContentProvider(newLayout.getContentProvider());
        this.layout = newLayout;
        return viewer;
    }

    protected boolean editorActivated(IEditorPart editor) {
        return false;
    }

    protected void linkToEditor(IStructuredSelection selection) {
    }

    public boolean isShowingFolders() {
        return false;
    }

    public Shell getShell() {
        return this.getViewSite().getShell();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        int beforeUpdateCount = toolbarManager.getItems().length;
        ControlUtility.addContributedItems((IContributionManager)toolbarManager, this.traceControlItemManager.getToolbarItems());
        if (beforeUpdateCount != toolbarManager.getItems().length) {
            IContributionItem[] items = toolbarManager.getItems();
            toolbarManager.removeAll();
            toolbarManager.update(true);
            int i = 0;
            while (i < items.length) {
                toolbarManager.add(items[i]);
                ++i;
            }
            toolbarManager.update(true);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        if (part == this) {
            this.getViewer().setSelection((ISelection)((Navigator)part).getStructuredSelection());
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        super.partBroughtToTop(part);
        if (part == this) {
            this.getViewer().setSelection((ISelection)((Navigator)part).getStructuredSelection());
        }
    }

    public ITreeContentProvider getViewContentProvider() {
        return new PDContentProvider((Navigator)this);
    }

    public ILabelProvider getViewLabelProvider() {
        return new PDLabelProvider();
    }

    public void selectReveal(ISelection selection) {
        IStructuredSelection structuredSelection = this.convertToViewer(selection);
        if (structuredSelection.isEmpty()) {
            return;
        }
        if (this.getViewer() == null || this.getViewer().getControl() == null || this.getViewer().getControl().isDisposed()) {
            return;
        }
        ArrayList list = new ArrayList(((IStructuredSelection)selection).toList());
        int idx = 0;
        while (idx < list.size()) {
            if (list.get(idx) instanceof IFile) {
                return;
            }
            ++idx;
        }
        if (!UIUtil.areEquals((ISelection)this.getStructuredSelection(), (ISelection)structuredSelection)) {
            this.getViewer().setSelection((ISelection)structuredSelection, true);
        }
    }

    class RefreshUI
    extends Thread {
        public RefreshUI() {
            super("Profile_Refresh");
        }

        public void run() {
            while (PDProjectExplorer.this.getViewer() != null) {
                try {
                    IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
                    int refreshType = store.getInt("refresh_type");
                    Display display = Display.getDefault();
                    if (refreshType == 1 && display != null && !display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            public void run() {
                                TreeItem item = null;
                                if (PDProjectExplorer.this.getViewer() != null) {
                                    item = ((PDProjectViewer)PDProjectExplorer.this.getViewer()).getTreeSelection();
                                }
                                if (item != null) {
                                    EObject data = null;
                                    if (item.getData() instanceof ProfileDetailItem && ((ProfileDetailItem)item.getData()).getData() instanceof EObject) {
                                        data = (EObject)((ProfileDetailItem)item.getData()).getData();
                                    } else if (item.getData() instanceof EObject) {
                                        data = (EObject)item.getData();
                                    }
                                    if (RefreshUI.this.isModified(data)) {
                                        ProfileEvent event = UIPlugin.getDefault().getRefreshViewEvent(data);
                                        UIPlugin.getDefault().notifyProfileEventListener(event);
                                    }
                                }
                            }
                        });
                    }
                    RefreshUI.sleep(store.getInt("refresh_int") * 1000);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private boolean isModified(Object selObject) {
            if (selObject != null) {
                if (selObject instanceof TRCAgentProxy) {
                    return this.isAgentModified((TRCAgentProxy)selObject);
                }
                if (selObject instanceof TRCProcessProxy) {
                    Object[] agents = ((TRCProcessProxy)selObject).getAgentProxies().toArray();
                    int idx = 0;
                    while (idx < agents.length) {
                        boolean isModified = this.isAgentModified((TRCAgentProxy)agents[idx]);
                        if (isModified) {
                            return true;
                        }
                        ++idx;
                    }
                    return false;
                }
                if (selObject instanceof TRCNode) {
                    Object[] processes = ((TRCNode)selObject).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            boolean isModified = this.isAgentModified((TRCAgentProxy)agents[i]);
                            if (isModified) {
                                return true;
                            }
                            ++i;
                        }
                        ++idx;
                    }
                    return false;
                }
                if (selObject instanceof TRCMonitor) {
                    Object[] nodes = ((TRCMonitor)selObject).getNodes().toArray();
                    int k = 0;
                    while (k < nodes.length) {
                        Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                        int idx = 0;
                        while (idx < processes.length) {
                            Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                            int i = 0;
                            while (i < agents.length) {
                                boolean isModified = this.isAgentModified((TRCAgentProxy)agents[i]);
                                if (isModified) {
                                    return true;
                                }
                                ++i;
                            }
                            ++idx;
                        }
                        ++k;
                    }
                    return false;
                }
            }
            return false;
        }

        private boolean isAgentModified(TRCAgentProxy agent) {
            if (agent == null || !agent.eIsSet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent()) || ((InternalEObject)agent.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false)).eIsProxy()) {
                return false;
            }
            return agent.isCollectionData();
        }
    }
}

