/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui;

import java.io.File;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;

public class ProfileUIManager {
    private static ProfileUIManager _instance;

    private ProfileUIManager() {
    }

    public static synchronized ProfileUIManager getInstance() {
        if (_instance == null) {
            _instance = new ProfileUIManager();
        }
        return _instance;
    }

    public void startMonitoring(TRCAgentProxy agent) {
        TRCProcessProxy process = agent.getProcessProxy();
        String host = process.getNode().getName();
        try {
            Agent a;
            Node node = PDCoreUtil.profileConnect((String)host, (String)String.valueOf(process.getNode().getPort()));
            if (node == null) {
                return;
            }
            Object instance = LoadersUtils.locateAgentInstance((TRCAgentProxy)agent);
            if (instance != null && instance instanceof Agent && (a = (Agent)instance).isActive()) {
                File testFile;
                String processorProfileFileName;
                if (agent.isToProfileFile()) {
                    a.setProfileFile(agent.getProfileFile());
                } else {
                    a.setProfileFile(null);
                }
                PDCoreUtil.setAgentConfiguration((TRCAgentProxy)agent, (Agent)a);
                a.publishConfiguration();
                CustomCommand applyFilterCommand = new CustomCommand();
                CustomCommand resumeCommand = new CustomCommand();
                applyFilterCommand.setData("APPLYFILTERS");
                a.invokeCustomCommand(applyFilterCommand);
                XMLTraceDataProcessor processor = (XMLTraceDataProcessor)LoadersUtils.locateDataProcessor((TRCAgentProxy)agent);
                if (processor == null) {
                    processor = new XMLTraceDataProcessor(agent);
                    LoadersUtils.registerDataProcessor((TRCAgentProxy)agent, (XMLLoader)processor);
                }
                File processorProfilingFile = (processorProfileFileName = processor.getProfileFileName()) == null ? null : new File(processorProfileFileName);
                boolean newFile = true;
                if (agent.isToProfileFile() && (testFile = new File(agent.getProfileFile())).exists()) {
                    newFile = false;
                }
                if (processorProfilingFile == null && agent.isToProfileFile()) {
                    processor.setProfileFileName(agent.getProfileFile());
                    processor.createWriter();
                    newFile = processor.isNewProfileFile();
                    if (newFile) {
                        processor.writeXMLVersion(processor.getWriter());
                        processor.startTrace(processor.getWriter());
                    }
                } else if (!(processorProfileFileName == null || processorProfileFileName.equals(agent.getProfileFile()) && processorProfilingFile.exists())) {
                    if (processorProfilingFile.exists()) {
                        processor.endTrace(processor.getWriter());
                    }
                    processor.setProfileFileName(agent.getProfileFile());
                    processor.createWriter();
                    newFile = processor.isNewProfileFile();
                    if (newFile) {
                        processor.writeXMLVersion(processor.getWriter());
                        processor.startTrace(processor.getWriter());
                    }
                }
                a.startMonitoring((DataProcessor)processor);
                agent.setCollectionData(true);
                resumeCommand.setData("RESUME");
                a.invokeCustomCommand(resumeCommand);
                agent.setMonitored(true);
                agent.setActive(true);
                agent.setAttached(true);
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource((Object)agent);
                event.setType(1);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
        }
        catch (Throwable e) {
            CommonPlugin.logError((Throwable)e);
        }
    }

    public void stopMonitoring(TRCAgentProxy agent) {
        TRCProcessProxy process = agent.getProcessProxy();
        String host = process.getNode().getName();
        try {
            Agent a;
            Node node = PDCoreUtil.profileConnect((String)host, (String)String.valueOf(process.getNode().getPort()));
            if (node == null) {
                return;
            }
            Object instance = LoadersUtils.locateAgentInstance((TRCAgentProxy)agent);
            if (instance != null && instance instanceof Agent && (a = (Agent)instance).isMonitored()) {
                a.stopMonitoring();
                agent.setMonitored(false);
                agent.setAttached(true);
                agent.setActive(true);
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource((Object)agent);
                event.setType(2);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
        }
        catch (Throwable e) {
            CommonPlugin.logError((Throwable)e);
        }
    }
}

