/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui;

import com.ibm.icu.util.StringTokenizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.internal.ui.TraceUIManager;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UIPlugin
extends AbstractUIPlugin
implements Application {
    protected static UIPlugin inst;
    protected ResourceBundle fResourceBundle;
    public static final String PLUGIN_ID = "org.eclipse.hyades.trace.ui";
    private IConfigurationElement newSymptomWizardElement = null;
    private boolean newSymptomWizardElementInit;

    public UIPlugin() {
        if (inst == null) {
            inst = this;
        }
    }

    public void addSelectionListener(ISelectionListener l) {
        TraceUIManager.getTraceUIManager().addSelectionListener(l);
    }

    public void removeSelectionListener(ISelectionListener l) {
        TraceUIManager.getTraceUIManager().removeSelectionListener(l);
    }

    public void addSelectionProvider(ISelectionProvider provider, IWorkbenchPart part) {
        TraceUIManager.getTraceUIManager().addSelectionProvider(provider, part);
    }

    public void deregisterLaunchProcess(IProcess process) {
        TraceUIManager.deregisterLaunchProcess(process);
    }

    public void deleteLaunch(IProcess process) {
        TraceUIManager.deleteLaunch(process);
    }

    public void registerLaunchProcess(IProcess process) {
        TraceUIManager.registerLaunchProcess(process);
    }

    public static IWorkbenchPage getActivePage() {
        if (UIPlugin.getActiveWorkbenchWindow() == null) {
            return null;
        }
        IWorkbenchPage page = UIPlugin.getActiveWorkbenchWindow().getActivePage();
        if (page == null || !page.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) {
            IWorkbenchWindow dwindow = UIPlugin.getActiveWorkbenchWindow();
            page = null;
            try {
                IWorkbenchPage[] persps = dwindow.getPages();
                int idx = 0;
                while (idx < persps.length) {
                    if (persps[idx].getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) {
                        page = persps[idx];
                        dwindow.setActivePage(page);
                        break;
                    }
                    ++idx;
                }
                if (page == null) {
                    IWorkspaceRoot element = UIPlugin.getPluginWorkbench().getRoot();
                    IWorkbench workBench = dwindow.getWorkbench();
                    if (workBench != null && element != null) {
                        page = workBench.showPerspective("org.eclipse.hyades.trace.internal.ui.tracePerspective", UIPlugin.getActiveWorkbenchWindow(), (IAdaptable)element);
                    }
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return page;
    }

    public static Shell getActiveWorkbenchShell() {
        return UIPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static UIPlugin getDefault() {
        return inst;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return PDPluginImages.getImageDescriptor(name);
    }

    public HierarchyFactory getPerftraceFactory() {
        return TraceUIManager.getTraceUIManager().getPerftraceFactory();
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static IWorkspace getPluginWorkbench() {
        return ResourcesPlugin.getWorkspace();
    }

    public ResourceBundle getResourceBundle() {
        if (this.fResourceBundle == null) {
            try {
                this.fResourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
            }
            catch (Exception exception) {
                this.fResourceBundle = null;
            }
        }
        return this.fResourceBundle;
    }

    public ResourceSet getResourceSet() {
        return TraceUIManager.getTraceUIManager().getResourceSet();
    }

    public static String getResourceString(String key) {
        try {
            ResourceBundle bundle = UIPlugin.getDefault().getResourceBundle();
            return bundle.getString(key);
        }
        catch (Exception exception) {
            return key;
        }
    }

    public PDProjectExplorer getViewer() {
        return PDProjectExplorer.getFromActivePerspective();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("use_host", "localhost[10002]");
        store.setDefault("prj_name", UIPlugin.getResourceString(TraceMessages.TRC_LOCD));
        store.setDefault("lprj_name", "LogAnalyzerProject");
        store.setDefault("lmon_name", "DefaultMonitor");
        store.setDefault("mon_name", UIPlugin.getResourceString(TraceMessages.MON_LOCD));
        store.setDefault("log_option", true);
        store.setDefault("prof_option", true);
        store.setDefault("profile_tips", true);
        store.setDefault("reload_no_question", true);
        store.setDefault("new_snapshot_tips", true);
        store.setDefault("prof_exec_stat", true);
        store.setDefault("prof_heap_stat", true);
        store.setDefault("prof_heap_inst", false);
        store.setDefault("prof_auto_monitor", true);
        store.setDefault("refresh_type", 1);
        store.setDefault("refresh_int", 10);
        store.setDefault("profiling_monitor_layout", 0);
        store.setDefault("logn_layout", 0);
        String def = UIPlugin.getResourceString(TraceMessages.DEF_SETNM);
        store.setDefault("filter_name", def);
        String filters = TraceConstants.DEFAULT_FILTER_SET;
        store.setDefault("set_filters", filters);
        store.setDefault("prof_heap_size", true);
        store.setDefault("prof_execution", false);
        store.setDefault("prof_execution_boundary", false);
        store.setDefault("limitInvoc", false);
        store.setDefault("limitTime", false);
        store.setDefault("invoc_nb", "10000");
        store.setDefault("timeSec", "5");
        store.setDefault("collect_depth", "1");
        store.setDefault("auto_filter_criteria", true);
        store.setDefault("debug", this.getDebugOption());
        store.setDefault("hyde_logtype", false);
        store.setDefault("trace_import_filter_context", ContextManager.getDefautContext());
    }

    private boolean getDebugOption() {
        boolean debugOption = false;
        String value = System.getProperty("hyades.trace.ui.debug");
        if (value != null) {
            debugOption = value.equalsIgnoreCase("true");
        }
        return debugOption;
    }

    public void removeSelectionProvider(ISelectionProvider provider, IWorkbenchPart part) {
        TraceUIManager.getTraceUIManager().removeSelectionProvider(provider, part);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        TraceUIManager.getTraceUIManager().selectionChanged(event);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        TraceUIManager.getTraceUIManager().selectionChanged(part, sel);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.savePluginPreferences();
        PDPluginImages.shutdown();
        TraceUIManager.getTraceUIManager().dispose();
        this.fResourceBundle = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    TraceUIImages.INSTANCE.initialize(new URL(UIPlugin.this.getBundle().getEntry("/"), "icons/full/"), UIPlugin.this.getImageRegistry());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        if (Display.getDefault() == Display.getCurrent()) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
        this.updateHostPreference();
    }

    protected void updateHostPreference() {
        IPreferenceStore store = this.getPreferenceStore();
        String hostList = store.getString("use_host");
        if (hostList.equals("localhost[10002]") || store.getBoolean("HOSTPREF_UPDATED")) {
            store.setValue("HOSTPREF_UPDATED", true);
            return;
        }
        StringBuffer buff = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(hostList, ",");
        while (tokens.hasMoreElements()) {
            String hostPort = (String)tokens.nextElement();
            int idx = hostPort.lastIndexOf(":");
            if (idx > 0) {
                buff.append(hostPort.substring(0, idx)).append("[").append(hostPort.subSequence(idx + 1, hostPort.length())).append("]");
            } else {
                buff.append(hostPort);
            }
            buff.append(",");
        }
        String newPrefValue = buff.toString();
        store.setValue("use_host", newPrefValue.substring(0, newPrefValue.length() - 1));
        store.setValue("HOSTPREF_UPDATED", true);
    }

    public void addProfileEventListener(IProfileEventListener listener) {
        TraceUIManager.getTraceUIManager().addProfileEventListener(listener);
    }

    public void removeProfileEventListener(IProfileEventListener listener) {
        TraceUIManager.getTraceUIManager().removeProfileEventListener(listener);
    }

    public void addDeleteListener(IDeleteListener listener) {
        TraceUIManager.getTraceUIManager().addDeleteListener(listener);
    }

    public void addViewSelectionChangedListener(IViewSelectionChangedListener listener) {
        TraceUIManager.getTraceUIManager().addViewSelectionChangedListener(listener);
    }

    public void addSelectionModel(EObject mofObject, ITraceSelection model) {
        TraceUIManager.getTraceUIManager().addSelectionModel(mofObject, model);
    }

    public ArrayList getDeleteListeners() {
        return TraceUIManager.getTraceUIManager().getDeleteListeners();
    }

    public ViewSelectionChangedEvent getViewSelectionChangedEvent() {
        return TraceUIManager.getTraceUIManager().getViewSelectionChangedEvent();
    }

    public ProfileEvent getProfileEvent() {
        return TraceUIManager.getTraceUIManager().getProfileEvent();
    }

    public ProfileEvent getRefreshViewEvent(Object source) {
        return TraceUIManager.getTraceUIManager().getRefreshViewEvent(source);
    }

    public ProfileEvent getRefreshOptionEvent(Object source) {
        return TraceUIManager.getTraceUIManager().getRefreshOptionEvent(source);
    }

    public ProfileEvent getContextHandlerSelectionChangedEvent(Object source) {
        return TraceUIManager.getTraceUIManager().getContextHandlerSelectionChangedEvent(source);
    }

    public ITraceSelection getSelectionModel(EObject mofObject) {
        return TraceUIManager.getTraceUIManager().getSelectionModel(mofObject);
    }

    public ProfileEvent getUpdateModelEvent(Object source) {
        return TraceUIManager.getTraceUIManager().getUpdateModelEvent(source);
    }

    public void notifyViewSelectionChangedListener(ViewSelectionChangedEvent event) {
        TraceUIManager.getTraceUIManager().notifyViewSelectionChangedListener(event);
    }

    public void notifyProfileEventListener(ProfileEvent event) {
        TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
    }

    public void removeDeleteListener(IDeleteListener listener) {
        TraceUIManager.getTraceUIManager().removeDeleteListener(listener);
    }

    public void removeViewSelectionChangedListener(IViewSelectionChangedListener listener) {
        TraceUIManager.getTraceUIManager().removeViewSelectionChangedListener(listener);
    }

    public void removeSelectionModel(EObject mofObject) {
        TraceUIManager.getTraceUIManager().removeSelectionModel(mofObject);
    }

    public String getName() {
        return UIPlugin.getPluginId();
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(Throwable e) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, e.getLocalizedMessage() == null ? e.getClass().getName() : e.getLocalizedMessage(), e));
    }

    public INewWizard getNewSymDBWizard() {
        try {
            if (!this.newSymptomWizardElementInit) {
                this.newSymptomWizardElementInit = true;
                this.loadWizardExtention();
            }
            if (this.newSymptomWizardElement != null) {
                return (INewWizard)this.newSymptomWizardElement.createExecutableExtension("class");
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void loadWizardExtention() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] configurationElements = registry.getConfigurationElementsFor("org.eclipse.ui.newWizards");
        if (configurationElements != null) {
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configurationElement = configurationElements[i];
                if (configurationElement.getName().equals("wizard") && configurationElement.getAttribute("id").endsWith("wizard.new.symptomdb")) {
                    this.newSymptomWizardElement = configurationElement;
                }
                ++i;
            }
        }
    }

    public static String removeAccelerators(String label) {
        String title = label;
        if (title != null) {
            int index = title.indexOf(38);
            if (index == 0) {
                title = title.substring(1);
            } else if (index > 0) {
                if (title.charAt(index - 1) == '(' && title.length() >= index + 3 && title.charAt(index + 2) == ')') {
                    String first = title.substring(0, index - 1);
                    String last = title.substring(index + 3);
                    title = String.valueOf(first) + last;
                } else if (index < title.length() - 1) {
                    String first = title.substring(0, index);
                    String last = title.substring(index + 1);
                    title = String.valueOf(first) + last;
                }
            }
        }
        return title;
    }
}

