/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TraceFilterManager {
    private static final String OPEN_FILTERS_TAG = "<filters>";
    private static final String CLOSE_FILTERS_TAG = "</filters>";
    private static final String OPEN_FILTER_TAG = "<filter";
    private static final String CLOSE_FILTER_TAG = "</filter>";
    private static final String FILTER_ID_ATTRIBUTE = "id";
    private static final String FILTER_KEY_ATTRIBUTE = "key";
    private static final String FILTER_NAME_ATTRIBUTE = "name";
    private static final String FILTER_IS_AUTOPOP_ATTRIBUTE = "autopopulated";
    private static final String OPEN_CONTENTS_TAG = "<contents>";
    private static final String CLOSE_CONTENTS_TAG = "</contents>";
    private static final String OPEN_CONTENT_TAG = "<content";
    private static final String CLOSE_CONTENT_TAG = "/>";
    private static final String CONTENT_TEXT_ATTRIBUTE = "text";
    private static final String CONTENT_METHOD_ATTRIBUTE = "method";
    private static final String CONTENT_VISIBILITY_ATTRIBUTE = "visibility";
    private Hashtable filterSets = new Hashtable();
    private static TraceFilterManager instance;

    private TraceFilterManager() {
        this.initialize();
    }

    private void initialize() {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        Element fitlerElements = XMLUtil.loadDom((String)store.getString("set_filters"), (String)"filters");
        ArrayList list = TraceFilterManager.parseFiltersSet(fitlerElements);
        this.storeFilterListInCache(list);
    }

    public static TraceFilterManager getInstance() {
        if (instance == null) {
            instance = new TraceFilterManager();
        }
        return instance;
    }

    private void storeFilterListInCache(ArrayList filterList) {
        this.filterSets.clear();
        int idx = 0;
        int listSize = filterList.size();
        while (idx < listSize) {
            FilterSetElement filterElement = (FilterSetElement)filterList.get(idx);
            this.filterSets.put(filterElement.getId(), filterElement);
            ++idx;
        }
    }

    public void storeFilterSetList(ArrayList items) {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        store.setValue("set_filters", OPEN_FILTERS_TAG + TraceFilterManager.serializeFiltersToXML(items) + CLOSE_FILTERS_TAG);
        this.storeFilterListInCache(items);
        UIPlugin.getDefault().savePluginPreferences();
    }

    protected static String serializeFiltersToXML(ArrayList list) {
        StringBuffer temp = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            temp.append(OPEN_FILTER_TAG);
            FilterSetElement elem = (FilterSetElement)list.get(i);
            temp.append(" id = '" + elem.getId() + "'");
            if (elem.getKey() != null) {
                temp.append(" key = '" + elem.getKey() + "'");
            }
            if (elem.getName() != null) {
                temp.append(" name = '" + elem.getName() + "'");
            }
            if (elem.isFilterAutoPopulated()) {
                temp.append(" autopopulated = 'true'");
            }
            temp.append(">");
            ArrayList children = elem.getChildren();
            temp.append(OPEN_CONTENTS_TAG);
            int j = 0;
            while (j < children.size()) {
                temp.append(OPEN_CONTENT_TAG);
                FilterTableElement childElem = (FilterTableElement)children.get(j);
                temp.append(" text = '" + childElem.getText() + "'");
                temp.append(" method = '" + childElem.getMethod() + "'");
                temp.append(" visibility = '" + childElem.getVisibility() + "'");
                temp.append(CLOSE_CONTENT_TAG);
                ++j;
            }
            temp.append(CLOSE_CONTENTS_TAG);
            temp.append(CLOSE_FILTER_TAG);
            ++i;
        }
        return temp.toString();
    }

    public String serializeFiltersToXML() {
        return TraceFilterManager.serializeFiltersToXML(new ArrayList(this.filterSets.values()));
    }

    protected static ArrayList parseFiltersSet(Element filters) {
        ArrayList<FilterSetElement> list = new ArrayList<FilterSetElement>();
        if (filters == null) {
            return list;
        }
        NodeList nodeList = filters.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element elem = (Element)nodeList.item(i);
            FilterSetElement fse = new FilterSetElement(elem.getAttribute(FILTER_ID_ATTRIBUTE));
            fse.setName(elem.getAttribute(FILTER_NAME_ATTRIBUTE));
            fse.setKey(elem.getAttribute(FILTER_KEY_ATTRIBUTE));
            String autoPopVal = elem.getAttribute(FILTER_IS_AUTOPOP_ATTRIBUTE);
            if (autoPopVal != null && autoPopVal.trim().equalsIgnoreCase("true")) {
                fse.setFilterAutoPopulated(true);
            }
            ArrayList children = TraceFilterManager.getFilter(elem);
            fse.setChildren(children);
            list.add(fse);
            ++i;
        }
        return list;
    }

    private static ArrayList getFilter(Element elem) {
        ArrayList<FilterTableElement> list = new ArrayList<FilterTableElement>();
        Element contents = (Element)elem.getFirstChild();
        NodeList contentList = contents.getChildNodes();
        int i = 0;
        while (i < contentList.getLength()) {
            Element temp = (Element)contentList.item(i);
            FilterTableElement fte = temp.getAttribute(CONTENT_VISIBILITY_ATTRIBUTE).equals("0") || temp.getAttribute(CONTENT_VISIBILITY_ATTRIBUTE).equals(TraceMessages.EXCLUDE) ? new FilterTableElement(temp.getAttribute(CONTENT_TEXT_ATTRIBUTE), temp.getAttribute(CONTENT_METHOD_ATTRIBUTE), TraceMessages.EXCLUDE) : new FilterTableElement(temp.getAttribute(CONTENT_TEXT_ATTRIBUTE), temp.getAttribute(CONTENT_METHOD_ATTRIBUTE), TraceMessages.INCLUDE);
            list.add(fte);
            ++i;
        }
        return list;
    }

    public Map getFilterSet() {
        return (Map)this.filterSets.clone();
    }

    public ArrayList getFilterSetCopy() {
        ArrayList<FilterSetElement> filterList = new ArrayList<FilterSetElement>();
        Iterator iter = this.filterSets.values().iterator();
        while (iter.hasNext()) {
            FilterSetElement fse = this.clone((FilterSetElement)iter.next());
            filterList.add(fse);
        }
        return filterList;
    }

    public FilterSetElement getFilterSetElement(String id) {
        return this.clone((FilterSetElement)this.filterSets.get(id));
    }

    private FilterSetElement clone(FilterSetElement element) {
        if (element == null) {
            return null;
        }
        FilterSetElement fse = new FilterSetElement(element.getId());
        ArrayList filterTableElements = element.getChildren();
        ArrayList<FilterTableElement> filterElementsCopy = new ArrayList<FilterTableElement>();
        int i = 0;
        int filterChildrenCount = filterTableElements.size();
        while (i < filterChildrenCount) {
            FilterTableElement currentElement = (FilterTableElement)filterTableElements.get(i);
            filterElementsCopy.add(new FilterTableElement(currentElement.getText(), currentElement.getMethod(), currentElement.getVisibility()));
            ++i;
        }
        fse.setChildren(filterElementsCopy);
        fse.setKey(element.getKey());
        fse.setName(element.getName());
        fse.setFilterAutoPopulated(element.isFilterAutoPopulated());
        return fse;
    }
}

