/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.ui.PlatformUI;

public class TraceProfileCollectionsUI
extends AbstractChangeable
implements SelectionListener,
ModifyListener {
    private Label _limitInvocLabel;
    private Label _limitTimeLabel;
    private Text _limitTime;
    private Text _limitInvocations;
    private Button _limitTimeBtn;
    private Button _limitInvocBtn;
    private Composite _monitoringGroup;
    private Button _autoMonitoring;
    private Label _monitoringDesp;
    private WizardPage _wizardPage;
    private PreferencePage _preferencePage;
    private boolean isAttach = false;

    public TraceProfileCollectionsUI(boolean attach) {
        this.isAttach = attach;
    }

    public TraceProfileCollectionsUI() {
    }

    public Composite createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        GridData data = GridUtil.createFill();
        data.heightHint = 300;
        data.widthHint = 400;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)data);
        this.addLimitTraceGroup(result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._limitInvocLabel, String.valueOf(UIPlugin.getPluginId()) + ".tlmt0001");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._limitInvocations, String.valueOf(UIPlugin.getPluginId()) + ".tlmt0001");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._limitInvocBtn, String.valueOf(UIPlugin.getPluginId()) + ".tlmt0001");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._limitTimeLabel, String.valueOf(UIPlugin.getPluginId()) + ".tlmt0002");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._limitTime, String.valueOf(UIPlugin.getPluginId()) + ".tlmt0002");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._limitTimeBtn, String.valueOf(UIPlugin.getPluginId()) + ".tlmt0002");
        if (!this.isAttach) {
            this.addMonitorOption(result);
            this._monitoringGroup.setVisible(true);
        }
        return result;
    }

    private void addLimitTraceGroup(Composite parent) {
        Group grp = new Group(parent, 0);
        GridData data = GridUtil.createHorizontalFill();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        grp.setLayout((Layout)layout);
        grp.setLayoutData((Object)data);
        grp.setText(UIPlugin.getResourceString(TraceMessages.LIMIT_DTMT));
        this._limitInvocBtn = new Button((Composite)grp, 32);
        this._limitInvocBtn.setText(UIPlugin.getResourceString(TraceMessages.INV_LO));
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this._limitInvocBtn.setLayoutData((Object)data);
        this._limitInvocLabel = new Label((Composite)grp, 0);
        this._limitInvocLabel.setText(UIPlugin.getResourceString(TraceMessages.INV_LNB));
        data = new GridData();
        data.horizontalIndent = 20;
        this._limitInvocLabel.setLayoutData((Object)data);
        this._limitInvocations = new Text((Composite)grp, 2048);
        this._limitInvocations.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._limitTimeBtn = new Button((Composite)grp, 32);
        this._limitTimeBtn.setText(UIPlugin.getResourceString(TraceMessages.TML_OPT));
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this._limitTimeBtn.setLayoutData((Object)data);
        this._limitTimeLabel = new Label((Composite)grp, 0);
        this._limitTimeLabel.setText(UIPlugin.getResourceString(TraceMessages.TML_NB));
        data = new GridData();
        data.horizontalIndent = 20;
        this._limitTimeLabel.setLayoutData((Object)data);
        this._limitTime = new Text((Composite)grp, 2048);
        this._limitTime.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._limitInvocBtn.addSelectionListener((SelectionListener)this);
        this._limitTimeBtn.addSelectionListener((SelectionListener)this);
        this._limitInvocations.addModifyListener((ModifyListener)this);
        this._limitTime.addModifyListener((ModifyListener)this);
    }

    private void addMonitorOption(Composite parent) {
        this._monitoringGroup = new Composite(parent, 0);
        GridData data = GridUtil.createHorizontalFill();
        this._monitoringGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this._monitoringGroup.setLayout((Layout)layout);
        this._autoMonitoring = new Button(this._monitoringGroup, 32);
        this._autoMonitoring.setText(UIPlugin.getResourceString(TraceMessages.AMONC));
        this._autoMonitoring.addSelectionListener((SelectionListener)this);
        this._monitoringDesp = new Label(this._monitoringGroup, 0);
        this._monitoringDesp.setText(UIPlugin.getResourceString(TraceMessages.AMONL));
        data = new GridData();
        data.horizontalIndent = 20;
        this._monitoringDesp.setLayoutData((Object)data);
        this._monitoringDesp.setVisible(false);
    }

    public void enable(boolean enable) {
        this._limitInvocations.setEnabled(enable);
        this._limitInvocBtn.setEnabled(enable);
        this._limitInvocLabel.setEnabled(enable);
        this._limitTime.setEnabled(enable);
        this._limitTimeBtn.setEnabled(enable);
        this._limitTimeLabel.setEnabled(enable);
        if (!this.isAttach) {
            this._autoMonitoring.setEnabled(enable);
        }
    }

    public void enableButtons() {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        this.setLimitInvocations(store.getBoolean("limitInvoc"));
        this.setLimitTime(store.getBoolean("limitTime"));
        this.setLimitInvocNb(store.getString("invoc_nb"));
        this.setLimitTimeNb(store.getString("timeSec"));
        if (!this.isAttach) {
            this.setAutoMonitoring(store.getBoolean("prof_auto_monitor"));
        }
    }

    public Vector getOptions() {
        return this.getGeneralOptions(AgentConfigurationEntry.class);
    }

    public Vector getProfilingOptions() {
        return this.getGeneralOptions(ProfilingAttribute.class);
    }

    private Vector getGeneralOptions(Class optionType) {
        Vector<Object> options = new Vector<Object>();
        if (this.getLimitInvocations()) {
            if (this.getLimitTime()) {
                options.addElement(this.createOption(optionType, "SETOPTION", "BURST_MODE", "secondsAndInvocations"));
                options.addElement(this.createOption(optionType, "SETOPTION", "BURST_SECONDS", String.valueOf(this.getLimitTimeNb())));
            } else {
                options.addElement(this.createOption(optionType, "SETOPTION", "BURST_MODE", "secondsAndInvocations"));
            }
            options.addElement(this.createOption(optionType, "SETOPTION", "BURST_INVOCATIONS", String.valueOf(this.getLimitInvocNb())));
        } else if (this.getLimitTime()) {
            options.addElement(this.createOption(optionType, "SETOPTION", "BURST_MODE", "seconds"));
            options.addElement(this.createOption(optionType, "SETOPTION", "BURST_SECONDS", String.valueOf(this.getLimitTimeNb())));
        }
        return options;
    }

    private Object createOption(Class optionType, String type, String name, String value) {
        if (optionType == AgentConfigurationEntry.class) {
            AgentConfigurationEntry ace = new AgentConfigurationEntry();
            ace.setType(type);
            ace.setName(name);
            ace.setValue(value);
            return ace;
        }
        if (optionType == ProfilingAttribute.class) {
            ProfilingAttribute pa = new ProfilingAttribute(String.valueOf(type) + "_" + name, value);
            return pa;
        }
        return null;
    }

    public void modifyText(ModifyEvent event) {
        if (event.getSource() == this._limitInvocations || event.getSource() == this._limitTime) {
            this.checkNumbersAndPrintErrorMsg();
        }
    }

    private boolean checkValidTextInput() {
        boolean status = true;
        status = status && this.isValuePositiveInteger(this._limitInvocBtn.getSelection(), this._limitInvocations.getText().trim());
        status = status && this.isValuePositiveInteger(this._limitTimeBtn.getSelection(), this._limitTime.getText().trim());
        return status;
    }

    private boolean isValuePositiveInteger(boolean condition, String value) {
        if (condition) {
            return LauncherUtility.isInputPositiveInteger(value);
        }
        return true;
    }

    public boolean getLimitInvocations() {
        return this._limitInvocBtn.getSelection();
    }

    public int getLimitInvocNb() {
        String text = this._limitInvocations.getText().trim();
        try {
            int value = Integer.parseInt(text);
            if (value > 0) {
                return value;
            }
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("invoc_nb");
        }
        catch (Exception exception) {
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("invoc_nb");
        }
    }

    public boolean getLimitTime() {
        return this._limitTimeBtn.getSelection();
    }

    public int getLimitTimeNb() {
        String text = this._limitTime.getText().trim();
        try {
            int value = Integer.parseInt(text);
            if (value > 0) {
                return value;
            }
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("timeSec");
        }
        catch (Exception exception) {
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("timeSec");
        }
    }

    public void setLimitInvocations(boolean setValue) {
        this._limitInvocBtn.setSelection(setValue);
        if (!this._limitInvocBtn.isEnabled()) {
            return;
        }
        this._limitInvocations.setEnabled(setValue);
        this._limitInvocLabel.setEnabled(setValue);
    }

    public void setLimitInvocNb(String value) {
        this._limitInvocations.setText(value);
    }

    public void setLimitTime(boolean setValue) {
        this._limitTimeBtn.setSelection(setValue);
        if (!this._limitTimeBtn.isEnabled()) {
            return;
        }
        this._limitTime.setEnabled(setValue);
        this._limitTimeLabel.setEnabled(setValue);
    }

    public void setLimitTimeNb(String value) {
        this._limitTime.setText(value);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._limitInvocBtn) {
            this._limitInvocations.setEnabled(this._limitInvocBtn.getSelection());
            this._limitInvocLabel.setEnabled(this._limitInvocBtn.getSelection());
        } else if (event.widget == this._limitTimeBtn) {
            this._limitTime.setEnabled(this._limitTimeBtn.getSelection());
            this._limitTimeLabel.setEnabled(this._limitTimeBtn.getSelection());
        }
        this.changed();
    }

    public void checkNumbersAndPrintErrorMsg() {
        if (this._wizardPage != null) {
            if (!this.checkValidTextInput()) {
                this._wizardPage.setErrorMessage(UIPlugin.getResourceString(TraceMessages.INV_CVAL));
                this._wizardPage.setPageComplete(false);
            } else {
                this._wizardPage.setErrorMessage(null);
                this._wizardPage.setPageComplete(true);
            }
        } else if (this._preferencePage != null) {
            if (!this.checkValidTextInput()) {
                this._preferencePage.setErrorMessage(UIPlugin.getResourceString(TraceMessages.INV_CVAL));
                this._preferencePage.setValid(false);
            } else {
                this._preferencePage.setErrorMessage(null);
                this._preferencePage.setValid(true);
            }
        }
        this.changed();
    }

    public void setWizardPage(WizardPage page) {
        this._wizardPage = page;
    }

    public void setPreferencePage(PreferencePage page) {
        this._preferencePage = page;
    }

    public void enableMonitoringSlectionGroup(boolean visible) {
        if (!this.isAttach) {
            this._monitoringGroup.setVisible(visible);
        }
    }

    public void enableMonitoringDesp(boolean visible) {
        if (!this.isAttach) {
            this._monitoringDesp.setVisible(visible);
        }
    }

    public boolean getAutoMonitoring() {
        if (!this.isAttach) {
            return this._autoMonitoring.getSelection();
        }
        return false;
    }

    public void setAutoMonitoring(boolean select) {
        if (!this.isAttach) {
            this._autoMonitoring.setSelection(select);
        }
    }

    public void storeValues() {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        store.setValue("prof_auto_monitor", this.getAutoMonitoring());
    }

    public void setDefaultOptions() {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        this.setLimitInvocations(store.getBoolean("limitInvoc"));
        this.setLimitInvocNb(String.valueOf(store.getInt("invoc_nb")));
        this.setLimitTime(store.getBoolean("limitTime"));
        this.setLimitTimeNb(String.valueOf(store.getInt("timeSec")));
        this.setAutoMonitoring(store.getBoolean("prof_auto_monitor"));
    }

    public String validate() {
        if (!this.isValuePositiveInteger(this._limitInvocBtn.getSelection(), this._limitInvocations.getText().trim())) {
            return TraceMessages.ERROR_LAUNCH_CONF_LIMIT_INVOC;
        }
        if (!this.isValuePositiveInteger(this._limitTimeBtn.getSelection(), this._limitTime.getText().trim())) {
            return TraceMessages.ERROR_LAUNCH_CONF_LIMIT_TIME;
        }
        return null;
    }
}

