/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceFilterManager;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.FilterElementModifier;
import org.eclipse.hyades.trace.ui.internal.util.FilterList;
import org.eclipse.hyades.trace.ui.internal.util.FilterListContentProvider;
import org.eclipse.hyades.trace.ui.internal.util.FilterListLabelProvider;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IBasicPropertyConstants;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class TraceProfileFiltersUI
extends AbstractChangeable
implements SelectionListener,
ICheckStateListener {
    protected Composite _control;
    protected FilterList _filterList;
    protected FilterSetList _filterSetList;
    private Button _upBtn;
    private Button _downBtn;
    private Button _addBtn;
    private Button _editBtn;
    private Button _removeBtn;
    private Table _table;
    protected CheckboxTableViewer _tableViewer;
    private static String[] tableColumnProperties = new String[]{"string", "method", "combo"};
    private Label _filterSetLabel;
    private Table _filterSetTable;
    private CheckboxTableViewer _filterSetTableViewer;
    private Button _addSetBtn;
    private Button _editSetBtn;
    private Button _removeSetBtn;
    private Label _contentLabel;
    private Label _noteLabel;
    private FilterSetElement _oldSelection;
    private FilterSetElement activeFS;
    private boolean agentTerminated = false;
    Composite _tableContainer;

    private void createColumns() {
        TableLayout layout = new TableLayout();
        this._table.setLayout((Layout)layout);
        this._table.setHeaderVisible(true);
        String[] headers = new String[]{UIPlugin.getResourceString(TraceMessages.HEADER_FILTER), UIPlugin.getResourceString(TraceMessages.HEADER_MET), UIPlugin.getResourceString(TraceMessages.HEADER_VIS)};
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnPixelData(120, true), new ColumnPixelData(110, true), new ColumnPixelData(70, true)};
        TableColumn[] columns = new TableColumn[headers.length];
        int i = 0;
        while (i < headers.length) {
            layout.addColumnData(layouts[i]);
            TableColumn tc = new TableColumn(this._table, 0, i);
            tc.setResizable(layouts[i].resizable);
            tc.setText(headers[i]);
            columns[i] = tc;
            ++i;
        }
    }

    public Composite createControl(Composite parent) {
        this._control = this.createParentControl(parent);
        this.createFilterSet(this._control);
        this.createFilterContents(this._control);
        this.createNoteLabel(this._control);
        return this._control;
    }

    protected Composite createParentControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        result.setLayoutData((Object)data);
        return result;
    }

    protected void createNoteLabel(Composite parent) {
        this._noteLabel = new Label(parent, 0);
        this._noteLabel.setText(UIPlugin.getResourceString(TraceMessages.FLT_NOTE));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this._noteLabel.setLayoutData((Object)data);
    }

    protected void createFilterContents(Composite parent) {
        this.createVerticalIndent(parent);
        this._contentLabel = new Label(parent, 0);
        this._contentLabel.setText(UIPlugin.getResourceString(TraceMessages.FLT_CNT));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this._contentLabel.setLayoutData((Object)data);
        Composite tableGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        tableGroup.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.heightHint = 180;
        tableGroup.setLayoutData((Object)data);
        this.initializeTable(tableGroup);
        Composite btnGroup = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite addGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        addGroup.setLayout((Layout)layout);
        addGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        this._addBtn = new Button(addGroup, 8);
        this._addBtn.setText(UIPlugin.getResourceString(TraceMessages.ADD_FT1));
        this._addBtn.setToolTipText(UIPlugin.getResourceString(TraceMessages.ADD_FTT));
        this._addBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn = new Button(addGroup, 8);
        this._editBtn.setText(UIPlugin.getResourceString(TraceMessages.EDTFLT_BTN1));
        this._editBtn.setToolTipText(UIPlugin.getResourceString(TraceMessages.EDTFLT_TT));
        this._editBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._removeBtn = new Button(addGroup, 8);
        this._removeBtn.setText(UIPlugin.getResourceString(TraceMessages.RMV_TXT1));
        this._removeBtn.setToolTipText(UIPlugin.getResourceString(TraceMessages.RMV_TIP));
        this._removeBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        Composite moveGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        moveGroup.setLayout((Layout)layout);
        moveGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._upBtn = new Button(moveGroup, 8);
        this._upBtn.setText(UIPlugin.getResourceString(TraceMessages.MV_UP));
        this._upBtn.setToolTipText(UIPlugin.getResourceString(TraceMessages.MV_UPT));
        this._upBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._downBtn = new Button(moveGroup, 8);
        this._downBtn.setText(UIPlugin.getResourceString(TraceMessages.MV_DN));
        this._downBtn.setToolTipText(UIPlugin.getResourceString(TraceMessages.MV_DNT));
        this._downBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn.setEnabled(false);
        this._removeBtn.setEnabled(false);
        this._upBtn.setEnabled(false);
        this._downBtn.setEnabled(false);
        this._removeBtn.addSelectionListener((SelectionListener)this);
        this._upBtn.addSelectionListener((SelectionListener)this);
        this._downBtn.addSelectionListener((SelectionListener)this);
        this._addBtn.addSelectionListener((SelectionListener)this);
        this._editBtn.addSelectionListener((SelectionListener)this);
        this._table.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._table, String.valueOf(UIPlugin.getPluginId()) + ".pfpp0002");
    }

    protected void createFilterSet(Composite parent) {
        this._filterSetLabel = new Label(parent, 0);
        this._filterSetLabel.setText(UIPlugin.getResourceString(TraceMessages.SEL_FLTST));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this._filterSetLabel.setLayoutData((Object)data);
        Composite tableGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        tableGroup.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.heightHint = 100;
        tableGroup.setLayoutData((Object)data);
        this._filterSetTable = new Table(tableGroup, 68132);
        this._filterSetTable.setLinesVisible(false);
        this._filterSetTable.setLayoutData((Object)GridUtil.createFill());
        this._filterSetTableViewer = new CheckboxTableViewer(this._filterSetTable);
        this._filterSetTableViewer.setContentProvider((IContentProvider)new FilterSetContentProvider(this._filterSetTableViewer));
        this._filterSetTableViewer.setLabelProvider((IBaseLabelProvider)new FilterSetLabelProvider());
        this._filterSetList = new FilterSetList((TableViewer)this._filterSetTableViewer);
        this._filterSetTableViewer.setInput((Object)this._filterSetList);
        this._filterSetTableViewer.addCheckStateListener((ICheckStateListener)this);
        TableLayout layoutt = new TableLayout();
        this._filterSetTable.setLayout((Layout)layoutt);
        ColumnPixelData l = new ColumnPixelData(420, true);
        layoutt.addColumnData((ColumnLayoutData)l);
        TableColumn tc = new TableColumn(this._filterSetTable, 0, 0);
        tc.setResizable(l.resizable);
        Composite btnGroup = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite addGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        addGroup.setLayout((Layout)layout);
        addGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        this._addSetBtn = new Button(addGroup, 8);
        this._addSetBtn.setText(UIPlugin.getResourceString(TraceMessages.ADD_FT));
        this._addSetBtn.setToolTipText(UIPlugin.getResourceString(TraceMessages.ADD_FSTT));
        this._addSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editSetBtn = new Button(addGroup, 8);
        this._editSetBtn.setText(UIPlugin.getResourceString(TraceMessages.EDTST_BTN));
        this._editSetBtn.setToolTipText(UIPlugin.getResourceString(TraceMessages.ED_FSTT));
        this._editSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._removeSetBtn = new Button(addGroup, 8);
        this._removeSetBtn.setText(UIPlugin.getResourceString(TraceMessages.RMV_TXT2));
        this._removeSetBtn.setToolTipText(UIPlugin.getResourceString(TraceMessages.RM_FSTT));
        this._removeSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editSetBtn.setEnabled(false);
        this._removeSetBtn.setEnabled(false);
        this._removeSetBtn.addSelectionListener((SelectionListener)this);
        this._addSetBtn.addSelectionListener((SelectionListener)this);
        this._editSetBtn.addSelectionListener((SelectionListener)this);
        this._filterSetTable.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._filterSetTable, String.valueOf(UIPlugin.getPluginId()) + ".pfps0001");
    }

    private void createTable(Composite parent) {
        this._tableContainer = new Composite(parent, 0);
        this._tableContainer.setLayout((Layout)new GridLayout(1, false));
        this._tableContainer.setLayoutData((Object)GridUtil.createFill());
        GridData gd1 = new GridData();
        gd1.exclude = true;
        this._table = new Table(this._tableContainer, 68354);
        this._table.setLinesVisible(true);
        GridData gd2 = GridUtil.createFill();
        gd2.exclude = false;
        this._table.setLayoutData((Object)gd2);
    }

    public void enable(boolean enable) {
        if (this.activeFS != null && this.activeFS.getId() != null && this.activeFS.isFilterAutoPopulated()) {
            this.showAutoGenFilterMessage(true);
            return;
        }
        this._addSetBtn.setEnabled(enable);
        this._removeSetBtn.setEnabled(enable);
        this._editSetBtn.setEnabled(enable);
        this._filterSetLabel.setEnabled(enable);
        this._filterSetTable.setEnabled(enable);
        this._filterSetTableViewer.getTable().setEnabled(enable);
        this._contentLabel.setEnabled(enable);
        this._addBtn.setEnabled(enable);
        this._removeBtn.setEnabled(enable);
        this._editBtn.setEnabled(enable);
        this._upBtn.setEnabled(enable);
        this._downBtn.setEnabled(enable);
        this._noteLabel.setEnabled(enable);
        this._table.setEnabled(enable);
        if (!enable) {
            this._tableViewer.setCellEditors(null);
            this._tableViewer.setCellModifier(null);
        } else {
            this.setTableCellEditors();
            this.setTableCellModifiler();
        }
    }

    protected void enableButtons() {
        if (this.isAgentTerminated()) {
            this.enable(false);
            return;
        }
        int selection = this._table.getSelectionIndex();
        int selectionCount = this._table.getSelectionCount();
        this._removeBtn.setEnabled(this._filterList.getSize() > 0 && selection != -1);
        this._editBtn.setEnabled(this._filterList.getSize() > 0 && selection != -1);
        this._upBtn.setEnabled(selection > 0 && selectionCount == 1);
        this._downBtn.setEnabled(selection >= 0 && selection < this._table.getItemCount() - 1 && selectionCount == 1);
        selection = this._filterSetTable.getSelectionIndex();
        this._removeSetBtn.setEnabled(this._filterSetList.getSize() > 1 && selection != -1);
        this._editSetBtn.setEnabled(this._filterSetList.getSize() > 0 && selection != -1);
    }

    public ArrayList getFilterSet() {
        if (this._oldSelection != null) {
            this._oldSelection.setChildren((ArrayList)this._filterList.getFilters().clone());
        }
        this.validateFilterSet(this._filterSetList);
        return this._filterSetList.getFilters();
    }

    private static String getFilterSet(ArrayList list) {
        return TraceFilterManager.serializeFiltersToXML(list);
    }

    private void validateFilterSet(FilterSetList filterSet) {
        ArrayList filters = filterSet.getFilters();
        int idx = 0;
        while (idx < filters.size()) {
            FilterSetElement set = (FilterSetElement)filters.get(idx);
            ArrayList elements = set.getChildren();
            boolean addExcludeFilter = true;
            int i = 0;
            while (i < elements.size()) {
                FilterTableElement elem = (FilterTableElement)elements.get(i);
                if (elem.getVisibility().equals(TraceMessages.EXCLUDE)) {
                    addExcludeFilter = false;
                    break;
                }
                if (elem.getText().equals("*")) {
                    addExcludeFilter = false;
                    break;
                }
                ++i;
            }
            if (elements.size() > 0 && addExcludeFilter) {
                elements.add(new FilterTableElement("*", "*", TraceMessages.EXCLUDE));
                set.setChildren(elements);
            }
            ++idx;
        }
    }

    protected void initializeTable(Composite parent) {
        this.createTable(parent);
        this._tableViewer = new CheckboxTableViewer(this._table);
        this.createColumns();
        this._tableViewer.setContentProvider((IContentProvider)new FilterListContentProvider(this._tableViewer));
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new FilterListLabelProvider());
        this._filterList = new FilterList((TableViewer)this._tableViewer);
        this._tableViewer.setInput((Object)this._filterList);
        this.setTableCellEditors();
        this.setTableCellModifiler();
        this._tableViewer.setColumnProperties(tableColumnProperties);
    }

    private static ArrayList getFiltersSet(String filters) {
        Element prefElement = XMLUtil.loadDom((String)filters, (String)"filters");
        return TraceProfileFiltersUI.getFiltersSet(prefElement);
    }

    private static ArrayList getFiltersSet(Element filters) {
        return TraceFilterManager.parseFiltersSet(filters);
    }

    private void setXMLFilterSet(Element filters) {
        ArrayList list = TraceProfileFiltersUI.getFiltersSet(filters);
        int idx = 0;
        while (idx < list.size()) {
            this.addFilterSet((FilterSetElement)list.get(idx));
            ++idx;
        }
        this.selectTableItem(this._filterSetTable, 0);
    }

    public void setFilterSet(String filters) {
        Element prefElement = XMLUtil.loadDom((String)filters, (String)"filters");
        this.setXMLFilterSet(prefElement);
    }

    public void setFilterSet(Element filters) {
        this.setXMLFilterSet(filters);
    }

    public void setFilterSet(ArrayList filters) {
        this._filterSetList.setFilters(filters);
        this._filterSetTableViewer.refresh();
    }

    public void addFilterSet(FilterSetElement elem) {
        this._filterSetList.add(elem);
        this._filterSetTableViewer.refresh();
        this._filterSetTableViewer.setChecked((Object)elem, false);
    }

    public void reset() {
        this.activeFS = null;
        this._oldSelection = null;
        this._table.removeAll();
        this._filterList.removeAll();
        this._filterSetList.removeAll();
        this._filterSetTableViewer.refresh();
    }

    public void resetFields() {
        this.activeFS = null;
        this._oldSelection = null;
    }

    protected void selectTableItem(Table table, int selection) {
        table.setFocus();
        table.setSelection(selection);
        table.showSelection();
        if (table == this._filterSetTable) {
            this.showFiltersForSelection((FilterSetElement)this._filterSetList.getElementAt(selection));
        }
    }

    private void showFiltersForSelection(FilterSetElement elem) {
        if (this._oldSelection != null) {
            this._oldSelection.setChildren((ArrayList)this._filterList.getFilters().clone());
        }
        this._table.setRedraw(false);
        this._filterList.removeAll();
        ArrayList list = elem.getChildren();
        int idx = 0;
        while (idx < list.size()) {
            FilterTableElement filter = (FilterTableElement)list.get(idx);
            filter.setParent(this._filterList);
            this._filterList.add(filter, this._filterList.getSize());
            this._tableViewer.refresh();
            ++idx;
        }
        this._tableViewer.refresh();
        this._oldSelection = elem;
        this._table.setRedraw(true);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._addSetBtn) {
            this.showWSetDialog(UIPlugin.getResourceString(TraceMessages.ADD_SETDG), null);
            this.enableButtons();
            return;
        }
        if (event.widget == this._editSetBtn) {
            IStructuredSelection sel = (IStructuredSelection)this._filterSetTableViewer.getSelection();
            if (!sel.isEmpty()) {
                FilterSetElement element = (FilterSetElement)sel.getFirstElement();
                this.showWSetDialog(UIPlugin.getResourceString(TraceMessages.EDT_SETDG), element);
                return;
            }
        } else {
            if (event.widget == this._removeSetBtn) {
                int selection = this._filterSetTable.getSelectionIndex();
                if (selection != -1) {
                    boolean select = false;
                    if (this._filterSetTable.getItem(selection).getChecked()) {
                        select = true;
                    }
                    this._filterSetList.removeElementAt(selection);
                    if (select) {
                        FilterSetElement elem;
                        this.activeFS = elem = (FilterSetElement)this._filterSetList.getElementAt(0);
                        this._filterSetTableViewer.setChecked((Object)elem, true);
                    }
                    this._filterSetTableViewer.refresh();
                    this.selectTableItem(this._filterSetTable, 0);
                }
                this.enableButtons();
                return;
            }
            if (event.widget == this._addBtn) {
                this.showEditDialog(UIPlugin.getResourceString(TraceMessages.ADD_FLTDLG), null, "*", null);
                this.enableButtons();
            } else if (event.widget == this._editBtn) {
                int idx = this._table.getSelectionIndex();
                if (idx != -1) {
                    FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(idx);
                    String filter = sel.getText();
                    String method = sel.getMethod();
                    String vis = sel.getVisibility();
                    this.showEditDialog(UIPlugin.getResourceString(TraceMessages.EDT_FLTDLG), filter, method, vis);
                }
            } else {
                if (event.widget == this._table) {
                    this.enableButtons();
                    return;
                }
                if (event.widget == this._filterSetTable) {
                    int idx = this._filterSetTable.getSelectionIndex();
                    if (idx != -1) {
                        FilterSetElement elem1 = (FilterSetElement)this._filterSetList.getElementAt(idx);
                        this.showFiltersForSelection(elem1);
                        this._filterSetTableViewer.setChecked((Object)elem1, true);
                        this.activeFS = elem1;
                        int kdx = 0;
                        while (kdx < this._filterSetList.getSize()) {
                            if (kdx != idx) {
                                FilterSetElement elem2 = (FilterSetElement)this._filterSetList.getElementAt(kdx);
                                this._filterSetTableViewer.setChecked((Object)elem2, false);
                            }
                            ++kdx;
                        }
                        this._filterSetTableViewer.refresh();
                        if (elem1.getId() != null && elem1.isFilterAutoPopulated()) {
                            this.showAutoGenFilterMessage(true);
                        } else {
                            this.showAutoGenFilterMessage(false);
                        }
                    } else {
                        this.enableButtons();
                    }
                    return;
                }
                if (event.widget == this._removeBtn) {
                    int selection = this._table.getSelectionIndex();
                    this._filterList.removeElements(this._table.getSelectionIndices());
                    this._tableViewer.refresh();
                    int size = this._filterList.getSize();
                    if (size > 0) {
                        if (selection > 0 && selection < size) {
                            this.selectTableItem(this._table, selection - 1);
                        } else {
                            this.selectTableItem(this._table, 0);
                        }
                    }
                    this.enableButtons();
                } else if (event.widget == this._upBtn) {
                    this._tableViewer.refresh();
                    int selection = this._table.getSelectionIndex();
                    if (selection > 0) {
                        FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(selection);
                        FilterTableElement previous = (FilterTableElement)this._filterList.getElementAt(selection - 1);
                        String filter = sel.getText();
                        String method = sel.getMethod();
                        String vis = sel.getVisibility();
                        sel.setText(previous.getText());
                        sel.setMethod(previous.getMethod());
                        previous.setText(filter);
                        previous.setMethod(method);
                        sel.setVisibility(previous.getVisibility());
                        previous.setVisibility(vis);
                        this.selectTableItem(this._table, selection - 1);
                    }
                    this._tableViewer.refresh();
                    this.enableButtons();
                } else if (event.widget == this._downBtn) {
                    this._tableViewer.refresh();
                    int selection = this._table.getSelectionIndex();
                    if (selection < this._table.getItemCount() - 1) {
                        FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(selection);
                        FilterTableElement next = (FilterTableElement)this._filterList.getElementAt(selection + 1);
                        String filter = sel.getText();
                        String method = sel.getMethod();
                        String vis = sel.getVisibility();
                        sel.setText(next.getText());
                        sel.setMethod(next.getMethod());
                        next.setText(filter);
                        next.setMethod(method);
                        sel.setVisibility(next.getVisibility());
                        next.setVisibility(vis);
                        this.selectTableItem(this._table, selection + 1);
                    }
                    this._tableViewer.refresh();
                    this.enableButtons();
                }
            }
        }
    }

    private void showEditDialog(String title, String clas, String method, String rule) {
        EditDialog dialog = new EditDialog(this._control.getShell(), title, clas, method, rule);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            if (clas == null) {
                FilterTableElement elem = new FilterTableElement(dialog.clas(), dialog.method(), dialog.rule());
                if (dialog.rule().equals(TraceMessages.EXCLUDE)) {
                    this._filterList.add(elem, this._filterList.getSize());
                } else {
                    this._filterList.add(elem, 0);
                }
                elem.setParent(this._filterList);
                this._tableViewer.refresh();
                if (dialog.rule().equals(UIPlugin.getResourceString(TraceMessages.EXCLUDE))) {
                    this.selectTableItem(this._table, this._filterList.getSize() - 1);
                } else {
                    this.selectTableItem(this._table, 0);
                }
            } else {
                int idx = this._table.getSelectionIndex();
                if (idx != -1) {
                    FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(idx);
                    sel.setText(dialog.clas());
                    sel.setMethod(dialog.method());
                    sel.setVisibility(dialog.rule());
                    this._tableViewer.refresh();
                }
            }
        }
    }

    private void showWSetDialog(String title, FilterSetElement element) {
        EditWSetDialog dialog = new EditWSetDialog(this._control.getShell(), title, element == null ? null : element.getDisplayName());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            if (element == null) {
                int idx = 0;
                while (idx < this._filterSetList.getSize()) {
                    FilterSetElement el = (FilterSetElement)this._filterSetList.getElementAt(idx);
                    if (el.getDisplayName().equals(dialog._name)) {
                        this.selectTableItem(this._filterSetTable, idx);
                        return;
                    }
                    ++idx;
                }
                FilterSetElement elem = new FilterSetElement("org.eclipse.hyades.trace.ui." + dialog._name + System.currentTimeMillis());
                elem.setKey(null);
                elem.setName(dialog._name);
                String filters = TraceConstants.DEFAULT_FILTER_SET;
                Element prefElement = XMLUtil.loadDom((String)filters, (String)"filters");
                ArrayList list = TraceProfileFiltersUI.getFiltersSet(prefElement);
                if (list.size() > 0) {
                    FilterSetElement set = (FilterSetElement)list.get(0);
                    elem.setChildren((ArrayList)set.getChildren().clone());
                }
                this.addFilterSet(elem);
                this.setActiveFilterSet(elem);
            } else {
                int idx = this._filterSetTable.getSelectionIndex();
                if (idx != -1) {
                    ((FilterSetElement)this._filterSetList.getElementAt(idx)).setName(dialog._name);
                    this._filterSetTableViewer.refresh((Object)((FilterSetElement)this._filterSetList.getElementAt(idx)));
                    this.setActiveFilterSet((FilterSetElement)this._filterSetList.getElementAt(idx));
                }
            }
        }
    }

    protected void showAutoGenFilterMessage(boolean enabled) {
        if (enabled) {
            ((GridData)this._table.getLayoutData()).exclude = false;
            this._table.setVisible(true);
            this._editBtn.setEnabled(false);
            this._addBtn.setEnabled(false);
            this._removeBtn.setEnabled(false);
            this._table.setEnabled(false);
            this._tableContainer.layout(false);
            this._tableContainer.redraw();
        } else {
            ((GridData)this._table.getLayoutData()).exclude = false;
            this._table.setVisible(true);
            this._table.setEnabled(true);
            this._tableContainer.layout(false);
            this._tableContainer.redraw();
            this.enableButtons();
            this._addBtn.setEnabled(true);
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        FilterSetElement elem = (FilterSetElement)event.getElement();
        int i = 0;
        while (i < this._filterSetList.getSize()) {
            FilterSetElement data = (FilterSetElement)this._filterSetList.getElementAt(i);
            if (data == elem) {
                if (data != null && data.getId() != null) {
                    if (data.isFilterAutoPopulated()) {
                        this.showAutoGenFilterMessage(true);
                    } else {
                        this.showAutoGenFilterMessage(false);
                    }
                } else {
                    this.showAutoGenFilterMessage(false);
                }
                if (this._filterSetTableViewer.getChecked((Object)data)) {
                    this._filterSetTable.setSelection(i);
                }
            }
            ++i;
        }
        this._filterSetTableViewer.refresh();
    }

    public static void storeValues(ArrayList items) {
        TraceFilterManager.getInstance().storeFilterSetList(items);
    }

    public boolean isAgentTerminated() {
        return this.agentTerminated;
    }

    public void setAgentTerminated(boolean agentTerminated) {
        this.agentTerminated = agentTerminated;
        if (agentTerminated) {
            this.enable(false);
        }
    }

    public void removeFilterSet(int idx) {
        if (idx < 0 || idx > this._filterSetList.getSize()) {
            return;
        }
        this._filterSetList.removeElementAt(idx);
    }

    public String getActiveFilterSet() {
        if (this.activeFS == null) {
            return null;
        }
        return this.activeFS.getId();
    }

    public FilterSetElement getActiveFilterSetElement() {
        return this.activeFS;
    }

    public void setActiveFilterSet(FilterSetElement set) {
        this.activeFS = set;
        this._filterSetTableViewer.setCheckedElements(new Object[]{set});
        this._filterSetTableViewer.setSelection((ISelection)new StructuredSelection((Object)set));
        this.showFiltersForSelection(set);
        this._filterSetTableViewer.refresh();
        this.enableButtons();
        if (this.activeFS != null && this.activeFS.getId() != null && this.activeFS.isFilterAutoPopulated()) {
            this.showAutoGenFilterMessage(true);
            return;
        }
    }

    public void addFilterSets(FilterSetElement[] list) {
        int idx = 0;
        while (idx < list.length) {
            this.addFilterSet(list[idx]);
            ++idx;
        }
    }

    protected void createVerticalIndent(Composite parent) {
        Label verticalIntent = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        verticalIntent.setLayoutData((Object)data);
    }

    private void setTableCellModifiler() {
        this._tableViewer.setCellModifier((ICellModifier)new FilterElementModifier(this._tableViewer));
    }

    private void setTableCellEditors() {
        CellEditor[] editors = new CellEditor[this._table.getColumnCount()];
        editors[0] = new TextCellEditor((Composite)this._table);
        editors[1] = new TextCellEditor((Composite)this._table);
        editors[2] = new ComboBoxCellEditor((Composite)this._table, FilterTableElement.getVisibilityStates());
        this._tableViewer.setCellEditors(editors);
    }

    class EditDialog
    extends Dialog
    implements ModifyListener {
        private String _class;
        private String _method;
        private String _rule;
        private Text _classText;
        private Text _methodText;
        private Combo _ruleText;
        private String _title;

        public EditDialog(Shell shell, String title, String clas, String method, String rule) {
            super(shell);
            this._class = "mypackage.*";
            if (clas != null) {
                this._class = clas;
            }
            this._method = method;
            this._rule = rule;
            this._title = title;
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        public void clas(String clas) {
            this._class = clas;
        }

        public String clas() {
            return this._class;
        }

        public void method(String method) {
            this._method = method;
        }

        public String method() {
            return this._method;
        }

        public void rule(String rule) {
            this._rule = rule;
        }

        public String rule() {
            return this._rule;
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.widthHint = 400;
            result.setLayoutData((Object)data);
            Label patternLabel = new Label(result, 64);
            patternLabel.setText(UIPlugin.getResourceString(TraceMessages.FLT_SUPPPTRN));
            data = GridDataUtil.createHorizontalFill();
            data.horizontalSpan = 2;
            data.widthHint = 60;
            data.heightHint = 30;
            patternLabel.setLayoutData((Object)data);
            Label label = new Label(result, 0);
            label.setText(UIPlugin.getResourceString(TraceMessages.HEADER_FILTER));
            this._classText = new Text(result, 2048);
            this._classText.setLayoutData((Object)GridUtil.createHorizontalFill());
            label = new Label(result, 0);
            label.setText(UIPlugin.getResourceString(TraceMessages.HEADER_MET));
            this._methodText = new Text(result, 2048);
            this._methodText.setLayoutData((Object)GridUtil.createHorizontalFill());
            label = new Label(result, 0);
            label.setText(UIPlugin.getResourceString(TraceMessages.HEADER_VIS));
            this._ruleText = new Combo(result, 2056);
            this._ruleText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._ruleText.add(TraceMessages.EXCLUDE);
            this._ruleText.add(TraceMessages.INCLUDE);
            this._classText.addModifyListener((ModifyListener)this);
            this._methodText.addModifyListener((ModifyListener)this);
            this._ruleText.select(1);
            if (this._class != null) {
                this._classText.setText(this._class);
            }
            if (this._method != null) {
                this._methodText.setText(this._method);
            }
            if (this._rule != null) {
                this._ruleText.setText(this._rule);
            }
            this._classText.setFocus();
            this._classText.selectAll();
            return result;
        }

        public void modifyText(ModifyEvent e) {
            if ((e.widget == this._classText || e.widget == this._methodText) && this.getButton(0) != null) {
                this.getButton(0).setEnabled(this._classText.getText().trim() != "" || this._methodText.getText().trim() != "");
            }
        }

        protected void okPressed() {
            this._class = this._classText.getText().trim();
            this._method = this._methodText.getText().trim();
            this._rule = this._ruleText.getText();
            super.okPressed();
        }
    }

    class EditWSetDialog
    extends Dialog
    implements ModifyListener {
        private String _name;
        private Text _nameText;
        private String _title;

        public EditWSetDialog(Shell shell, String title, String name) {
            super(shell);
            this._name = name;
            this._title = title;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.widthHint = 400;
            result.setLayoutData((Object)data);
            Label label = new Label(result, 0);
            label.setText(UIPlugin.getResourceString(TraceMessages.FLTST_NM));
            this._nameText = new Text(result, 2048);
            this._nameText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._nameText.addModifyListener((ModifyListener)this);
            if (this._name != null) {
                this._nameText.setText(this._name);
            }
            return result;
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == this._nameText && this.getButton(0) != null) {
                this.getButton(0).setEnabled(this._nameText.getText().trim().length() > 0);
            }
        }

        protected void okPressed() {
            this._name = this._nameText.getText().trim();
            super.okPressed();
        }

        protected Control createContents(Composite parent) {
            Control result = super.createContents(parent);
            this.getButton(0).setEnabled(this._nameText.getText().trim().length() > 0);
            return result;
        }
    }

    class FilterSetContentProvider
    implements IStructuredContentProvider {
        private CheckboxTableViewer fViewer;
        protected FilterSetElement fChangedElement;

        public FilterSetContentProvider(CheckboxTableViewer tableViewer) {
            this.fViewer = tableViewer;
        }

        public void dispose() {
        }

        public void elementChanged(FilterSetElement changedElement, String changedProperty) {
            this.fChangedElement = changedElement;
            this.fViewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    FilterSetContentProvider.this.fViewer.refresh((Object)FilterSetContentProvider.this.fChangedElement);
                }
            });
        }

        public Object[] getElements(Object parent) {
            return ((FilterSetList)parent).elements();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fViewer = (CheckboxTableViewer)viewer;
            if (oldInput != null && oldInput instanceof FilterList) {
                ((FilterSetList)oldInput).removeElementChangedListener(this);
            }
            if (newInput != null && newInput instanceof FilterList) {
                ((FilterSetList)newInput).addElementChangedListener(this);
            }
        }

        public boolean isDeleted(Object element) {
            return false;
        }
    }

    public class FilterSetLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return PDPluginImages.getImage("filter_obj.gif");
        }

        public Image getColumnImage(Viewer viewer, Object element, int columnIndex) {
            return PDPluginImages.getImage("filter_obj.gif");
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((FilterSetElement)element).getDisplayName();
        }

        public String getColumnText(Viewer viewer, Object element, int columnIndex) {
            return ((FilterSetElement)element).getDisplayName();
        }
    }

    public class FilterSetList
    implements IBasicPropertyConstants {
        ArrayList filters = new ArrayList();
        TableViewer fViewer;
        private ArrayList listeners;

        public FilterSetList(TableViewer viewer) {
            this.fViewer = viewer;
        }

        public void add(FilterSetElement element) {
            this.add(element, -1);
        }

        public void add(FilterSetElement element, int index) {
            if (index < 0) {
                this.filters.add(element);
            } else {
                this.filters.add(index, element);
            }
        }

        public void addElementChangedListener(FilterSetContentProvider newListener) {
            if (newListener == null) {
                return;
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            if (!this.listeners.contains(newListener)) {
                this.listeners.add(newListener);
            }
        }

        public Object[] elements() {
            Collections.sort(this.filters, new Comparator(){

                public int compare(Object a, Object b) {
                    String str1 = ((FilterSetElement)a).getDisplayName();
                    String str2 = ((FilterSetElement)b).getDisplayName();
                    if (str1 == null) {
                        str1 = "";
                    }
                    if (str2 == null) {
                        str2 = "";
                    }
                    return Collator.getInstance().compare(str1, str2);
                }
            });
            return this.filters.toArray();
        }

        public void fireElementChanged(FilterSetElement changedElement, String changedProperty) {
            if (this.listeners != null) {
                for (FilterSetContentProvider l : this.listeners) {
                    l.elementChanged(changedElement, changedProperty);
                }
            }
        }

        public Object getElementAt(int index) {
            return this.filters.get(index);
        }

        public ArrayList getFilters() {
            return (ArrayList)this.filters.clone();
        }

        public int getSize() {
            return this.filters.size();
        }

        public void removeAll() {
            this.filters.clear();
        }

        public Object removeElementAt(int idx) {
            Object element = this.filters.get(idx);
            if (element == null) {
                return null;
            }
            this.filters.remove(element);
            return element;
        }

        public void removeElementChangedListener(FilterSetContentProvider listener) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }

        public void setFilters(ArrayList filters) {
            this.filters = filters;
        }
    }
}

