/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.editors;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class TRCMonitorEditor
extends EditorPart {
    private TRCMonitor fMonitor;

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UIPlugin.getPluginId()) + ".mone0000");
        TraceLocationUI locationUI = new TraceLocationUI();
        locationUI.createControl(parent);
        locationUI.setEnabled(false);
        if (this.fMonitor == null) {
            return;
        }
        Path path = new Path(TString.resourcePath((URI)this.fMonitor.eResource().getURI()));
        locationUI.getLocation().setText(path.uptoSegment(path.segmentCount() - 1).toOSString());
        locationUI.getMonitor().setText(this.fMonitor.getName());
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof IFileEditorInput) {
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
            this.loadMonitorDoc();
            if (this.fMonitor != null) {
                this.setPartName(this.fMonitor.getName());
            } else {
                this.setPartName("Unknown monitor");
            }
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    private TRCMonitor loadMonitorDoc() {
        if (this.fMonitor == null) {
            try {
                String name = ((FileEditorInput)this.getEditorInput()).getFile().getFullPath().toString();
                ResourceSet resourceSet = UIPlugin.getDefault().getResourceSet();
                Resource res = resourceSet.getResource(SaveUtil.createURI((String)("platform:/resource" + name)), true);
                if (res == null) {
                    return this.fMonitor;
                }
                for (Object current : res.getContents()) {
                    if (!(current instanceof TRCMonitor)) continue;
                    this.fMonitor = (TRCMonitor)current;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.fMonitor;
    }

    public void setFocus() {
    }

    public void dispose() {
        String currentPerspective = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId();
        if (currentPerspective.equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) {
            return;
        }
        this.fMonitor.eResource().unload();
    }
}

