/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.editors;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProcessUI;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class TRCProcessEditor
extends EditorPart {
    TRCProcessProxy fProcess;

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UIPlugin.getPluginId()) + ".proe0000");
        TraceProcessUI processUI = new TraceProcessUI();
        processUI.createControl(parent);
        processUI.getLocationUI().setEnabled(false);
        processUI.getLaunchProcessUI().enable(false);
        processUI.getProcessIdUI().setEnabled(false);
        processUI.getNodeNameUI().setEnabled(false);
        if (this.fProcess != null) {
            TRCNode fNode = this.fProcess.getNode();
            TRCMonitor fMonitor = fNode.getMonitor();
            Path path = new Path(TString.resourcePath((URI)fMonitor.eResource().getURI()));
            processUI.getLocationUI().getLocation().setText(path.uptoSegment(path.segmentCount() - 1).toOSString());
            processUI.getLocationUI().getMonitor().setText(fMonitor.getName());
            String name = this.fProcess.getName();
            processUI.getLaunchProcessUI().getClassUI().setText(name);
            processUI.getProcessIdUI().setText(String.valueOf(this.fProcess.getPid()));
            processUI.getNodeNameUI().setText(fNode.getName());
            if (this.fProcess.getClasspath() != null) {
                processUI.getLaunchProcessUI().getClassPathUI().setText(this.fProcess.getClasspath());
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof IFileEditorInput) {
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
            this.loadProcessDoc();
            if (this.fProcess != null) {
                this.setPartName(String.valueOf(this.fProcess.getName()) + "[" + this.fProcess.getPid() + "]");
            }
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    private TRCProcessProxy loadProcessDoc() {
        if (this.fProcess == null) {
            try {
                String name = ((FileEditorInput)this.getEditorInput()).getFile().getFullPath().toString();
                ResourceSet resourceSet = UIPlugin.getDefault().getResourceSet();
                Resource res = resourceSet.getResource(SaveUtil.createURI((String)("platform:/resource" + name)), true);
                if (res == null) {
                    return this.fProcess;
                }
                for (Object current : res.getContents()) {
                    if (!(current instanceof TRCProcessProxy)) continue;
                    this.fProcess = (TRCProcessProxy)current;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.fProcess;
    }

    public void setFocus() {
    }

    public void dispose() {
        if (PDCoreUtil.isProfilingPerspective()) {
            return;
        }
        this.fProcess.eResource().unload();
    }
}

