/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.ui.internal.launcher.AttachDelegate;
import org.eclipse.hyades.trace.ui.internal.util.ProcessTreeItem;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ProcessWrapperRunnable
implements IRunnableWithProgress {
    private Object parent;
    private Object[] children = null;
    private ILaunchConfiguration _conf;
    private ArrayList fAgentTypeList;

    public ProcessWrapperRunnable(Object p_parent, ILaunchConfiguration c) {
        this.parent = p_parent;
        this._conf = c;
        this.fAgentTypeList = null;
    }

    private ArrayList getAgentTypeList() {
        if (this.fAgentTypeList == null) {
            this.fAgentTypeList = new ArrayList();
            this.fAgentTypeList.add("Logging");
        }
        return this.fAgentTypeList;
    }

    private boolean isDisplay(Object obj) {
        if (obj instanceof Process) {
            Enumeration agents = ((Process)obj).listAgents();
            while (agents.hasMoreElements()) {
                if (!this.isDisplay(agents.nextElement())) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Agent) {
            Agent agent = (Agent)obj;
            if (agent.isActive()) {
                if (agent.getType().equals("Logging") && !agent.isAttached(true)) {
                    return true;
                }
                if (agent.getType().equals("Profiler") && !agent.isAttached(true)) {
                    return true;
                }
                ArrayList agentList = this.getAgentTypeList();
                int i = 0;
                while (i < agentList.size()) {
                    if (!agent.getType().equals("Logging") && agent.getType().equals((String)agentList.get(i))) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        return true;
    }

    public void run(IProgressMonitor pm) {
        if (this.parent instanceof ProcessTreeItem) {
            ProcessTreeItem pti = (ProcessTreeItem)this.parent;
            if (pti.getData() == null) {
                Object[] childrenObjs;
                ArrayList childrenList = new ArrayList();
                childrenList.addAll(AttachDelegate.retrieveProcesses(this._conf, false).values());
                if (childrenList == null) {
                    // empty if block
                }
                if ((childrenObjs = childrenList.toArray()).length == 0) {
                    this.children = null;
                } else {
                    Vector<ProcessTreeItem> childrenV = new Vector<ProcessTreeItem>();
                    int i = 0;
                    while (i < childrenObjs.length) {
                        if (this.isDisplay(childrenObjs[i])) {
                            ProcessTreeItem processTreeItem = new ProcessTreeItem(childrenObjs[i], null);
                            Process process = (Process)childrenObjs[i];
                            Enumeration agents = process.listAgents();
                            Vector<ProcessTreeItem> agentsV = new Vector<ProcessTreeItem>();
                            while (agents.hasMoreElements()) {
                                Object agent = agents.nextElement();
                                if (!this.isDisplay(agent)) continue;
                                agentsV.addElement(new ProcessTreeItem(agent, processTreeItem));
                            }
                            ProcessTreeItem[] agentsTreeItems = new ProcessTreeItem[agentsV.size()];
                            agentsV.toArray(agentsTreeItems);
                            processTreeItem.setChildren(agentsTreeItems);
                            childrenV.addElement(processTreeItem);
                        }
                        ++i;
                    }
                    this.children = childrenV.toArray();
                }
            } else {
                this.children = pti.getData() instanceof Process ? pti.getChildren() : null;
            }
        }
    }

    public Object[] getChildren() {
        if (this.children != null) {
            return this.children;
        }
        return new Object[0];
    }
}

