/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileLaunchUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.launcher.TraceArguments;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

public class ProfileJavaApplicationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 4);
            monitor.subTask(TraceMessages.LNCH_MSGV);
            boolean success = ProfileLaunchUtil.performProfilingTypesLaunch(conf);
            monitor.worked(1);
            if (!success) {
                monitor.setCanceled(true);
                return;
            }
            ProfilingSetsManager manager = ProfilingSetsManager.instance();
            IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();
            TraceArguments args = new TraceArguments(this.getMainTypeName(conf));
            args.setClassPath(this.getClasspathString(conf));
            args.setParameters(this.getProgramArguments(conf));
            args.setVMArguments(this.getVMArguments(conf));
            args.setEnvironmentVariable(ProfileLaunchUtil.getEnvironmentVariables(conf));
            args.setAutoMonitoring(manager.getAutoMonitoring(conf));
            File workingDir = this.getWorkingDirectory(conf);
            if (workingDir != null) {
                args.setLocation(workingDir.getAbsolutePath());
            } else {
                args.setLocation(System.getProperty("user.dir"));
            }
            monitor.worked(1);
            String hostName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt("localhost_port"));
            String projectName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString("prj_name"));
            String monitorName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString("mon_name"));
            args.setHostName(hostName);
            args.setPortNumber(port);
            if (conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false)) {
                args.setProfileFile(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, null));
            } else {
                args.setProfileFile(null);
            }
            ArrayList filters = manager.getFilters(conf);
            Vector options = manager.getOptions(conf);
            monitor.worked(1);
            if (!PDCoreUtil.launchTrace(args, filters, options, projectName, monitorName, launch)) {
                monitor.setCanceled(true);
            }
            monitor.worked(1);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            throw e;
        }
    }

    private String getClasspathString(ILaunchConfiguration conf) throws CoreException {
        String classPath = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, null);
        if (classPath == null) {
            StringBuffer buf = new StringBuffer();
            String[] entries = this.getClasspath(conf);
            int i = 0;
            while (i < entries.length - 1) {
                buf.append(entries[i]);
                buf.append(File.pathSeparatorChar);
                ++i;
            }
            buf.append(entries[entries.length - 1]);
            return buf.toString();
        }
        return classPath;
    }
}

