/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher.defaults;

import java.util.Vector;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.IStatusListener;
import org.eclipse.ui.PlatformUI;

public class ExecutionTimeUI
implements SelectionListener {
    private Composite _detailsHeapGroup;
    private Button _showHeapInstance;
    private Button _collectCPUtime;
    private Button _boundary;
    private Label _traceDepthLabel;
    private Text _traceDepth;
    private Composite _detailsExecGroup;
    private Button _showExecStatistic;
    private Button _showExecFlow;
    private Label titleLabel;
    private Label optionsLabel;
    private Composite _heapOptionGrp;
    private Button _advancedOptions;
    private boolean displayTitle;
    private Vector listeners;
    private ModificationNotifier modificationNotifier;
    private Button _autoFrequency;
    private Button _manualFrequency;
    private Spinner _pollingFreq;

    public ExecutionTimeUI() {
        this(true);
    }

    public ExecutionTimeUI(boolean displayTitle) {
        this.displayTitle = displayTitle;
        this.modificationNotifier = new ModificationNotifier();
    }

    public Composite createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        GridData data = GridUtil.createFill();
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)data);
        if (this.displayTitle) {
            FontData[] fonts;
            this.titleLabel = new Label(result, 0);
            this.titleLabel.setText(UIPlugin.getResourceString("executionGroup"));
            this.titleLabel.setLayoutData((Object)GridUtil.createHorizontalFill());
            Font font = this.titleLabel.getFont();
            if (font != null && (fonts = font.getFontData()) != null && fonts.length >= 1) {
                this.titleLabel.setFont(new Font((Device)Display.getDefault(), fonts[0].getName(), fonts[0].getHeight() + 3, 1));
            }
            new Label(result, 0);
        }
        if (this.displayTitle) {
            this.optionsLabel = new Label(result, 64);
            this.optionsLabel.setText(TraceMessages.AN_EXTM);
            data = new GridData();
            data.horizontalIndent = 20;
            data.widthHint = 375;
            this.optionsLabel.setLayoutData((Object)data);
            Composite grp = new Composite(result, 0);
            data = GridUtil.createHorizontalFill();
            layout = new GridLayout();
            layout.numColumns = 1;
            grp.setLayout((Layout)layout);
            grp.setLayoutData((Object)data);
            this.addExecutionOption(grp);
            this.addHeapOption(grp);
            this._detailsExecGroup.setVisible(true);
        } else {
            this.addExecutionOption(result);
            this.addHeapOption(result);
        }
        this._detailsHeapGroup.setVisible(true);
        this._traceDepth.setEnabled(this._boundary.getSelection());
        return result;
    }

    public void enableButtons() {
        this._traceDepth.setEnabled(this._boundary.getSelection());
        this.enableHeapInstance(this._showExecFlow.getSelection());
    }

    private void addHeapOption(Composite parent) {
        this._detailsHeapGroup = new Composite(parent, 0);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalIndent = 20;
        data.widthHint = 350;
        this._detailsHeapGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this._detailsHeapGroup.setLayout((Layout)layout);
        this._advancedOptions = new Button(this._detailsHeapGroup, 8);
        this._advancedOptions.setText(TraceMessages.ADV_BTN);
        this._advancedOptions.addSelectionListener((SelectionListener)this);
        this._heapOptionGrp = new Composite(this._detailsHeapGroup, 0);
        this._heapOptionGrp.setLayout((Layout)new GridLayout());
        this._showHeapInstance = new Button(this._heapOptionGrp, 32);
        this._showHeapInstance.setText(TraceMessages.SH_INSTLI);
        this._showHeapInstance.addListener(13, (Listener)this.modificationNotifier);
        Label info = new Label(this._heapOptionGrp, 64);
        data = new GridData();
        data.widthHint = 375;
        info.setLayoutData((Object)data);
        info.setForeground(Display.getCurrent().getSystemColor(3));
        info.setText(TraceMessages.INSTL_INFO);
        this._heapOptionGrp.setVisible(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._showHeapInstance, String.valueOf(UIPlugin.getPluginId()) + ".topp0011");
    }

    private void addExecutionOption(Composite parent) {
        Group levelOfDetail;
        GridData data;
        GridLayout layout = new GridLayout(2, false);
        if (this.displayTitle) {
            this._detailsExecGroup = new Composite(parent, 0);
            data = GridUtil.createHorizontalFill();
            if (this.displayTitle) {
                data.horizontalIndent = 20;
            }
            this._detailsExecGroup.setLayoutData((Object)data);
            this._detailsExecGroup.setLayout((Layout)layout);
            levelOfDetail = new Group(this._detailsExecGroup, 0);
        } else {
            levelOfDetail = new Group(parent, 0);
        }
        levelOfDetail.setLayout((Layout)layout);
        levelOfDetail.setLayoutData((Object)new GridData(4, -1, true, false));
        levelOfDetail.setText(LauncherMessages.CONFIGURATION_EXEC_GROUP_LEVEL);
        this._collectCPUtime = new Button((Composite)levelOfDetail, 32);
        this._collectCPUtime.setText(TraceMessages.COL_CPU);
        this._collectCPUtime.addListener(13, (Listener)this.modificationNotifier);
        this._boundary = new Button((Composite)levelOfDetail, 32);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this._boundary.setLayoutData((Object)data);
        this._boundary.setText(TraceMessages.AUI_BCLS);
        this._boundary.addListener(13, (Listener)this.modificationNotifier);
        this._traceDepthLabel = new Label((Composite)levelOfDetail, 0);
        this._traceDepthLabel.setText(TraceMessages.COL_DPT);
        this._traceDepth = new Text((Composite)levelOfDetail, 2048);
        data = new GridData();
        data.widthHint = 70;
        this._traceDepth.setLayoutData((Object)data);
        this._traceDepth.addListener(24, (Listener)this.modificationNotifier);
        Group _showExecGroup = this.displayTitle ? new Group(this._detailsExecGroup, 0) : new Group(parent, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        if (!this.displayTitle) {
            data.verticalIndent = 20;
        }
        _showExecGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        _showExecGroup.setLayout((Layout)layout);
        _showExecGroup.setText(LauncherMessages.CONFIGURATION_EXEC_GROUP_TYPE);
        this._showExecStatistic = new Button((Composite)_showExecGroup, 16);
        this._showExecStatistic.setText(TraceMessages.EXEC_STAT);
        this._showExecStatistic.addListener(13, (Listener)this.modificationNotifier);
        Composite pollingFreqComp = new Composite((Composite)_showExecGroup, 0);
        GridLayout pollingFreqCompGL = new GridLayout(2, false);
        pollingFreqCompGL.marginLeft = 20;
        pollingFreqComp.setLayout((Layout)pollingFreqCompGL);
        pollingFreqComp.setLayoutData((Object)new GridData(4, -1, true, false));
        this._autoFrequency = new Button(pollingFreqComp, 16);
        GridData autoFrequencyGD = new GridData(4, -1, true, false);
        autoFrequencyGD.horizontalSpan = 2;
        this._autoFrequency.setLayoutData((Object)autoFrequencyGD);
        this._autoFrequency.setText(TraceMessages.EXECUTION_ANALYSIS_AUTO_FREQ);
        this._autoFrequency.addListener(13, (Listener)this.modificationNotifier);
        this._autoFrequency.setSelection(true);
        this._manualFrequency = new Button(pollingFreqComp, 16);
        this._manualFrequency.setLayoutData((Object)new GridData(4, -1, true, false));
        this._manualFrequency.setText(TraceMessages.EXECUTION_ANALYSIS_MANUAL_FREQ);
        this._manualFrequency.addListener(13, (Listener)this.modificationNotifier);
        this._manualFrequency.setSelection(false);
        this._pollingFreq = new Spinner(pollingFreqComp, 2048);
        this._pollingFreq.setLayout((Layout)new GridLayout());
        this._pollingFreq.setLayoutData((Object)new GridData(4, -1, true, false));
        this._pollingFreq.setValues(60, 1, 10000, 0, 10, 100);
        this._pollingFreq.setEnabled(false);
        this._pollingFreq.addListener(13, (Listener)this.modificationNotifier);
        this._manualFrequency.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutionTimeUI.this._pollingFreq.setEnabled(((Button)e.widget).getSelection());
            }
        });
        this._showExecFlow = new Button((Composite)_showExecGroup, 16);
        this._showExecFlow.setText(TraceMessages.DETAILED_DATA);
        this._showExecFlow.addListener(13, (Listener)this.modificationNotifier);
        this._showExecFlow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isShowExecFlowSelected = !((Button)e.widget).getSelection();
                ExecutionTimeUI.this._autoFrequency.setEnabled(isShowExecFlowSelected);
                ExecutionTimeUI.this._manualFrequency.setEnabled(isShowExecFlowSelected);
                ExecutionTimeUI.this._pollingFreq.setEnabled(isShowExecFlowSelected && ExecutionTimeUI.this._manualFrequency.getSelection());
            }
        });
        this._boundary.addSelectionListener((SelectionListener)this);
        this._showExecStatistic.addSelectionListener((SelectionListener)this);
        this._showExecFlow.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._boundary, String.valueOf(UIPlugin.getPluginId()) + ".topp0002");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._traceDepth, String.valueOf(UIPlugin.getPluginId()) + ".topp0008");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)_showExecGroup, String.valueOf(UIPlugin.getPluginId()) + ".topp0009");
    }

    public void enable(boolean enable) {
        this.enableExecutionButtons(true);
    }

    public void enableExecutionButtons(boolean enable) {
        this._boundary.setEnabled(enable);
        this._traceDepth.setEnabled(enable);
        this._traceDepthLabel.setEnabled(enable);
        this._showExecStatistic.setEnabled(enable);
        this._showExecFlow.setEnabled(enable);
    }

    public void enableBtnGroup() {
        this.enableExecutionBtnGroup();
    }

    private void enableExecutionBtnGroup() {
        this._boundary.setEnabled(true);
        this._showExecFlow.setEnabled(true);
        this._showExecStatistic.setEnabled(true);
        this._traceDepth.setEnabled(this._boundary.getSelection());
        this._traceDepthLabel.setEnabled(this._boundary.getSelection());
    }

    public boolean getExecutionStatistic() {
        return this._showExecStatistic.getSelection();
    }

    public boolean getExecutionFlow() {
        return this._showExecFlow.getSelection();
    }

    public boolean getExecutionBoundary() {
        return this._boundary.getSelection();
    }

    public boolean getInstance() {
        return this._showHeapInstance.getSelection();
    }

    public boolean getCPUtime() {
        return this._collectCPUtime.getSelection();
    }

    public void setInstance(boolean selection) {
        this._showHeapInstance.setSelection(selection);
    }

    public void setCPUtime(boolean selection) {
        this._collectCPUtime.setSelection(selection);
    }

    public boolean isPollingFreqModeAutomated() {
        return this._autoFrequency.getSelection();
    }

    public int getPollingFrequency() {
        return this._pollingFreq.getSelection();
    }

    public void setPollingFrequencyMode(boolean isAutomated) {
        this._autoFrequency.setSelection(isAutomated);
        this._manualFrequency.setSelection(!isAutomated);
        this._pollingFreq.setEnabled(this._showExecStatistic.getSelection() && !isAutomated);
    }

    public void setPollingFrequency(int pollingFrequency) {
        this._pollingFreq.setSelection(pollingFrequency);
    }

    public int getCollectionDepth() {
        String text = this._traceDepth.getText().trim();
        try {
            int depth = Integer.parseInt(text);
            if (depth > 0) {
                return depth;
            }
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("collect_depth");
        }
        catch (Exception exception) {
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("collect_depth");
        }
    }

    public void setExecutionStatistic(boolean select) {
        this._showExecStatistic.setSelection(select);
        this._showHeapInstance.setEnabled(!select);
    }

    public void setExecutionFlow(boolean select) {
        this._showExecFlow.setSelection(select);
        Event event = new Event();
        event.widget = this._showExecFlow;
        this._showExecFlow.notifyListeners(13, event);
    }

    public void setExecutionBoundary(boolean setValue) {
        this._boundary.setSelection(setValue);
        this._traceDepth.setEnabled(this._boundary.getSelection());
        this._traceDepthLabel.setEnabled(this._boundary.getSelection());
    }

    public void setCollectionDepth(String value) {
        this._traceDepth.setText(value);
    }

    public void enableHeapInstance(boolean enable) {
        if (!enable) {
            this._showHeapInstance.setSelection(enable);
        }
        this._showHeapInstance.setEnabled(enable);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._boundary) {
            this._traceDepth.setEnabled(this._boundary.getSelection());
            this._traceDepthLabel.setEnabled(this._boundary.getSelection());
        } else if (event.widget == this._showExecStatistic) {
            this.enableHeapInstance(this._showExecFlow.getSelection());
        } else if (event.widget == this._showExecFlow) {
            this.enableHeapInstance(this._showExecFlow.getSelection());
        } else if (event.widget == this._advancedOptions) {
            this._heapOptionGrp.setVisible(!this._heapOptionGrp.getVisible());
        }
    }

    public void setDefaultSettings() {
        this.setCPUtime(false);
        this.setExecutionBoundary(false);
        this.setCollectionDepth("1");
        this.setExecutionFlow(false);
        this.setExecutionStatistic(true);
        this.setInstance(false);
    }

    public void addStatusListener(IStatusListener statusListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(statusListener);
    }

    public class ModificationNotifier
    implements Listener {
        public void handleEvent(Event event) {
            if (ExecutionTimeUI.this.listeners == null) {
                return;
            }
            String errorMessage = null;
            if (ExecutionTimeUI.this._boundary.getSelection() && !LauncherUtility.isInputPositiveInteger(ExecutionTimeUI.this._traceDepth.getText())) {
                errorMessage = LauncherMessages.ERROR_CONFIG_EXEC_DEPTH;
            }
            int i = 0;
            int listenerSize = ExecutionTimeUI.this.listeners.size();
            while (i < listenerSize) {
                IStatusListener statusListener = (IStatusListener)ExecutionTimeUI.this.listeners.get(i);
                if (errorMessage == null) {
                    statusListener.handleOKEvent();
                } else {
                    statusListener.handleErrorEvent(errorMessage);
                }
                ++i;
            }
        }
    }
}

