/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher.defaults;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.defaults.MemoryHeapUI;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MemoryHeapProfilingType
implements IProfilingType {
    private MemoryHeapUI _optionsUI = new MemoryHeapUI();
    private Control control;
    private String description;

    public Control createControl(Composite parent, ProfilingSetsManagerCopy config) {
        this.control = this._optionsUI.createControl(parent);
        this.initializeValues(config);
        return this.control;
    }

    protected void initializeValues(ProfilingSetsManagerCopy config) {
        Map configAttributes = config.getDefaultSet().getAttributes();
        Object option = configAttributes.get(IProfileLaunchConfigurationConstants.ATTR_SHOW_HEAP_INSTANCES);
        if (option != null) {
            String instanceValue = ((ProfilingAttribute)option).getValue();
            this._optionsUI.setHeapDetails("true".equalsIgnoreCase(instanceValue));
        }
    }

    public Control getControl(String profilingSetName) {
        return this.control;
    }

    public ProfilingAttribute[] getAttributes() {
        String prefix = "SETOPTION_";
        ArrayList<ProfilingAttribute> options = new ArrayList<ProfilingAttribute>();
        String[][] heapData = Options.OPTIONS_ANALYZE_HEAP;
        int idx = 0;
        while (idx < heapData.length) {
            options.add(new ProfilingAttribute(String.valueOf(prefix) + heapData[idx][0], heapData[idx][1]));
            ++idx;
        }
        String showHeap = String.valueOf(this._optionsUI.getHeapDetails());
        options.add(new ProfilingAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_HEAP_INSTANCES, showHeap));
        ProfilingAttribute[] pOptions = new ProfilingAttribute[options.size()];
        options.toArray(pOptions);
        return pOptions;
    }

    public String validateConfiguration(ProfilingSetsManagerCopy managerCopy) {
        return null;
    }

    public String launch(ILaunchConfiguration config) {
        return null;
    }

    public String getDescription(ProfilingSetsManagerCopy managerCopy) {
        return this.description;
    }
}

