/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceOptionsUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class TraceBasePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TraceOptionsUI _options;

    public TraceBasePreferencePage() {
        this.setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UIPlugin.getPluginId()) + ".tbpp0000");
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this._options = new TraceOptionsUI(this);
        this._options.createControl(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return UIPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this._options.setInfoMsgOption(store.getDefaultBoolean("profile_tips"));
        this._options.setReloadMsgOption(store.getDefaultBoolean("reload_no_question"));
        this._options.setProjectName(store.getDefaultString("prj_name"));
        this._options.setSaveOnExitOption(CommonUITracePlugin.getDefault().getPreferenceStore().getDefaultString("save_on_exit"));
        this._options.setSwitchPerspOption(CommonUIPlugin.getDefault().getPreferenceStore().getDefaultString("switch_to_perspective"));
        this._options.setRefreshType(store.getDefaultInt("refresh_type"), store.getDefaultInt("refresh_int"));
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        UIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("prj_name", this._options.getProjectName());
        store.setValue("profile_tips", this._options.getInfoMsgOption());
        store.setValue("reload_no_question", this._options.getReloadMsgOption());
        CommonUITracePlugin.getDefault().getPreferenceStore().setValue("save_on_exit", this._options.getSaveOnExitOption());
        CommonUIPlugin.getDefault().getPreferenceStore().setValue("switch_to_perspective", this._options.getSwitchPerspOption());
        store.setValue("refresh_type", this._options.getRefreshType());
        store.setValue("refresh_int", this._options.getRefreshInterval());
    }
}

