/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.reports;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.trace.ui.internal.reports.HTMLTraceStatReportWizard;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.extension.IExportViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

public class CSVTraceStatReportWizard
extends HTMLTraceStatReportWizard {
    public CSVTraceStatReportWizard() {
        this.setWindowTitle(TraceMessages._18);
        this.FILE_EXTENSION = "csv";
    }

    public IFile generate(IProgressMonitor monitor) throws Exception {
        Object sel = this.getSelection().getFirstElement();
        if (sel == null || !(sel instanceof IExportViewer)) {
            return null;
        }
        monitor.beginTask("", 4);
        IFile reportFile = this.getReportFile();
        if (reportFile.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)CommonUIMessages._158, (String)CommonUIMessages._159)) {
            return null;
        }
        monitor.worked(1);
        this.export((IExportViewer)sel, reportFile.getLocation().toOSString());
        monitor.worked(1);
        reportFile.getProject().refreshLocal(2, null);
        monitor.done();
        return reportFile;
    }

    protected boolean export(IExportViewer viewer, String fileName) {
        File file;
        OutputStreamWriter writer;
        block17: {
            if (fileName == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)TraceMessages.TRC_MSGT, (String)TraceMessages._6);
                return false;
            }
            writer = null;
            try {
                file = new File(fileName);
                if (!file.isDirectory()) break block17;
                MessageDialog.openError((Shell)this.getShell(), (String)TraceMessages.TRC_MSGT, (String)TraceMessages._7);
                return false;
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
                return false;
            }
        }
        FileOutputStream outputStream = new FileOutputStream(file.toString(), false);
        ULocale locale = ULocale.getDefault();
        String encoding = "UTF8";
        if (locale.getLanguage() == ULocale.JAPANESE.getLanguage()) {
            encoding = "MS932";
        } else if (locale.getLanguage() == ULocale.KOREAN.getLanguage()) {
            encoding = "MS949";
        } else if (locale.getLanguage() == ULocale.CHINESE.getLanguage()) {
            if (locale.getCountry() == ULocale.TRADITIONAL_CHINESE.getCountry()) {
                encoding = "MS950_HKSCS";
            } else if (locale.getCountry() == ULocale.SIMPLIFIED_CHINESE.getCountry()) {
                encoding = "MS936";
            }
        }
        if (!System.getProperty("os.name").startsWith("Windows") && !encoding.equals("UTF8")) {
            encoding = "UTF8";
        }
        writer = new OutputStreamWriter((OutputStream)outputStream, encoding);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getCSVFormat(viewer.getViewerTitle()));
        int idx = 0;
        while (idx < viewer.getViewerControls().length) {
            if (viewer.getViewerControls()[idx] instanceof Tree) {
                buffer.append(this.printColumns((Tree)viewer.getViewerControls()[idx]));
            }
            ++idx;
        }
        try {
            writer.write(buffer.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    protected String printColumns(Tree tree) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(newLine);
        int idx = 0;
        while (idx < tree.getColumnCount()) {
            if (idx > 0) {
                buffer.append(",");
            }
            buffer.append(this.getCSVFormat(tree.getColumn(idx).getText()));
            ++idx;
        }
        this.printTreeItems(tree.getItems(), 0, buffer, tree.getColumnCount());
        return buffer.toString();
    }

    protected void printTreeItems(TreeItem[] treeItems, int level, StringBuffer buffer, int columnCount) {
        int kdx = 0;
        while (kdx < treeItems.length) {
            buffer.append(newLine);
            int ndx = 0;
            while (ndx < columnCount) {
                if (ndx > 0) {
                    buffer.append(",");
                }
                StringBuffer bf = new StringBuffer(ndx == 0 ? this.getFirstColumnIndentString(treeItems[kdx], level) : "").append(this.getCSVFormat(treeItems[kdx].getText(ndx)));
                buffer.append(this.getCSVFormat(bf.toString()));
                ++ndx;
            }
            if (treeItems[kdx].getExpanded()) {
                this.printTreeItems(treeItems[kdx].getItems(), level + 1, buffer, columnCount);
            }
            ++kdx;
        }
    }

    protected String getFirstColumnIndentString(TreeItem item, int level) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < level) {
            buffer.append("    ");
            ++i;
        }
        buffer.append("    ");
        return buffer.toString();
    }
}

